/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.directory.shared.ldap.schema.SchemaObject;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.PluginConstants;
import org.apache.directory.studio.schemaeditor.model.AttributeTypeImpl;
import org.apache.directory.studio.schemaeditor.model.ObjectClassImpl;
import org.apache.directory.studio.schemaeditor.view.wrappers.TreeNode;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class SearchViewContentProvider
implements IStructuredContentProvider,
ITreeContentProvider {
    private IPreferenceStore store = Activator.getDefault().getPreferenceStore();
    private Comparator<SchemaObject> firstNameSorter = new Comparator<SchemaObject>(){

        @Override
        public int compare(SchemaObject o1, SchemaObject o2) {
            String[] o1Names = null;
            String[] o2Names = null;
            if (o1 instanceof AttributeTypeImpl && o2 instanceof AttributeTypeImpl) {
                AttributeTypeImpl at1 = (AttributeTypeImpl)o1;
                AttributeTypeImpl at2 = (AttributeTypeImpl)o2;
                o1Names = at1.getNamesRef();
                o2Names = at2.getNamesRef();
            } else if (o1 instanceof ObjectClassImpl && o2 instanceof ObjectClassImpl) {
                ObjectClassImpl oc1 = (ObjectClassImpl)o1;
                ObjectClassImpl oc2 = (ObjectClassImpl)o2;
                o1Names = oc1.getNamesRef();
                o2Names = oc2.getNamesRef();
            } else if (o1 instanceof AttributeTypeImpl && o2 instanceof ObjectClassImpl) {
                AttributeTypeImpl at = (AttributeTypeImpl)o1;
                ObjectClassImpl oc = (ObjectClassImpl)o2;
                o1Names = at.getNamesRef();
                o2Names = oc.getNamesRef();
            } else if (o1 instanceof ObjectClassImpl && o2 instanceof AttributeTypeImpl) {
                ObjectClassImpl oc = (ObjectClassImpl)o1;
                AttributeTypeImpl at = (AttributeTypeImpl)o2;
                o1Names = oc.getNamesRef();
                o2Names = at.getNamesRef();
            }
            if (o1Names != null && o2Names != null) {
                if (o1Names.length > 0 && o2Names.length > 0) {
                    return o1Names[0].compareToIgnoreCase(o2Names[0]);
                }
                if (o1Names.length == 0 && o2Names.length > 0) {
                    return "".compareToIgnoreCase(o2Names[0]);
                }
                if (o1Names.length > 0 && o2Names.length == 0) {
                    return o1Names[0].compareToIgnoreCase("");
                }
            }
            return o1.toString().compareToIgnoreCase(o2.toString());
        }
    };
    private Comparator<SchemaObject> oidSorter = new Comparator<SchemaObject>(){

        @Override
        public int compare(SchemaObject o1, SchemaObject o2) {
            if (o1 instanceof AttributeTypeImpl && o2 instanceof AttributeTypeImpl) {
                AttributeTypeImpl at1 = (AttributeTypeImpl)o1;
                AttributeTypeImpl at2 = (AttributeTypeImpl)o2;
                return at1.getOid().compareToIgnoreCase(at2.getOid());
            }
            if (o1 instanceof ObjectClassImpl && o2 instanceof ObjectClassImpl) {
                ObjectClassImpl oc1 = (ObjectClassImpl)o1;
                ObjectClassImpl oc2 = (ObjectClassImpl)o2;
                return oc1.getOid().compareToIgnoreCase(oc2.getOid());
            }
            if (o1 instanceof AttributeTypeImpl && o2 instanceof ObjectClassImpl) {
                AttributeTypeImpl at = (AttributeTypeImpl)o1;
                ObjectClassImpl oc = (ObjectClassImpl)o2;
                return at.getOid().compareToIgnoreCase(oc.getOid());
            }
            if (o1 instanceof ObjectClassImpl && o2 instanceof AttributeTypeImpl) {
                ObjectClassImpl oc = (ObjectClassImpl)o1;
                AttributeTypeImpl at = (AttributeTypeImpl)o2;
                return oc.getOid().compareToIgnoreCase(at.getOid());
            }
            return o1.toString().compareToIgnoreCase(o2.toString());
        }
    };

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getChildren(Object parentElement) {
        ArrayList children = new ArrayList();
        int group = this.store.getInt(PluginConstants.PREFS_SEARCH_VIEW_GROUPING);
        int sortBy = this.store.getInt(PluginConstants.PREFS_SEARCH_VIEW_SORTING_BY);
        int sortOrder = this.store.getInt(PluginConstants.PREFS_SEARCH_VIEW_SORTING_ORDER);
        if (parentElement instanceof List) {
            List searchResults = (List)parentElement;
            if (group == 0) {
                ArrayList<AttributeTypeImpl> attributeTypes = new ArrayList<AttributeTypeImpl>();
                ArrayList<ObjectClassImpl> objectClasses = new ArrayList<ObjectClassImpl>();
                for (SchemaObject searchResult : searchResults) {
                    if (searchResult instanceof AttributeTypeImpl) {
                        attributeTypes.add((AttributeTypeImpl)searchResult);
                        continue;
                    }
                    if (!(searchResult instanceof ObjectClassImpl)) continue;
                    objectClasses.add((ObjectClassImpl)searchResult);
                }
                if (sortBy == 0) {
                    Collections.sort(attributeTypes, this.firstNameSorter);
                    Collections.sort(objectClasses, this.firstNameSorter);
                } else if (sortBy == 1) {
                    Collections.sort(attributeTypes, this.oidSorter);
                    Collections.sort(objectClasses, this.oidSorter);
                }
                if (sortOrder == 1) {
                    Collections.reverse(attributeTypes);
                    Collections.reverse(objectClasses);
                }
                children.addAll(attributeTypes);
                children.addAll(objectClasses);
            } else if (group == 1) {
                ArrayList<AttributeTypeImpl> attributeTypes = new ArrayList<AttributeTypeImpl>();
                ArrayList<ObjectClassImpl> objectClasses = new ArrayList<ObjectClassImpl>();
                for (SchemaObject searchResult : searchResults) {
                    if (searchResult instanceof AttributeTypeImpl) {
                        attributeTypes.add((AttributeTypeImpl)searchResult);
                        continue;
                    }
                    if (!(searchResult instanceof ObjectClassImpl)) continue;
                    objectClasses.add((ObjectClassImpl)searchResult);
                }
                if (sortBy == 0) {
                    Collections.sort(attributeTypes, this.firstNameSorter);
                    Collections.sort(objectClasses, this.firstNameSorter);
                } else if (sortBy == 1) {
                    Collections.sort(attributeTypes, this.oidSorter);
                    Collections.sort(objectClasses, this.oidSorter);
                }
                if (sortOrder == 1) {
                    Collections.reverse(attributeTypes);
                    Collections.reverse(objectClasses);
                }
                children.addAll(objectClasses);
                children.addAll(attributeTypes);
            } else if (group == 2) {
                children.addAll(searchResults);
                if (sortBy == 0) {
                    Collections.sort(children, this.firstNameSorter);
                } else if (sortBy == 1) {
                    Collections.sort(children, this.oidSorter);
                }
                if (sortOrder == 1) {
                    Collections.reverse(children);
                }
            }
        }
        return children.toArray();
    }

    public Object getParent(Object element) {
        if (element instanceof TreeNode) {
            return ((TreeNode)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof TreeNode) {
            return ((TreeNode)element).hasChildren();
        }
        return false;
    }
}

