/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.views;

import org.apache.directory.shared.ldap.schema.ObjectClassTypeEnum;
import org.apache.directory.shared.ldap.schema.SchemaObject;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.model.AttributeTypeImpl;
import org.apache.directory.studio.schemaeditor.model.ObjectClassImpl;
import org.apache.directory.studio.schemaeditor.model.schemachecker.ClassTypeHierarchyError;
import org.apache.directory.studio.schemaeditor.model.schemachecker.DifferentCollectiveAsSuperiorError;
import org.apache.directory.studio.schemaeditor.model.schemachecker.DifferentUsageAsSuperiorError;
import org.apache.directory.studio.schemaeditor.model.schemachecker.DuplicateAliasError;
import org.apache.directory.studio.schemaeditor.model.schemachecker.DuplicateOidError;
import org.apache.directory.studio.schemaeditor.model.schemachecker.NoAliasWarning;
import org.apache.directory.studio.schemaeditor.model.schemachecker.NonExistingATSuperiorError;
import org.apache.directory.studio.schemaeditor.model.schemachecker.NonExistingMandatoryATError;
import org.apache.directory.studio.schemaeditor.model.schemachecker.NonExistingMatchingRuleError;
import org.apache.directory.studio.schemaeditor.model.schemachecker.NonExistingOCSuperiorError;
import org.apache.directory.studio.schemaeditor.model.schemachecker.NonExistingOptionalATError;
import org.apache.directory.studio.schemaeditor.model.schemachecker.NonExistingSyntaxError;
import org.apache.directory.studio.schemaeditor.model.schemachecker.SchemaCheckerElement;
import org.apache.directory.studio.schemaeditor.view.views.Messages;
import org.apache.directory.studio.schemaeditor.view.wrappers.Folder;
import org.apache.directory.studio.schemaeditor.view.wrappers.SchemaErrorWrapper;
import org.apache.directory.studio.schemaeditor.view.wrappers.SchemaWarningWrapper;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;

public class ProblemsViewLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            if (element instanceof SchemaErrorWrapper) {
                return Activator.getDefault().getImage("resources/icons/problems_error.gif");
            }
            if (element instanceof SchemaWarningWrapper) {
                return Activator.getDefault().getImage("resources/icons/problems_warning.gif");
            }
            if (element instanceof Folder) {
                return Activator.getDefault().getImage("resources/icons/problems_group.gif");
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof SchemaErrorWrapper) {
            SchemaErrorWrapper errorWrapper = (SchemaErrorWrapper)element;
            if (columnIndex == 0) {
                return this.getMessage(errorWrapper.getSchemaError());
            }
            if (columnIndex == 1) {
                return this.getDisplayName(errorWrapper.getSchemaError().getSource());
            }
        } else if (element instanceof SchemaWarningWrapper) {
            SchemaWarningWrapper warningWrapper = (SchemaWarningWrapper)element;
            if (columnIndex == 0) {
                return this.getMessage(warningWrapper.getSchemaWarning());
            }
            if (columnIndex == 1) {
                String name = warningWrapper.getSchemaWarning().getSource().getName();
                if (name != null && !name.equals("")) {
                    return name;
                }
                return warningWrapper.getSchemaWarning().getSource().getOid();
            }
        } else if (element instanceof Folder) {
            Folder folder = (Folder)element;
            if (columnIndex == 0) {
                return folder.getName() + " (" + folder.getChildren().size() + ")";
            }
            return "";
        }
        return element.toString();
    }

    private String getMessage(SchemaCheckerElement element) {
        if (element instanceof DuplicateAliasError) {
            DuplicateAliasError duplicateAliasError = (DuplicateAliasError)element;
            SchemaObject duplicate = duplicateAliasError.getDuplicate();
            if (duplicate instanceof AttributeTypeImpl) {
                return NLS.bind((String)Messages.getString("ProblemsViewLabelProvider.DuplicateAliasErrorAttributeType"), (Object[])new String[]{duplicateAliasError.getAlias(), duplicate.getOid()});
            }
            if (duplicate instanceof ObjectClassImpl) {
                return NLS.bind((String)Messages.getString("ProblemsViewLabelProvider.DuplicateAliasErrorObjectClass"), (Object[])new String[]{duplicateAliasError.getAlias(), duplicate.getOid()});
            }
        } else if (element instanceof DuplicateOidError) {
            DuplicateOidError duplicateOidError = (DuplicateOidError)element;
            SchemaObject duplicate = duplicateOidError.getDuplicate();
            if (duplicate instanceof AttributeTypeImpl) {
                return NLS.bind((String)Messages.getString("ProblemsViewLabelProvider.DuplicateOidErrorAttributeType"), (Object[])new String[]{duplicateOidError.getOid(), duplicate.getName()});
            }
            if (duplicate instanceof ObjectClassImpl) {
                return NLS.bind((String)Messages.getString("ProblemsViewLabelProvider.DuplicateOidErrorObjectClass"), (Object[])new String[]{duplicateOidError.getOid(), duplicate.getName()});
            }
        } else {
            if (element instanceof NonExistingATSuperiorError) {
                NonExistingATSuperiorError nonExistingATSuperiorError = (NonExistingATSuperiorError)element;
                return NLS.bind((String)Messages.getString("ProblemsViewLabelProvider.NonExistingSuperiorAttribute"), (Object[])new String[]{nonExistingATSuperiorError.getSuperiorAlias()});
            }
            if (element instanceof NonExistingOCSuperiorError) {
                NonExistingOCSuperiorError nonExistingOCSuperiorError = (NonExistingOCSuperiorError)element;
                return NLS.bind((String)Messages.getString("ProblemsViewLabelProvider.NonExistingSuperiorObject"), (Object[])new String[]{nonExistingOCSuperiorError.getSuperiorAlias()});
            }
            if (element instanceof NonExistingMandatoryATError) {
                NonExistingMandatoryATError nonExistingMandatoryATError = (NonExistingMandatoryATError)element;
                return NLS.bind((String)Messages.getString("ProblemsViewLabelProvider.NonExistingMandatoryAttribute"), (Object[])new String[]{nonExistingMandatoryATError.getAlias()});
            }
            if (element instanceof NonExistingOptionalATError) {
                NonExistingOptionalATError nonExistingOptionalATError = (NonExistingOptionalATError)element;
                return NLS.bind((String)Messages.getString("ProblemsViewLabelProvider.NonExistingOptionalAttribute"), (Object[])new String[]{nonExistingOptionalATError.getAlias()});
            }
            if (element instanceof NonExistingSyntaxError) {
                NonExistingSyntaxError nonExistingSyntaxError = (NonExistingSyntaxError)element;
                return NLS.bind((String)Messages.getString("ProblemsViewLabelProvider.NonExistingSyntax"), (Object[])new String[]{nonExistingSyntaxError.getSyntaxOid()});
            }
            if (element instanceof NonExistingMatchingRuleError) {
                NonExistingMatchingRuleError nonExistingMatchingRuleError = (NonExistingMatchingRuleError)element;
                return NLS.bind((String)Messages.getString("ProblemsViewLabelProvider.NonExistingMatchingRule"), (Object[])new String[]{nonExistingMatchingRuleError.getMatchingRuleAlias()});
            }
            if (element instanceof NoAliasWarning) {
                NoAliasWarning noAliasWarning = (NoAliasWarning)element;
                SchemaObject source = noAliasWarning.getSource();
                if (source instanceof AttributeTypeImpl) {
                    return NLS.bind((String)Messages.getString("ProblemsViewLabelProvider.NoAliasWarningAttributeType"), (Object[])new String[]{source.getOid()});
                }
                if (source instanceof ObjectClassImpl) {
                    return NLS.bind((String)Messages.getString("ProblemsViewLabelProvider.NoAliasWarningObjectClass"), (Object[])new String[]{source.getOid()});
                }
            } else if (element instanceof ClassTypeHierarchyError) {
                ClassTypeHierarchyError classTypeHierarchyError = (ClassTypeHierarchyError)element;
                ObjectClassImpl source = (ObjectClassImpl)classTypeHierarchyError.getSource();
                ObjectClassImpl superior = (ObjectClassImpl)classTypeHierarchyError.getSuperior();
                if (source.getType().equals((Object)ObjectClassTypeEnum.ABSTRACT)) {
                    if (superior.getType().equals((Object)ObjectClassTypeEnum.STRUCTURAL)) {
                        return NLS.bind((String)Messages.getString("ProblemsViewLabelProvider.ClassTypeHierarchyErrorAbstractStructuralObject"), (Object[])new String[]{this.getDisplayName((SchemaObject)source), this.getDisplayName((SchemaObject)superior)});
                    }
                    if (superior.getType().equals((Object)ObjectClassTypeEnum.AUXILIARY)) {
                        return NLS.bind((String)Messages.getString("ProblemsViewLabelProvider.ClassTypeHierarchyErrorAbstractAuxiliaryObject"), (Object[])new String[]{this.getDisplayName((SchemaObject)source), this.getDisplayName((SchemaObject)superior)});
                    }
                } else if (source.getType().equals((Object)ObjectClassTypeEnum.AUXILIARY)) {
                    if (superior.getType().equals((Object)ObjectClassTypeEnum.STRUCTURAL)) {
                        return NLS.bind((String)Messages.getString("ProblemsViewLabelProvider.ClassTypeHierarchyErrorAuxiliaryStructuralObject"), (Object[])new String[]{this.getDisplayName((SchemaObject)source), this.getDisplayName((SchemaObject)superior)});
                    }
                    return NLS.bind((String)Messages.getString("ProblemsViewLabelProvider.ClassTypeHierarchyErrorAuxiliary"), (Object[])new String[]{this.getDisplayName((SchemaObject)source)});
                }
            } else {
                if (element instanceof DifferentUsageAsSuperiorError) {
                    DifferentUsageAsSuperiorError differentUsageAsSuperiorError = (DifferentUsageAsSuperiorError)element;
                    AttributeTypeImpl source = (AttributeTypeImpl)differentUsageAsSuperiorError.getSource();
                    AttributeTypeImpl superior = (AttributeTypeImpl)differentUsageAsSuperiorError.getSuperior();
                    return NLS.bind((String)Messages.getString("ProblemsViewLabelProvider.AttributeTypeUsage"), (Object[])new String[]{this.getDisplayName((SchemaObject)source), this.getDisplayName((SchemaObject)superior)});
                }
                if (element instanceof DifferentCollectiveAsSuperiorError) {
                    DifferentCollectiveAsSuperiorError differentCollectiveAsSuperiorError = (DifferentCollectiveAsSuperiorError)element;
                    AttributeTypeImpl source = (AttributeTypeImpl)differentCollectiveAsSuperiorError.getSource();
                    AttributeTypeImpl superior = (AttributeTypeImpl)differentCollectiveAsSuperiorError.getSuperior();
                    return NLS.bind((String)Messages.getString("ProblemsViewLabelProvider.AttributeTypeCollective"), (Object[])new String[]{this.getDisplayName((SchemaObject)source), this.getDisplayName((SchemaObject)superior)});
                }
            }
        }
        return "";
    }

    private String getDisplayName(SchemaObject so) {
        String name = so.getName();
        if (name != null && !name.equals("")) {
            return name;
        }
        return so.getOid();
    }
}

