/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.views;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.model.schemachecker.SchemaChecker;
import org.apache.directory.studio.schemaeditor.model.schemachecker.SchemaError;
import org.apache.directory.studio.schemaeditor.model.schemachecker.SchemaWarning;
import org.apache.directory.studio.schemaeditor.view.wrappers.Folder;
import org.apache.directory.studio.schemaeditor.view.wrappers.ProblemsViewRoot;
import org.apache.directory.studio.schemaeditor.view.wrappers.SchemaErrorWrapper;
import org.apache.directory.studio.schemaeditor.view.wrappers.SchemaWarningWrapper;
import org.apache.directory.studio.schemaeditor.view.wrappers.TreeNode;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ProblemsViewContentProvider
implements IStructuredContentProvider,
ITreeContentProvider {
    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getChildren(Object parentElement) {
        List<TreeNode> children = null;
        if (parentElement instanceof ProblemsViewRoot) {
            SchemaChecker schemaChecker;
            ProblemsViewRoot root = (ProblemsViewRoot)parentElement;
            if (root.getChildren().isEmpty() && (schemaChecker = Activator.getDefault().getSchemaChecker()) != null) {
                SchemaWarning[] warnings;
                SchemaError[] errors = schemaChecker.getErrors().toArray(new SchemaError[0]);
                if (errors.length != 0) {
                    Folder errorsFolder = new Folder(Folder.FolderType.ERROR, root);
                    root.addChild(errorsFolder);
                    for (SchemaError error : errors) {
                        errorsFolder.addChild(new SchemaErrorWrapper(error, errorsFolder));
                    }
                }
                if ((warnings = schemaChecker.getWarnings().toArray(new SchemaWarning[0])).length != 0) {
                    Folder warningsFolder = new Folder(Folder.FolderType.WARNING, root);
                    root.addChild(warningsFolder);
                    for (SchemaWarning warning : warnings) {
                        warningsFolder.addChild(new SchemaWarningWrapper(warning, warningsFolder));
                    }
                }
            }
            children = root.getChildren();
        } else if (parentElement instanceof Folder) {
            Folder folder = (Folder)parentElement;
            children = folder.getChildren();
        } else if (parentElement instanceof SchemaErrorWrapper) {
            children = new ArrayList<TreeNode>();
        } else if (parentElement instanceof SchemaWarningWrapper) {
            children = new ArrayList<TreeNode>();
        }
        return children.toArray();
    }

    public Object getParent(Object element) {
        if (element instanceof TreeNode) {
            return ((TreeNode)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof TreeNode) {
            return ((TreeNode)element).hasChildren();
        }
        return false;
    }
}

