/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.views;

import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.PluginConstants;
import org.apache.directory.studio.schemaeditor.model.AttributeTypeImpl;
import org.apache.directory.studio.schemaeditor.model.ObjectClassImpl;
import org.apache.directory.studio.schemaeditor.view.ViewUtils;
import org.apache.directory.studio.schemaeditor.view.views.Messages;
import org.apache.directory.studio.schemaeditor.view.wrappers.AttributeTypeWrapper;
import org.apache.directory.studio.schemaeditor.view.wrappers.ObjectClassWrapper;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class HierarchyViewLabelProvider
extends LabelProvider {
    private IPreferenceStore store = Activator.getDefault().getPreferenceStore();
    private TreeViewer viewer;

    public HierarchyViewLabelProvider(TreeViewer viewer) {
        this.viewer = viewer;
    }

    public String getText(Object obj) {
        String[] names;
        String label = "";
        int labelValue = this.store.getInt(PluginConstants.PREFS_HIERARCHY_VIEW_LABEL);
        boolean abbreviate = this.store.getBoolean(PluginConstants.PREFS_HIERARCHY_VIEW_ABBREVIATE);
        int abbreviateMaxLength = this.store.getInt(PluginConstants.PREFS_HIERARCHY_VIEW_ABBREVIATE_MAX_LENGTH);
        boolean secondaryLabelDisplay = this.store.getBoolean(PluginConstants.PREFS_HIERARCHY_VIEW_SECONDARY_LABEL_DISPLAY);
        int secondaryLabelValue = this.store.getInt(PluginConstants.PREFS_HIERARCHY_VIEW_SECONDARY_LABEL);
        boolean secondaryLabelAbbreviate = this.store.getBoolean(PluginConstants.PREFS_HIERARCHY_VIEW_SECONDARY_LABEL_ABBREVIATE);
        int secondaryLabelAbbreviateMaxLength = this.store.getInt(PluginConstants.PREFS_HIERARCHY_VIEW_SECONDARY_LABEL_ABBREVIATE_MAX_LENGTH);
        if (obj instanceof AttributeTypeWrapper) {
            AttributeTypeImpl at = ((AttributeTypeWrapper)obj).getAttributeType();
            label = labelValue == 0 ? ((names = at.getNamesRef()) != null && names.length > 0 ? names[0] : Messages.getString("HierarchyViewLabelProvider.None")) : (labelValue == 1 ? ((names = at.getNamesRef()) != null && names.length > 0 ? ViewUtils.concateAliases(names) : Messages.getString("HierarchyViewLabelProvider.None")) : (labelValue == 2 ? at.getOid() : ((names = at.getNamesRef()) != null && names.length > 0 ? names[0] : Messages.getString("HierarchyViewLabelProvider.None"))));
            if (abbreviate && abbreviateMaxLength < label.length()) {
                label = label.substring(0, abbreviateMaxLength) + "...";
            }
        } else if (obj instanceof ObjectClassWrapper) {
            ObjectClassImpl oc = ((ObjectClassWrapper)obj).getObjectClass();
            label = labelValue == 0 ? ((names = oc.getNamesRef()) != null && names.length > 0 ? names[0] : Messages.getString("HierarchyViewLabelProvider.None")) : (labelValue == 1 ? ((names = oc.getNamesRef()) != null && names.length > 0 ? ViewUtils.concateAliases(names) : Messages.getString("HierarchyViewLabelProvider.None")) : (labelValue == 2 ? oc.getOid() : ((names = oc.getNamesRef()) != null && names.length > 0 ? names[0] : Messages.getString("HierarchyViewLabelProvider.None"))));
            if (abbreviate && abbreviateMaxLength < label.length()) {
                label = label.substring(0, abbreviateMaxLength) + "...";
            }
        }
        if (secondaryLabelDisplay) {
            String secondaryLabel = "";
            if (obj instanceof AttributeTypeWrapper) {
                AttributeTypeImpl at = ((AttributeTypeWrapper)obj).getAttributeType();
                if (secondaryLabelValue == 0) {
                    String[] names2 = at.getNamesRef();
                    secondaryLabel = names2 != null && names2.length > 0 ? names2[0] : Messages.getString("HierarchyViewLabelProvider.None");
                } else if (secondaryLabelValue == 1) {
                    String[] names3 = at.getNamesRef();
                    secondaryLabel = names3 != null && names3.length > 0 ? ViewUtils.concateAliases(names3) : Messages.getString("HierarchyViewLabelProvider.None");
                } else if (secondaryLabelValue == 2) {
                    secondaryLabel = at.getOid();
                }
            } else if (obj instanceof ObjectClassWrapper) {
                ObjectClassImpl oc = ((ObjectClassWrapper)obj).getObjectClass();
                if (secondaryLabelValue == 0) {
                    String[] names4 = oc.getNamesRef();
                    secondaryLabel = names4 != null && names4.length > 0 ? names4[0] : Messages.getString("HierarchyViewLabelProvider.None");
                } else if (secondaryLabelValue == 1) {
                    String[] names5 = oc.getNamesRef();
                    secondaryLabel = names5 != null && names5.length > 0 ? ViewUtils.concateAliases(names5) : Messages.getString("HierarchyViewLabelProvider.None");
                } else if (secondaryLabelValue == 2) {
                    secondaryLabel = oc.getOid();
                }
            }
            if (secondaryLabelAbbreviate && secondaryLabelAbbreviateMaxLength < secondaryLabel.length()) {
                secondaryLabel = secondaryLabel.substring(0, secondaryLabelAbbreviateMaxLength) + "...";
            }
            label = label + "  [" + secondaryLabel + "]";
        }
        return label;
    }

    public Image getImage(Object obj) {
        if (obj instanceof AttributeTypeWrapper) {
            if (((AttributeTypeWrapper)obj).getAttributeType().equals(this.viewer.getInput())) {
                return Activator.getDefault().getImage("resources/icons/attribute_type_hierarchy_selected.gif");
            }
            return Activator.getDefault().getImage("resources/icons/attribute_type.gif");
        }
        if (obj instanceof ObjectClassWrapper) {
            if (((ObjectClassWrapper)obj).getObjectClass().equals(this.viewer.getInput())) {
                return Activator.getDefault().getImage("resources/icons/object_class_hierarchy_selected.gif");
            }
            return Activator.getDefault().getImage("resources/icons/object_class.gif");
        }
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
    }
}

