/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.editors.schema;

import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.PluginConstants;
import org.apache.directory.studio.schemaeditor.controller.SchemaListener;
import org.apache.directory.studio.schemaeditor.model.AttributeTypeImpl;
import org.apache.directory.studio.schemaeditor.model.MatchingRuleImpl;
import org.apache.directory.studio.schemaeditor.model.ObjectClassImpl;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.model.SyntaxImpl;
import org.apache.directory.studio.schemaeditor.model.io.OpenLdapSchemaFileExporter;
import org.apache.directory.studio.schemaeditor.view.editors.schema.Messages;
import org.apache.directory.studio.schemaeditor.view.editors.schema.SchemaEditor;
import org.apache.directory.studio.schemaeditor.view.widget.SchemaSourceViewer;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class SchemaEditorSourceCodePage
extends FormPage {
    public static final String ID = SchemaEditor.ID + "sourceCode";
    private Schema schema;
    private SchemaSourceViewer schemaSourceViewer;
    private SchemaListener schemaListener = new SchemaListener(){

        public void attributeTypeAdded(AttributeTypeImpl at) {
            SchemaEditorSourceCodePage.this.fillInUiFields();
        }

        public void attributeTypeModified(AttributeTypeImpl at) {
            SchemaEditorSourceCodePage.this.fillInUiFields();
        }

        public void attributeTypeRemoved(AttributeTypeImpl at) {
            SchemaEditorSourceCodePage.this.fillInUiFields();
        }

        public void matchingRuleAdded(MatchingRuleImpl mr) {
            SchemaEditorSourceCodePage.this.fillInUiFields();
        }

        public void matchingRuleModified(MatchingRuleImpl mr) {
            SchemaEditorSourceCodePage.this.fillInUiFields();
        }

        public void matchingRuleRemoved(MatchingRuleImpl mr) {
            SchemaEditorSourceCodePage.this.fillInUiFields();
        }

        public void objectClassAdded(ObjectClassImpl oc) {
            SchemaEditorSourceCodePage.this.fillInUiFields();
        }

        public void objectClassModified(ObjectClassImpl oc) {
            SchemaEditorSourceCodePage.this.fillInUiFields();
        }

        public void objectClassRemoved(ObjectClassImpl oc) {
            SchemaEditorSourceCodePage.this.fillInUiFields();
        }

        public void syntaxAdded(SyntaxImpl syntax) {
            SchemaEditorSourceCodePage.this.fillInUiFields();
        }

        public void syntaxModified(SyntaxImpl syntax) {
            SchemaEditorSourceCodePage.this.fillInUiFields();
        }

        public void syntaxRemoved(SyntaxImpl syntax) {
            SchemaEditorSourceCodePage.this.fillInUiFields();
        }
    };

    public SchemaEditorSourceCodePage(FormEditor editor) {
        super(editor, ID, Messages.getString("SchemaEditorSourceCodePage.SourceCode"));
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.schema = ((SchemaEditor)this.getEditor()).getSchema();
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        GridLayout layout = new GridLayout();
        form.getBody().setLayout((Layout)layout);
        toolkit.paintBordersFor(form.getBody());
        this.schemaSourceViewer = new SchemaSourceViewer(form.getBody(), null, null, false, 2816);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = 10;
        this.schemaSourceViewer.getTextWidget().setLayoutData((Object)gd);
        this.schemaSourceViewer.getTextWidget().setEditable(false);
        Font font = JFaceResources.getFont((String)"org.eclipse.jface.textfont");
        this.schemaSourceViewer.getTextWidget().setFont(font);
        Document document = new Document();
        this.schemaSourceViewer.setDocument((IDocument)document);
        this.fillInUiFields();
        this.addListeners();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)form, PluginConstants.PLUGIN_ID + "." + "schema_editor");
    }

    private void fillInUiFields() {
        this.schemaSourceViewer.getDocument().set(OpenLdapSchemaFileExporter.toSourceCode(this.schema));
    }

    private void addListeners() {
        Activator.getDefault().getSchemaHandler().addListener(this.schema, this.schemaListener);
    }

    private void removeListeners() {
        Activator.getDefault().getSchemaHandler().removeListener(this.schema, this.schemaListener);
    }

    public void dispose() {
        this.removeListeners();
        super.dispose();
    }
}

