/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.editors.schema;

import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.PluginConstants;
import org.apache.directory.studio.schemaeditor.PluginUtils;
import org.apache.directory.studio.schemaeditor.controller.SchemaAdapter;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandler;
import org.apache.directory.studio.schemaeditor.controller.SchemaListener;
import org.apache.directory.studio.schemaeditor.model.AttributeTypeImpl;
import org.apache.directory.studio.schemaeditor.model.ObjectClassImpl;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.view.ViewUtils;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.AttributeTypeEditor;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.AttributeTypeEditorInput;
import org.apache.directory.studio.schemaeditor.view.editors.objectclass.ObjectClassEditor;
import org.apache.directory.studio.schemaeditor.view.editors.objectclass.ObjectClassEditorInput;
import org.apache.directory.studio.schemaeditor.view.editors.schema.Messages;
import org.apache.directory.studio.schemaeditor.view.editors.schema.SchemaEditor;
import org.apache.directory.studio.schemaeditor.view.editors.schema.SchemaEditorTableViewerContentProvider;
import org.apache.directory.studio.schemaeditor.view.editors.schema.SchemaEditorTableViewerLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class SchemaEditorOverviewPage
extends FormPage {
    public static final String ID = SchemaEditor.ID + "overviewPage";
    private SchemaHandler schemaHandler;
    private Schema schema;
    private SchemaListener schemaListener = new SchemaAdapter(){

        public void attributeTypeAdded(AttributeTypeImpl at) {
            SchemaEditorOverviewPage.this.fillInUiFields();
        }

        public void attributeTypeModified(AttributeTypeImpl at) {
            SchemaEditorOverviewPage.this.fillInUiFields();
        }

        public void attributeTypeRemoved(AttributeTypeImpl at) {
            SchemaEditorOverviewPage.this.fillInUiFields();
        }

        public void objectClassAdded(ObjectClassImpl oc) {
            SchemaEditorOverviewPage.this.fillInUiFields();
        }

        public void objectClassModified(ObjectClassImpl oc) {
            SchemaEditorOverviewPage.this.fillInUiFields();
        }

        public void objectClassRemoved(ObjectClassImpl oc) {
            SchemaEditorOverviewPage.this.fillInUiFields();
        }
    };
    private TableViewer attributeTypesTableViewer;
    private TableViewer objectClassesTableViewer;
    private IDoubleClickListener attributeTypesTableViewerListener = new IDoubleClickListener(){

        public void doubleClick(DoubleClickEvent event) {
            StructuredSelection selection = (StructuredSelection)event.getSelection();
            if (!selection.isEmpty()) {
                AttributeTypeImpl at = (AttributeTypeImpl)((Object)selection.getFirstElement());
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new AttributeTypeEditorInput(at), AttributeTypeEditor.ID);
                }
                catch (PartInitException exception) {
                    PluginUtils.logError(Messages.getString("SchemaEditorOverviewPage.ErrorOpenEditor"), exception);
                    ViewUtils.displayErrorMessageBox(Messages.getString("SchemaEditorOverviewPage.Error"), Messages.getString("SchemaEditorOverviewPage.ErrorOpenEditor"));
                }
            }
        }
    };
    private IDoubleClickListener objectClassesTableViewerListener = new IDoubleClickListener(){

        public void doubleClick(DoubleClickEvent event) {
            StructuredSelection selection = (StructuredSelection)event.getSelection();
            if (!selection.isEmpty()) {
                ObjectClassImpl oc = (ObjectClassImpl)((Object)selection.getFirstElement());
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new ObjectClassEditorInput(oc), ObjectClassEditor.ID);
                }
                catch (PartInitException exception) {
                    PluginUtils.logError(Messages.getString("SchemaEditorOverviewPage.ErrorOpenEditor"), exception);
                    ViewUtils.displayErrorMessageBox(Messages.getString("SchemaEditorOverviewPage.Error"), Messages.getString("SchemaEditorOverviewPage.ErrorOpenEditor"));
                }
            }
        }
    };

    public SchemaEditorOverviewPage(FormEditor editor) {
        super(editor, ID, Messages.getString("SchemaEditorOverviewPage.Overview"));
        this.schemaHandler = Activator.getDefault().getSchemaHandler();
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.schema = ((SchemaEditor)this.getEditor()).getSchema();
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        GridLayout layout = new GridLayout(2, true);
        form.getBody().setLayout((Layout)layout);
        this.createAttributeTypesSection(form.getBody(), toolkit);
        this.createObjectClassesSection(form.getBody(), toolkit);
        this.fillInUiFields();
        this.addListeners();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)form, PluginConstants.PLUGIN_ID + "." + "schema_editor");
    }

    private void createAttributeTypesSection(Composite parent, FormToolkit toolkit) {
        Section attributeTypesSection = toolkit.createSection(parent, 448);
        attributeTypesSection.setDescription(NLS.bind((String)Messages.getString("SchemaEditorOverviewPage.SchemaAttribute"), (Object[])new String[]{this.schema.getName()}));
        attributeTypesSection.setText(Messages.getString("SchemaEditorOverviewPage.AttributeTypes"));
        Composite attributeTypesSectionClient = toolkit.createComposite((Composite)attributeTypesSection);
        attributeTypesSectionClient.setLayout((Layout)new GridLayout());
        toolkit.paintBordersFor(attributeTypesSectionClient);
        attributeTypesSection.setClient((Control)attributeTypesSectionClient);
        attributeTypesSection.setLayoutData((Object)new GridData(4, 4, true, true));
        this.attributeTypesTableViewer = new TableViewer(attributeTypesSectionClient, 2820);
        this.attributeTypesTableViewer.setContentProvider((IContentProvider)new SchemaEditorTableViewerContentProvider());
        this.attributeTypesTableViewer.setLabelProvider((IBaseLabelProvider)new SchemaEditorTableViewerLabelProvider());
        this.attributeTypesTableViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
    }

    private void createObjectClassesSection(Composite parent, FormToolkit toolkit) {
        Section objectClassesSection = toolkit.createSection(parent, 448);
        objectClassesSection.setDescription(NLS.bind((String)Messages.getString("SchemaEditorOverviewPage.SchemaObjectClasses"), (Object[])new String[]{this.schema.getName()}));
        objectClassesSection.setText(Messages.getString("SchemaEditorOverviewPage.ObjectClasses"));
        Composite objectClassesSectionClient = toolkit.createComposite((Composite)objectClassesSection);
        objectClassesSectionClient.setLayout((Layout)new GridLayout());
        toolkit.paintBordersFor(objectClassesSectionClient);
        objectClassesSection.setClient((Control)objectClassesSectionClient);
        objectClassesSection.setLayoutData((Object)new GridData(4, 4, true, true));
        this.objectClassesTableViewer = new TableViewer(objectClassesSectionClient, 2820);
        this.objectClassesTableViewer.setContentProvider((IContentProvider)new SchemaEditorTableViewerContentProvider());
        this.objectClassesTableViewer.setLabelProvider((IBaseLabelProvider)new SchemaEditorTableViewerLabelProvider());
        this.objectClassesTableViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
    }

    private void fillInUiFields() {
        this.attributeTypesTableViewer.setInput(this.schema.getAttributeTypes());
        this.objectClassesTableViewer.setInput(this.schema.getObjectClasses());
    }

    private void addListeners() {
        this.schemaHandler.addListener(this.schema, this.schemaListener);
        this.attributeTypesTableViewer.addDoubleClickListener(this.attributeTypesTableViewerListener);
        this.objectClassesTableViewer.addDoubleClickListener(this.objectClassesTableViewerListener);
    }

    private void removeListeners() {
        this.schemaHandler.removeListener(this.schema, this.schemaListener);
        this.attributeTypesTableViewer.removeDoubleClickListener(this.attributeTypesTableViewerListener);
        this.objectClassesTableViewer.removeDoubleClickListener(this.objectClassesTableViewerListener);
    }

    public void dispose() {
        this.removeListeners();
        super.dispose();
    }
}

