/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.editors.schema;

import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.PluginConstants;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandlerAdapter;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandlerListener;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.view.editors.schema.SchemaEditorInput;
import org.apache.directory.studio.schemaeditor.view.editors.schema.SchemaEditorOverviewPage;
import org.apache.directory.studio.schemaeditor.view.editors.schema.SchemaEditorSourceCodePage;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;

public class SchemaEditor
extends FormEditor {
    private static Logger logger = Logger.getLogger(SchemaEditor.class);
    public static final String ID = PluginConstants.EDITOR_SCHEMA_ID;
    private SchemaEditor instance;
    private SchemaEditorOverviewPage overview;
    private SchemaEditorSourceCodePage sourceCode;
    private Schema schema;
    private SchemaHandlerListener schemaHandlerListener = new SchemaHandlerAdapter(){

        public void schemaRemoved(Schema s) {
            if (SchemaEditor.this.schema.equals(s)) {
                SchemaEditor.this.getEditorSite().getPage().closeEditor((IEditorPart)SchemaEditor.this.instance, false);
            }
        }
    };

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.instance = this;
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setPartName(input.getName());
        this.schema = ((SchemaEditorInput)this.getEditorInput()).getSchema();
        Activator.getDefault().getSchemaHandler().addListener(this.schemaHandlerListener);
    }

    protected void addPages() {
        try {
            this.overview = new SchemaEditorOverviewPage(this);
            this.addPage((IFormPage)this.overview);
            this.sourceCode = new SchemaEditorSourceCodePage(this);
            this.addPage((IFormPage)this.sourceCode);
        }
        catch (PartInitException e) {
            logger.debug((Object)"error when adding pages");
        }
    }

    public void dispose() {
        Activator.getDefault().getSchemaHandler().removeListener(this.schemaHandlerListener);
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public Schema getSchema() {
        return this.schema;
    }
}

