/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.editors.objectclass;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandler;
import org.apache.directory.studio.schemaeditor.model.ObjectClassImpl;
import org.apache.directory.studio.schemaeditor.view.editors.NonExistingObjectClass;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ObjectClassEditorSuperiorsTableContentProvider
implements IStructuredContentProvider {
    private SchemaHandler schemaHandler = Activator.getDefault().getSchemaHandler();

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof String[]) {
            String[] superiors;
            ArrayList<Object> results = new ArrayList<Object>();
            for (String superior : superiors = (String[])inputElement) {
                ObjectClassImpl oc = this.schemaHandler.getObjectClass(superior);
                if (oc != null) {
                    results.add((Object)oc);
                    continue;
                }
                results.add(new NonExistingObjectClass(superior));
            }
            Collections.sort(results, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    if (o1 instanceof ObjectClassImpl && o2 instanceof ObjectClassImpl) {
                        String[] oc1Names = ((ObjectClassImpl)((Object)o1)).getNamesRef();
                        String[] oc2Names = ((ObjectClassImpl)((Object)o2)).getNamesRef();
                        if (oc1Names != null && oc2Names != null && oc1Names.length > 0 && oc2Names.length > 0) {
                            return oc1Names[0].compareToIgnoreCase(oc2Names[0]);
                        }
                    } else if (o1 instanceof ObjectClassImpl && o2 instanceof NonExistingObjectClass) {
                        String[] oc1Names = ((ObjectClassImpl)((Object)o1)).getNamesRef();
                        String oc2Name = ((NonExistingObjectClass)o2).getName();
                        if (oc1Names != null && oc2Name != null && oc1Names.length > 0) {
                            return oc1Names[0].compareToIgnoreCase(oc2Name);
                        }
                    } else if (o1 instanceof NonExistingObjectClass && o2 instanceof ObjectClassImpl) {
                        String oc1Name = ((NonExistingObjectClass)o1).getName();
                        String[] oc2Names = ((ObjectClassImpl)((Object)o2)).getNamesRef();
                        if (oc1Name != null && oc2Names != null && oc2Names.length > 0) {
                            return oc1Name.compareToIgnoreCase(oc2Names[0]);
                        }
                    } else if (o1 instanceof NonExistingObjectClass && o2 instanceof NonExistingObjectClass) {
                        String oc1Name = ((NonExistingObjectClass)o1).getName();
                        String oc2Name = ((NonExistingObjectClass)o2).getName();
                        if (oc1Name != null && oc2Name != null) {
                            return oc1Name.compareToIgnoreCase(oc2Name);
                        }
                    }
                    return 0;
                }
            });
            return results.toArray();
        }
        return null;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

