/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.editors.objectclass;

import java.io.IOException;
import java.text.ParseException;
import java.util.List;
import org.apache.directory.shared.ldap.schema.parsers.ObjectClassLiteral;
import org.apache.directory.shared.ldap.schema.parsers.OpenLdapSchemaParser;
import org.apache.directory.studio.schemaeditor.PluginConstants;
import org.apache.directory.studio.schemaeditor.model.ObjectClassImpl;
import org.apache.directory.studio.schemaeditor.model.io.OpenLdapSchemaFileExporter;
import org.apache.directory.studio.schemaeditor.view.editors.objectclass.ObjectClassEditor;
import org.apache.directory.studio.schemaeditor.view.widget.SchemaSourceViewer;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class ObjectClassEditorSourceCodePage
extends FormPage {
    public static final String ID = ObjectClassEditor.ID + "sourceCodePage";
    public static final String TITLE = "Source Code";
    private ObjectClassImpl modifiedObjectClass;
    private SchemaSourceViewer schemaSourceViewer;
    private boolean canLeaveThePage = true;
    private ModifyListener schemaSourceViewerListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            ObjectClassEditorSourceCodePage.this.canLeaveThePage = true;
            try {
                ((ObjectClassEditor)ObjectClassEditorSourceCodePage.this.getEditor()).setDirty(true);
                OpenLdapSchemaParser parser = new OpenLdapSchemaParser();
                parser.parse(ObjectClassEditorSourceCodePage.this.schemaSourceViewer.getTextWidget().getText());
                List objectclasses = parser.getObjectClassTypes();
                if (objectclasses.size() == 1) {
                    ObjectClassEditorSourceCodePage.this.updateObjectClass((ObjectClassLiteral)objectclasses.get(0));
                }
            }
            catch (IOException e1) {
                ObjectClassEditorSourceCodePage.this.canLeaveThePage = false;
            }
            catch (ParseException exception) {
                ObjectClassEditorSourceCodePage.this.canLeaveThePage = false;
            }
        }
    };

    public ObjectClassEditorSourceCodePage(FormEditor editor) {
        super(editor, ID, TITLE);
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        form.getBody().setLayout((Layout)layout);
        toolkit.paintBordersFor(form.getBody());
        this.modifiedObjectClass = ((ObjectClassEditor)this.getEditor()).getModifiedObjectClass();
        this.schemaSourceViewer = new SchemaSourceViewer(form.getBody(), null, null, false, 2816);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = 10;
        this.schemaSourceViewer.getTextWidget().setLayoutData((Object)gd);
        Font font = JFaceResources.getFont((String)"org.eclipse.jface.textfont");
        this.schemaSourceViewer.getTextWidget().setFont(font);
        Document document = new Document();
        this.schemaSourceViewer.setDocument((IDocument)document);
        this.fillInUiFields();
        this.schemaSourceViewer.getTextWidget().addModifyListener(this.schemaSourceViewerListener);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)form, PluginConstants.PLUGIN_ID + "." + "object_class_editor");
    }

    private void fillInUiFields() {
        this.schemaSourceViewer.getDocument().set(OpenLdapSchemaFileExporter.toSourceCode(this.modifiedObjectClass));
    }

    public boolean canLeaveThePage() {
        return this.canLeaveThePage;
    }

    private void updateObjectClass(ObjectClassLiteral ocl) {
        this.modifiedObjectClass.setDescription(ocl.getDescription());
        this.modifiedObjectClass.setMayNamesList(ocl.getMay());
        this.modifiedObjectClass.setMustNamesList(ocl.getMust());
        this.modifiedObjectClass.setNames(ocl.getNames());
        this.modifiedObjectClass.setObsolete(ocl.isObsolete());
        this.modifiedObjectClass.setOid(ocl.getOid());
        this.modifiedObjectClass.setSuperClassesNames(ocl.getSuperiors());
        this.modifiedObjectClass.setType(ocl.getClassType());
    }

    public void refreshUI() {
        this.fillInUiFields();
    }
}

