/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.editors.objectclass;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.shared.asn1.primitives.OID;
import org.apache.directory.shared.ldap.schema.ObjectClassTypeEnum;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.PluginConstants;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandler;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandlerListener;
import org.apache.directory.studio.schemaeditor.model.AttributeTypeImpl;
import org.apache.directory.studio.schemaeditor.model.MatchingRuleImpl;
import org.apache.directory.studio.schemaeditor.model.ObjectClassImpl;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.model.SyntaxImpl;
import org.apache.directory.studio.schemaeditor.model.alias.Alias;
import org.apache.directory.studio.schemaeditor.model.alias.AliasWithError;
import org.apache.directory.studio.schemaeditor.model.alias.AliasesStringParser;
import org.apache.directory.studio.schemaeditor.view.ViewUtils;
import org.apache.directory.studio.schemaeditor.view.dialogs.AttributeTypeSelectionDialog;
import org.apache.directory.studio.schemaeditor.view.dialogs.EditAliasesDialog;
import org.apache.directory.studio.schemaeditor.view.dialogs.ObjectClassSelectionDialog;
import org.apache.directory.studio.schemaeditor.view.editors.NonExistingAttributeType;
import org.apache.directory.studio.schemaeditor.view.editors.NonExistingObjectClass;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.AttributeTypeEditor;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.AttributeTypeEditorInput;
import org.apache.directory.studio.schemaeditor.view.editors.objectclass.Messages;
import org.apache.directory.studio.schemaeditor.view.editors.objectclass.ObjectClassEditor;
import org.apache.directory.studio.schemaeditor.view.editors.objectclass.ObjectClassEditorAttributesTableContentProvider;
import org.apache.directory.studio.schemaeditor.view.editors.objectclass.ObjectClassEditorAttributesTableLabelProvider;
import org.apache.directory.studio.schemaeditor.view.editors.objectclass.ObjectClassEditorInput;
import org.apache.directory.studio.schemaeditor.view.editors.objectclass.ObjectClassEditorSuperiorsTableContentProvider;
import org.apache.directory.studio.schemaeditor.view.editors.objectclass.ObjectClassEditorSuperiorsTableLabelProvider;
import org.apache.directory.studio.schemaeditor.view.editors.schema.SchemaEditor;
import org.apache.directory.studio.schemaeditor.view.editors.schema.SchemaEditorInput;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class ObjectClassEditorOverviewPage
extends FormPage {
    public static final String ID = ObjectClassEditor.ID + "overviewPage";
    private ObjectClassImpl originalObjectClass;
    private ObjectClassImpl modifiedObjectClass;
    private Schema originalSchema;
    private SchemaHandler schemaHandler;
    private SchemaHandlerListener schemaHandlerListener = new SchemaHandlerListener(){

        public void attributeTypeAdded(AttributeTypeImpl at) {
            ObjectClassEditorOverviewPage.this.refreshUI();
        }

        public void attributeTypeModified(AttributeTypeImpl at) {
            ObjectClassEditorOverviewPage.this.refreshUI();
        }

        public void attributeTypeRemoved(AttributeTypeImpl at) {
            ObjectClassEditorOverviewPage.this.refreshUI();
        }

        public void matchingRuleAdded(MatchingRuleImpl mr) {
            ObjectClassEditorOverviewPage.this.refreshUI();
        }

        public void matchingRuleModified(MatchingRuleImpl mr) {
            ObjectClassEditorOverviewPage.this.refreshUI();
        }

        public void matchingRuleRemoved(MatchingRuleImpl mr) {
            ObjectClassEditorOverviewPage.this.refreshUI();
        }

        public void objectClassAdded(ObjectClassImpl oc) {
            ObjectClassEditorOverviewPage.this.refreshUI();
        }

        public void objectClassModified(ObjectClassImpl oc) {
            ObjectClassEditorOverviewPage.this.refreshUI();
        }

        public void objectClassRemoved(ObjectClassImpl oc) {
            if (!oc.equals((Object)ObjectClassEditorOverviewPage.this.originalObjectClass)) {
                ObjectClassEditorOverviewPage.this.refreshUI();
            }
        }

        public void schemaAdded(Schema schema) {
            ObjectClassEditorOverviewPage.this.refreshUI();
        }

        public void schemaRemoved(Schema schema) {
            if (!schema.equals(ObjectClassEditorOverviewPage.this.originalSchema)) {
                ObjectClassEditorOverviewPage.this.refreshUI();
            }
        }

        public void syntaxAdded(SyntaxImpl syntax) {
            ObjectClassEditorOverviewPage.this.refreshUI();
        }

        public void syntaxModified(SyntaxImpl syntax) {
            ObjectClassEditorOverviewPage.this.refreshUI();
        }

        public void syntaxRemoved(SyntaxImpl syntax) {
            ObjectClassEditorOverviewPage.this.refreshUI();
        }
    };
    private Text aliasesText;
    private Button aliasesButton;
    private Text oidText;
    private Hyperlink schemaLink;
    private Label schemaLabel;
    private Text descriptionText;
    private Table superiorsTable;
    private TableViewer superiorsTableViewer;
    private Button addButtonSuperiorsTable;
    private Button removeButtonSuperiorsTable;
    private Combo classTypeCombo;
    private Button obsoleteCheckbox;
    private Table mandatoryAttributesTable;
    private TableViewer mandatoryAttributesTableViewer;
    private Button addButtonMandatoryTable;
    private Button removeButtonMandatoryTable;
    private Table optionalAttributesTable;
    private TableViewer optionalAttributesTableViewer;
    private Button addButtonOptionalTable;
    private Button removeButtonOptionalTable;
    private ModifyListener aliasesTextModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            AliasesStringParser parser = new AliasesStringParser();
            parser.parse(ObjectClassEditorOverviewPage.this.aliasesText.getText());
            List<Alias> parsedAliases = parser.getAliases();
            ObjectClassEditorOverviewPage.this.modifiedObjectClass.setNames(new String[0]);
            ArrayList<String> aliasesList = new ArrayList<String>();
            for (Alias parsedAlias : parsedAliases) {
                if (parsedAlias instanceof AliasWithError) continue;
                aliasesList.add(parsedAlias.getAlias());
            }
            ObjectClassEditorOverviewPage.this.modifiedObjectClass.setNames(aliasesList.toArray(new String[0]));
            ObjectClassEditorOverviewPage.this.setEditorDirty();
        }
    };
    private SelectionAdapter aliasesButtonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            EditAliasesDialog editDialog = new EditAliasesDialog(ObjectClassEditorOverviewPage.this.modifiedObjectClass.getNamesRef());
            if (editDialog.open() != 0) {
                return;
            }
            if (editDialog.isDirty()) {
                ObjectClassEditorOverviewPage.this.modifiedObjectClass.setNames(editDialog.getAliases());
                if (ObjectClassEditorOverviewPage.this.modifiedObjectClass.getNamesRef() != null && ObjectClassEditorOverviewPage.this.modifiedObjectClass.getNamesRef().length != 0) {
                    ObjectClassEditorOverviewPage.this.aliasesText.setText(ViewUtils.concateAliases(ObjectClassEditorOverviewPage.this.modifiedObjectClass.getNamesRef()));
                } else {
                    ObjectClassEditorOverviewPage.this.aliasesText.setText("");
                }
                ObjectClassEditorOverviewPage.this.setEditorDirty();
            }
        }
    };
    private ModifyListener oidTextModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            ObjectClassEditorOverviewPage.this.oidText.setForeground(ViewUtils.COLOR_BLACK);
            ObjectClassEditorOverviewPage.this.oidText.setToolTipText("");
            String oid = ObjectClassEditorOverviewPage.this.oidText.getText();
            if (OID.isOID((String)oid)) {
                if (ObjectClassEditorOverviewPage.this.originalObjectClass.getOid().equals(oid) || !ObjectClassEditorOverviewPage.this.schemaHandler.isAliasOrOidAlreadyTaken(oid)) {
                    ObjectClassEditorOverviewPage.this.modifiedObjectClass.setOid(oid);
                    ObjectClassEditorOverviewPage.this.setEditorDirty();
                } else {
                    ObjectClassEditorOverviewPage.this.oidText.setForeground(ViewUtils.COLOR_RED);
                    ObjectClassEditorOverviewPage.this.oidText.setToolTipText(Messages.getString("ObjectClassEditorOverviewPage.ElementOIDExists"));
                }
            } else {
                ObjectClassEditorOverviewPage.this.oidText.setForeground(ViewUtils.COLOR_RED);
                ObjectClassEditorOverviewPage.this.oidText.setToolTipText(Messages.getString("ObjectClassEditorOverviewPage.MalformedOID"));
            }
        }
    };
    private VerifyListener oidTextVerifyListener = new VerifyListener(){

        public void verifyText(VerifyEvent e) {
            if (!e.text.matches("([0-9]*\\.?)*")) {
                e.doit = false;
            }
        }
    };
    private HyperlinkAdapter schemaLinkListener = new HyperlinkAdapter(){

        public void linkActivated(HyperlinkEvent e) {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            SchemaEditorInput input = new SchemaEditorInput(ObjectClassEditorOverviewPage.this.schemaHandler.getSchema(ObjectClassEditorOverviewPage.this.modifiedObjectClass.getSchema()));
            String editorId = SchemaEditor.ID;
            try {
                page.openEditor((IEditorInput)input, editorId);
            }
            catch (PartInitException exception) {
                Logger.getLogger(ObjectClassEditorOverviewPage.class).debug((Object)"error when opening the editor");
            }
        }
    };
    private ModifyListener descriptionTextListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            int caretPosition = ObjectClassEditorOverviewPage.this.descriptionText.getCaretPosition();
            ObjectClassEditorOverviewPage.this.modifiedObjectClass.setDescription(ObjectClassEditorOverviewPage.this.descriptionText.getText());
            ObjectClassEditorOverviewPage.this.descriptionText.setSelection(caretPosition);
            ObjectClassEditorOverviewPage.this.setEditorDirty();
        }
    };
    private ModifyListener classTypeListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            if (ObjectClassEditorOverviewPage.this.classTypeCombo.getSelectionIndex() == 0) {
                ObjectClassEditorOverviewPage.this.modifiedObjectClass.setType(ObjectClassTypeEnum.ABSTRACT);
            } else if (ObjectClassEditorOverviewPage.this.classTypeCombo.getSelectionIndex() == 1) {
                ObjectClassEditorOverviewPage.this.modifiedObjectClass.setType(ObjectClassTypeEnum.AUXILIARY);
            } else if (ObjectClassEditorOverviewPage.this.classTypeCombo.getSelectionIndex() == 2) {
                ObjectClassEditorOverviewPage.this.modifiedObjectClass.setType(ObjectClassTypeEnum.STRUCTURAL);
            }
            ObjectClassEditorOverviewPage.this.setEditorDirty();
        }
    };
    private SelectionAdapter obsoleteListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            ObjectClassEditorOverviewPage.this.modifiedObjectClass.setObsolete(ObjectClassEditorOverviewPage.this.obsoleteCheckbox.getSelection());
            ObjectClassEditorOverviewPage.this.setEditorDirty();
        }
    };
    private MouseListener mandatoryAttributesTableListener = new MouseListener(){

        public void mouseDoubleClick(MouseEvent e) {
            StructuredSelection selection = (StructuredSelection)ObjectClassEditorOverviewPage.this.mandatoryAttributesTableViewer.getSelection();
            if (selection.isEmpty()) {
                return;
            }
            Object selectedElement = selection.getFirstElement();
            if (selectedElement != null && selectedElement instanceof AttributeTypeImpl) {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    page.openEditor((IEditorInput)new AttributeTypeEditorInput((AttributeTypeImpl)((Object)selectedElement)), AttributeTypeEditor.ID);
                }
                catch (PartInitException exception) {
                    Logger.getLogger(ObjectClassEditorOverviewPage.class).debug((Object)"error when opening the editor");
                }
            }
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
            ObjectClassEditorOverviewPage.this.removeButtonMandatoryTable.setEnabled(ObjectClassEditorOverviewPage.this.mandatoryAttributesTable.getSelection().length != 0);
        }
    };
    private SelectionAdapter addButtonMandatoryTableListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            String[] names;
            AttributeTypeSelectionDialog dialog = new AttributeTypeSelectionDialog();
            ArrayList<AttributeTypeImpl> hiddenATs = new ArrayList<AttributeTypeImpl>();
            String[] mustsHidden = ObjectClassEditorOverviewPage.this.modifiedObjectClass.getMustNamesList();
            if (mustsHidden != null) {
                for (String must : mustsHidden) {
                    AttributeTypeImpl at = ObjectClassEditorOverviewPage.this.schemaHandler.getAttributeType(must);
                    if (at == null) continue;
                    hiddenATs.add(at);
                }
            }
            dialog.setHiddenAttributeTypes(hiddenATs.toArray(new AttributeTypeImpl[0]));
            if (dialog.open() != 0) {
                return;
            }
            AttributeTypeImpl at = dialog.getSelectedAttributeType();
            if (at == null) {
                return;
            }
            ArrayList<String> newMusts = new ArrayList<String>();
            String[] musts = ObjectClassEditorOverviewPage.this.modifiedObjectClass.getMustNamesList();
            if (musts != null) {
                for (String must : musts) {
                    newMusts.add(must);
                }
            }
            if ((names = at.getNamesRef()) != null && names.length > 0) {
                newMusts.add(names[0]);
            } else {
                newMusts.add(at.getOid());
            }
            ObjectClassEditorOverviewPage.this.modifiedObjectClass.setMustNamesList(newMusts.toArray(new String[0]));
            ObjectClassEditorOverviewPage.this.fillInMandatoryAttributesTable();
            ObjectClassEditorOverviewPage.this.setEditorDirty();
        }
    };
    private SelectionAdapter removeButtonMandatoryTableListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            StructuredSelection selection = (StructuredSelection)ObjectClassEditorOverviewPage.this.mandatoryAttributesTableViewer.getSelection();
            if (selection.isEmpty()) {
                return;
            }
            Object selectedElement = selection.getFirstElement();
            if (selectedElement != null) {
                String[] musts;
                ArrayList<String> newMusts = new ArrayList<String>();
                for (String must : musts = ObjectClassEditorOverviewPage.this.modifiedObjectClass.getMustNamesList()) {
                    newMusts.add(must);
                }
                if (selectedElement instanceof AttributeTypeImpl) {
                    for (String name : ((AttributeTypeImpl)((Object)selectedElement)).getNamesRef()) {
                        newMusts.remove(name);
                    }
                } else if (selectedElement instanceof NonExistingAttributeType) {
                    newMusts.remove(((NonExistingAttributeType)selectedElement).getName());
                }
                ObjectClassEditorOverviewPage.this.modifiedObjectClass.setMustNamesList(newMusts.toArray(new String[0]));
                ObjectClassEditorOverviewPage.this.fillInMandatoryAttributesTable();
                ObjectClassEditorOverviewPage.this.addButtonMandatoryTable.setFocus();
                ObjectClassEditorOverviewPage.this.removeButtonMandatoryTable.setEnabled(ObjectClassEditorOverviewPage.this.mandatoryAttributesTable.getSelection().length != 0);
                ObjectClassEditorOverviewPage.this.setEditorDirty();
            }
        }
    };
    private MouseListener optionalAttributesTableListener = new MouseAdapter(){

        public void mouseDoubleClick(MouseEvent e) {
            StructuredSelection selection = (StructuredSelection)ObjectClassEditorOverviewPage.this.optionalAttributesTableViewer.getSelection();
            if (selection.isEmpty()) {
                return;
            }
            Object selectedElement = selection.getFirstElement();
            if (selectedElement != null && selectedElement instanceof AttributeTypeImpl) {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    page.openEditor((IEditorInput)new AttributeTypeEditorInput((AttributeTypeImpl)((Object)selectedElement)), AttributeTypeEditor.ID);
                }
                catch (PartInitException exception) {
                    Logger.getLogger(ObjectClassEditorOverviewPage.class).debug((Object)"error when opening the editor");
                }
            }
        }

        public void mouseUp(MouseEvent e) {
            ObjectClassEditorOverviewPage.this.removeButtonOptionalTable.setEnabled(ObjectClassEditorOverviewPage.this.optionalAttributesTable.getSelection().length != 0);
        }
    };
    private SelectionAdapter addButtonOptionalTableListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            String[] names;
            AttributeTypeSelectionDialog dialog = new AttributeTypeSelectionDialog();
            ArrayList<AttributeTypeImpl> hiddenATs = new ArrayList<AttributeTypeImpl>();
            String[] maysHidden = ObjectClassEditorOverviewPage.this.modifiedObjectClass.getMayNamesList();
            if (maysHidden != null) {
                for (String may : maysHidden) {
                    AttributeTypeImpl at = ObjectClassEditorOverviewPage.this.schemaHandler.getAttributeType(may);
                    if (at == null) continue;
                    hiddenATs.add(at);
                }
            }
            dialog.setHiddenAttributeTypes(hiddenATs.toArray(new AttributeTypeImpl[0]));
            if (dialog.open() != 0) {
                return;
            }
            AttributeTypeImpl at = dialog.getSelectedAttributeType();
            if (at == null) {
                return;
            }
            ArrayList<String> newMays = new ArrayList<String>();
            String[] mays = ObjectClassEditorOverviewPage.this.modifiedObjectClass.getMayNamesList();
            if (mays != null) {
                for (String may : mays) {
                    newMays.add(may);
                }
            }
            if ((names = at.getNamesRef()) != null && names.length > 0) {
                newMays.add(names[0]);
            } else {
                newMays.add(at.getOid());
            }
            ObjectClassEditorOverviewPage.this.modifiedObjectClass.setMayNamesList(newMays.toArray(new String[0]));
            ObjectClassEditorOverviewPage.this.fillInOptionalAttributesTable();
            ObjectClassEditorOverviewPage.this.setEditorDirty();
        }
    };
    private SelectionAdapter removeButtonOptionalTableListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            StructuredSelection selection = (StructuredSelection)ObjectClassEditorOverviewPage.this.optionalAttributesTableViewer.getSelection();
            if (selection.isEmpty()) {
                return;
            }
            Object selectedElement = selection.getFirstElement();
            if (selectedElement != null) {
                String[] mays;
                ArrayList<String> newMays = new ArrayList<String>();
                for (String may : mays = ObjectClassEditorOverviewPage.this.modifiedObjectClass.getMayNamesList()) {
                    newMays.add(may);
                }
                if (selectedElement instanceof AttributeTypeImpl) {
                    for (String name : ((AttributeTypeImpl)((Object)selectedElement)).getNamesRef()) {
                        newMays.remove(name);
                    }
                } else if (selectedElement instanceof NonExistingAttributeType) {
                    newMays.remove(((NonExistingAttributeType)selectedElement).getName());
                }
                ObjectClassEditorOverviewPage.this.modifiedObjectClass.setMayNamesList(newMays.toArray(new String[0]));
                ObjectClassEditorOverviewPage.this.fillInOptionalAttributesTable();
                ObjectClassEditorOverviewPage.this.addButtonOptionalTable.setFocus();
                ObjectClassEditorOverviewPage.this.removeButtonOptionalTable.setEnabled(ObjectClassEditorOverviewPage.this.optionalAttributesTable.getSelection().length != 0);
                ObjectClassEditorOverviewPage.this.setEditorDirty();
            }
        }
    };
    private MouseListener superiorsTableListener = new MouseAdapter(){

        public void mouseDoubleClick(MouseEvent e) {
            StructuredSelection selection = (StructuredSelection)ObjectClassEditorOverviewPage.this.superiorsTableViewer.getSelection();
            if (selection.isEmpty()) {
                return;
            }
            Object selectedElement = selection.getFirstElement();
            if (selectedElement != null && selectedElement instanceof ObjectClassImpl) {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    page.openEditor((IEditorInput)new ObjectClassEditorInput((ObjectClassImpl)((Object)selectedElement)), ObjectClassEditor.ID);
                }
                catch (PartInitException exception) {
                    Logger.getLogger(ObjectClassEditorOverviewPage.class).debug((Object)"error when opening the editor");
                }
            }
        }

        public void mouseUp(MouseEvent e) {
            ObjectClassEditorOverviewPage.this.removeButtonSuperiorsTable.setEnabled(ObjectClassEditorOverviewPage.this.superiorsTable.getSelection().length != 0);
        }
    };
    private SelectionAdapter addButtonSuperiorsTableListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            String[] sups;
            ObjectClassSelectionDialog dialog = new ObjectClassSelectionDialog();
            ArrayList<ObjectClassImpl> hiddenOCs = new ArrayList<ObjectClassImpl>();
            for (String sup : ObjectClassEditorOverviewPage.this.modifiedObjectClass.getSuperClassesNames()) {
                ObjectClassImpl oc = ObjectClassEditorOverviewPage.this.schemaHandler.getObjectClass(sup);
                if (oc == null) continue;
                hiddenOCs.add(oc);
            }
            hiddenOCs.add(ObjectClassEditorOverviewPage.this.originalObjectClass);
            dialog.setHiddenObjectClasses(hiddenOCs.toArray(new ObjectClassImpl[0]));
            if (dialog.open() != 0) {
                return;
            }
            ObjectClassImpl oc = dialog.getSelectedObjectClass();
            if (oc == null) {
                return;
            }
            ArrayList<String> superiors = new ArrayList<String>();
            for (String sup : sups = ObjectClassEditorOverviewPage.this.modifiedObjectClass.getSuperClassesNames()) {
                superiors.add(sup);
            }
            String[] names = oc.getNamesRef();
            if (names != null && names.length > 0) {
                superiors.add(names[0]);
            } else {
                superiors.add(oc.getOid());
            }
            ObjectClassEditorOverviewPage.this.modifiedObjectClass.setSuperClassesNames(superiors.toArray(new String[0]));
            ObjectClassEditorOverviewPage.this.fillInSuperiorsTable();
            ObjectClassEditorOverviewPage.this.setEditorDirty();
        }
    };
    private SelectionAdapter removeButtonSuperiorsTableListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            StructuredSelection selection = (StructuredSelection)ObjectClassEditorOverviewPage.this.superiorsTableViewer.getSelection();
            if (selection.isEmpty()) {
                return;
            }
            Object selectedElement = selection.getFirstElement();
            if (selectedElement != null) {
                String[] sups;
                ArrayList<String> superiors = new ArrayList<String>();
                for (String sup : sups = ObjectClassEditorOverviewPage.this.modifiedObjectClass.getSuperClassesNames()) {
                    superiors.add(sup);
                }
                if (selectedElement instanceof ObjectClassImpl) {
                    for (String name : ((ObjectClassImpl)((Object)selectedElement)).getNamesRef()) {
                        superiors.remove(name);
                    }
                } else if (selectedElement instanceof NonExistingObjectClass) {
                    superiors.remove(((NonExistingObjectClass)selectedElement).getName());
                }
                ObjectClassEditorOverviewPage.this.modifiedObjectClass.setSuperClassesNames(superiors.toArray(new String[0]));
                ObjectClassEditorOverviewPage.this.fillInSuperiorsTable();
                ObjectClassEditorOverviewPage.this.addButtonSuperiorsTable.setFocus();
                ObjectClassEditorOverviewPage.this.removeButtonSuperiorsTable.setEnabled(ObjectClassEditorOverviewPage.this.superiorsTable.getSelection().length != 0);
                ObjectClassEditorOverviewPage.this.setEditorDirty();
            }
        }
    };
    private Listener mouseWheelFilter = new Listener(){

        public void handleEvent(Event event) {
            if (event.widget instanceof Combo) {
                event.doit = false;
            }
        }
    };

    public ObjectClassEditorOverviewPage(FormEditor editor) {
        super(editor, ID, Messages.getString("ObjectClassEditorOverviewPage.Overview"));
        this.schemaHandler = Activator.getDefault().getSchemaHandler();
        this.schemaHandler.addListener(this.schemaHandlerListener);
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.modifiedObjectClass = ((ObjectClassEditor)this.getEditor()).getModifiedObjectClass();
        this.originalObjectClass = ((ObjectClassEditor)this.getEditor()).getOriginalObjectClass();
        this.originalSchema = this.schemaHandler.getSchema(this.originalObjectClass.getSchema());
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        form.getBody().setLayout((Layout)new GridLayout());
        this.createGeneralInformationSection(form.getBody(), toolkit);
        Composite bottomComposite = toolkit.createComposite(form.getBody());
        bottomComposite.setLayout((Layout)new GridLayout(2, true));
        bottomComposite.setLayoutData((Object)new GridData(4, 0, true, false));
        this.createMandatoryAttributesSection(bottomComposite, toolkit);
        this.createOptionalAttributesSection(bottomComposite, toolkit);
        this.fillInUiFields();
        this.addListeners();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)form, PluginConstants.PLUGIN_ID + "." + "object_class_editor");
    }

    private void createGeneralInformationSection(Composite parent, FormToolkit toolkit) {
        Section section_general_information = toolkit.createSection(parent, 448);
        section_general_information.setDescription(Messages.getString("ObjectClassEditorOverviewPage.SpecifyGeneralInformation"));
        section_general_information.setText(Messages.getString("ObjectClassEditorOverviewPage.GeneralInformation"));
        section_general_information.setLayoutData((Object)new GridData(4, 0, true, false));
        Composite client_general_information = toolkit.createComposite((Composite)section_general_information);
        client_general_information.setLayout((Layout)new GridLayout(2, false));
        toolkit.paintBordersFor(client_general_information);
        section_general_information.setClient((Control)client_general_information);
        section_general_information.setLayoutData((Object)new GridData(4, 0, true, false));
        toolkit.createLabel(client_general_information, Messages.getString("ObjectClassEditorOverviewPage.Aliases"));
        Composite aliasComposite = toolkit.createComposite(client_general_information);
        GridLayout aliasCompositeGridLayout = new GridLayout(2, false);
        toolkit.paintBordersFor(aliasComposite);
        aliasCompositeGridLayout.marginHeight = 1;
        aliasCompositeGridLayout.marginWidth = 1;
        aliasComposite.setLayout((Layout)aliasCompositeGridLayout);
        aliasComposite.setLayoutData((Object)new GridData(4, 0, true, false));
        this.aliasesText = toolkit.createText(aliasComposite, "");
        this.aliasesText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.aliasesButton = toolkit.createButton(aliasComposite, Messages.getString("ObjectClassEditorOverviewPage.EditAliases"), 8);
        this.aliasesButton.setLayoutData((Object)new GridData(0, 0x1000000, false, false));
        toolkit.createLabel(client_general_information, Messages.getString("ObjectClassEditorOverviewPage.OID"));
        this.oidText = toolkit.createText(client_general_information, "");
        this.oidText.setLayoutData((Object)new GridData(4, 0, true, false));
        this.schemaLink = toolkit.createHyperlink(client_general_information, Messages.getString("ObjectClassEditorOverviewPage.Schema"), 64);
        this.schemaLabel = toolkit.createLabel(client_general_information, "");
        this.schemaLabel.setLayoutData((Object)new GridData(4, 0, true, false));
        toolkit.createLabel(client_general_information, Messages.getString("ObjectClassEditorOverviewPage.Description"));
        this.descriptionText = toolkit.createText(client_general_information, "", 514);
        GridData descriptionGridData = new GridData(4, 0, true, false);
        descriptionGridData.heightHint = 42;
        this.descriptionText.setLayoutData((Object)descriptionGridData);
        toolkit.createLabel(client_general_information, Messages.getString("ObjectClassEditorOverviewPage.SuperiorClasses"));
        Composite superiorsComposite = toolkit.createComposite(client_general_information);
        GridLayout superiorsCompositeGridLayout = new GridLayout(2, false);
        toolkit.paintBordersFor(superiorsComposite);
        superiorsCompositeGridLayout.marginHeight = 1;
        superiorsCompositeGridLayout.marginWidth = 1;
        superiorsComposite.setLayout((Layout)superiorsCompositeGridLayout);
        superiorsComposite.setLayoutData((Object)new GridData(4, 0, true, false));
        this.superiorsTable = toolkit.createTable(superiorsComposite, 66308);
        toolkit.paintBordersFor((Composite)this.superiorsTable);
        GridData gridData = new GridData(4, 0, true, false, 1, 2);
        gridData.heightHint = 45;
        gridData.minimumHeight = 45;
        this.superiorsTable.setLayoutData((Object)gridData);
        this.superiorsTableViewer = new TableViewer(this.superiorsTable);
        this.superiorsTableViewer.setContentProvider((IContentProvider)new ObjectClassEditorSuperiorsTableContentProvider());
        this.superiorsTableViewer.setLabelProvider((IBaseLabelProvider)new ObjectClassEditorSuperiorsTableLabelProvider());
        this.addButtonSuperiorsTable = toolkit.createButton(superiorsComposite, Messages.getString("ObjectClassEditorOverviewPage.Add"), 8);
        this.addButtonSuperiorsTable.setLayoutData((Object)new GridData(4, 0, false, false));
        this.removeButtonSuperiorsTable = toolkit.createButton(superiorsComposite, Messages.getString("ObjectClassEditorOverviewPage.Remove"), 8);
        this.removeButtonSuperiorsTable.setLayoutData((Object)new GridData(4, 0, false, false));
        toolkit.createLabel(client_general_information, Messages.getString("ObjectClassEditorOverviewPage.ClassType"));
        this.classTypeCombo = new Combo(client_general_information, 12);
        this.classTypeCombo.setLayoutData((Object)new GridData(4, 0, true, false));
        this.initClassTypeCombo();
        toolkit.createLabel(client_general_information, "");
        this.obsoleteCheckbox = toolkit.createButton(client_general_information, Messages.getString("ObjectClassEditorOverviewPage.Obsolete"), 32);
        this.obsoleteCheckbox.setLayoutData((Object)new GridData(4, 0, true, false));
    }

    private void createMandatoryAttributesSection(Composite parent, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 384);
        section.setText(Messages.getString("ObjectClassEditorOverviewPage.MandatoryAttributes"));
        section.setDescription(Messages.getString("ObjectClassEditorOverviewPage.SpecifyMandatoryAttributes"));
        section.setExpanded(true);
        Composite client = toolkit.createComposite((Composite)section);
        section.setClient((Control)client);
        GridData gd = new GridData(4, 0, true, false);
        section.setLayoutData((Object)gd);
        toolkit.paintBordersFor(client);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        client.setLayout((Layout)layout);
        this.mandatoryAttributesTable = toolkit.createTable(client, 66308);
        gd = new GridData(4, 0, true, false);
        gd.verticalSpan = 2;
        gd.heightHint = 108;
        this.mandatoryAttributesTable.setLayoutData((Object)gd);
        this.mandatoryAttributesTableViewer = new TableViewer(this.mandatoryAttributesTable);
        this.mandatoryAttributesTableViewer.setContentProvider((IContentProvider)new ObjectClassEditorAttributesTableContentProvider());
        this.mandatoryAttributesTableViewer.setLabelProvider((IBaseLabelProvider)new ObjectClassEditorAttributesTableLabelProvider());
        this.addButtonMandatoryTable = toolkit.createButton(client, Messages.getString("ObjectClassEditorOverviewPage.Add"), 8);
        this.removeButtonMandatoryTable = toolkit.createButton(client, Messages.getString("ObjectClassEditorOverviewPage.Remove"), 8);
        gd = new GridData(2);
        this.addButtonMandatoryTable.setLayoutData((Object)gd);
        this.removeButtonMandatoryTable.setLayoutData((Object)gd);
        this.removeButtonMandatoryTable.setEnabled(false);
    }

    private void createOptionalAttributesSection(Composite parent, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 384);
        section.setText(Messages.getString("ObjectClassEditorOverviewPage.OptionalAttributes"));
        section.setDescription(Messages.getString("ObjectClassEditorOverviewPage.SpecifyOptionalAttributes"));
        section.setExpanded(true);
        Composite client = toolkit.createComposite((Composite)section);
        section.setClient((Control)client);
        GridData gd = new GridData(4, 0, true, false);
        section.setLayoutData((Object)gd);
        toolkit.paintBordersFor(client);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        client.setLayout((Layout)layout);
        this.optionalAttributesTable = toolkit.createTable(client, 66308);
        gd = new GridData(4, 0, true, false);
        gd.verticalSpan = 2;
        gd.heightHint = 108;
        this.optionalAttributesTable.setLayoutData((Object)gd);
        this.optionalAttributesTableViewer = new TableViewer(this.optionalAttributesTable);
        this.optionalAttributesTableViewer.setContentProvider((IContentProvider)new ObjectClassEditorAttributesTableContentProvider());
        this.optionalAttributesTableViewer.setLabelProvider((IBaseLabelProvider)new ObjectClassEditorAttributesTableLabelProvider());
        this.addButtonOptionalTable = toolkit.createButton(client, Messages.getString("ObjectClassEditorOverviewPage.Add"), 8);
        this.removeButtonOptionalTable = toolkit.createButton(client, Messages.getString("ObjectClassEditorOverviewPage.Remove"), 8);
        gd = new GridData(2);
        this.addButtonOptionalTable.setLayoutData((Object)gd);
        this.removeButtonOptionalTable.setLayoutData((Object)gd);
        this.removeButtonOptionalTable.setEnabled(false);
    }

    private void fillInUiFields() {
        if (this.modifiedObjectClass.getNamesRef() != null && this.modifiedObjectClass.getNamesRef().length != 0) {
            this.aliasesText.setText(ViewUtils.concateAliases(this.modifiedObjectClass.getNamesRef()));
        } else {
            this.aliasesText.setText("");
        }
        if (this.modifiedObjectClass.getOid() != null) {
            this.oidText.setText(this.modifiedObjectClass.getOid());
        }
        this.schemaLabel.setText(this.modifiedObjectClass.getSchema());
        if (this.modifiedObjectClass.getDescription() != null) {
            this.descriptionText.setText(this.modifiedObjectClass.getDescription());
        }
        this.fillInSuperiorsTable();
        this.fillInClassType();
        this.obsoleteCheckbox.setSelection(this.modifiedObjectClass.isObsolete());
        this.fillInMandatoryAttributesTable();
        this.fillInOptionalAttributesTable();
    }

    private void fillInSuperiorsTable() {
        this.superiorsTableViewer.setInput((Object)this.modifiedObjectClass.getSuperClassesNames());
    }

    private void initClassTypeCombo() {
        this.classTypeCombo.add(Messages.getString("ObjectClassEditorOverviewPage.Abstract"), 0);
        this.classTypeCombo.add(Messages.getString("ObjectClassEditorOverviewPage.Auxiliary"), 1);
        this.classTypeCombo.add(Messages.getString("ObjectClassEditorOverviewPage.Structural"), 2);
    }

    private void fillInClassType() {
        if (this.modifiedObjectClass.getType() == ObjectClassTypeEnum.ABSTRACT) {
            this.classTypeCombo.select(0);
        } else if (this.modifiedObjectClass.getType() == ObjectClassTypeEnum.AUXILIARY) {
            this.classTypeCombo.select(1);
        } else if (this.modifiedObjectClass.getType() == ObjectClassTypeEnum.STRUCTURAL) {
            this.classTypeCombo.select(2);
        }
    }

    private void fillInMandatoryAttributesTable() {
        this.mandatoryAttributesTableViewer.setInput((Object)this.modifiedObjectClass.getMustNamesList());
    }

    private void fillInOptionalAttributesTable() {
        this.optionalAttributesTableViewer.setInput((Object)this.modifiedObjectClass.getMayNamesList());
    }

    private void addListeners() {
        this.aliasesText.addModifyListener(this.aliasesTextModifyListener);
        this.aliasesButton.addSelectionListener((SelectionListener)this.aliasesButtonListener);
        this.oidText.addModifyListener(this.oidTextModifyListener);
        this.oidText.addVerifyListener(this.oidTextVerifyListener);
        this.descriptionText.addModifyListener(this.descriptionTextListener);
        this.addButtonSuperiorsTable.addSelectionListener((SelectionListener)this.addButtonSuperiorsTableListener);
        this.removeButtonSuperiorsTable.addSelectionListener((SelectionListener)this.removeButtonSuperiorsTableListener);
        this.classTypeCombo.addModifyListener(this.classTypeListener);
        this.obsoleteCheckbox.addSelectionListener((SelectionListener)this.obsoleteListener);
        this.addButtonMandatoryTable.addSelectionListener((SelectionListener)this.addButtonMandatoryTableListener);
        this.removeButtonMandatoryTable.addSelectionListener((SelectionListener)this.removeButtonMandatoryTableListener);
        this.addButtonOptionalTable.addSelectionListener((SelectionListener)this.addButtonOptionalTableListener);
        this.removeButtonOptionalTable.addSelectionListener((SelectionListener)this.removeButtonOptionalTableListener);
        this.schemaLink.addHyperlinkListener((IHyperlinkListener)this.schemaLinkListener);
        this.superiorsTable.addMouseListener(this.superiorsTableListener);
        this.mandatoryAttributesTable.addMouseListener(this.mandatoryAttributesTableListener);
        this.optionalAttributesTable.addMouseListener(this.optionalAttributesTableListener);
        Display.getCurrent().addFilter(37, this.mouseWheelFilter);
    }

    private void removeListeners() {
        this.aliasesText.removeModifyListener(this.aliasesTextModifyListener);
        this.aliasesButton.removeSelectionListener((SelectionListener)this.aliasesButtonListener);
        this.oidText.removeModifyListener(this.oidTextModifyListener);
        this.oidText.removeVerifyListener(this.oidTextVerifyListener);
        this.schemaLink.removeHyperlinkListener((IHyperlinkListener)this.schemaLinkListener);
        this.descriptionText.removeModifyListener(this.descriptionTextListener);
        this.superiorsTable.removeMouseListener(this.superiorsTableListener);
        this.addButtonSuperiorsTable.removeSelectionListener((SelectionListener)this.addButtonSuperiorsTableListener);
        this.removeButtonSuperiorsTable.removeSelectionListener((SelectionListener)this.removeButtonSuperiorsTableListener);
        this.classTypeCombo.removeModifyListener(this.classTypeListener);
        this.obsoleteCheckbox.removeSelectionListener((SelectionListener)this.obsoleteListener);
        this.mandatoryAttributesTable.removeMouseListener(this.mandatoryAttributesTableListener);
        this.addButtonMandatoryTable.removeSelectionListener((SelectionListener)this.addButtonMandatoryTableListener);
        this.removeButtonMandatoryTable.removeSelectionListener((SelectionListener)this.removeButtonMandatoryTableListener);
        this.optionalAttributesTable.removeMouseListener(this.optionalAttributesTableListener);
        this.addButtonOptionalTable.removeSelectionListener((SelectionListener)this.addButtonOptionalTableListener);
        this.removeButtonOptionalTable.removeSelectionListener((SelectionListener)this.removeButtonOptionalTableListener);
        Display.getCurrent().removeFilter(37, this.mouseWheelFilter);
    }

    private void setEditorDirty() {
        ((ObjectClassEditor)this.getEditor()).setDirty(true);
    }

    public void refreshUI() {
        this.removeListeners();
        this.fillInUiFields();
        this.addListeners();
    }

    public void dispose() {
        this.schemaHandler.removeListener(this.schemaHandlerListener);
        super.dispose();
    }
}

