/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.editors.objectclass;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandler;
import org.apache.directory.studio.schemaeditor.model.AttributeTypeImpl;
import org.apache.directory.studio.schemaeditor.view.editors.NonExistingAttributeType;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ObjectClassEditorAttributesTableContentProvider
implements IStructuredContentProvider {
    private SchemaHandler schemaHandler = Activator.getDefault().getSchemaHandler();

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof String[]) {
            String[] attributes;
            ArrayList<Object> results = new ArrayList<Object>();
            for (String attribute : attributes = (String[])inputElement) {
                AttributeTypeImpl at = this.schemaHandler.getAttributeType(attribute);
                if (at != null) {
                    results.add((Object)at);
                    continue;
                }
                results.add(new NonExistingAttributeType(attribute));
            }
            Collections.sort(results, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    if (o1 instanceof AttributeTypeImpl && o2 instanceof AttributeTypeImpl) {
                        String[] at1Names = ((AttributeTypeImpl)((Object)o1)).getNamesRef();
                        String[] at2Names = ((AttributeTypeImpl)((Object)o2)).getNamesRef();
                        if (at1Names != null && at2Names != null && at1Names.length > 0 && at2Names.length > 0) {
                            return at1Names[0].compareToIgnoreCase(at2Names[0]);
                        }
                    } else if (o1 instanceof AttributeTypeImpl && o2 instanceof NonExistingAttributeType) {
                        String[] at1Names = ((AttributeTypeImpl)((Object)o1)).getNamesRef();
                        String at2Name = ((NonExistingAttributeType)o2).getName();
                        if (at1Names != null && at2Name != null && at1Names.length > 0) {
                            return at1Names[0].compareToIgnoreCase(at2Name);
                        }
                    } else if (o1 instanceof NonExistingAttributeType && o2 instanceof AttributeTypeImpl) {
                        String at1Name = ((NonExistingAttributeType)o1).getName();
                        String[] at2Names = ((AttributeTypeImpl)((Object)o2)).getNamesRef();
                        if (at1Name != null && at2Names != null && at2Names.length > 0) {
                            return at1Name.compareToIgnoreCase(at2Names[0]);
                        }
                    } else if (o1 instanceof NonExistingAttributeType && o2 instanceof NonExistingAttributeType) {
                        String at1Name = ((NonExistingAttributeType)o1).getName();
                        String at2Name = ((NonExistingAttributeType)o2).getName();
                        if (at1Name != null && at2Name != null) {
                            return at1Name.compareToIgnoreCase(at2Name);
                        }
                    }
                    return 0;
                }
            });
            return results.toArray();
        }
        return null;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

