/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.editors.objectclass;

import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.PluginConstants;
import org.apache.directory.studio.schemaeditor.PluginUtils;
import org.apache.directory.studio.schemaeditor.controller.ObjectClassAdapter;
import org.apache.directory.studio.schemaeditor.controller.ObjectClassListener;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandler;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandlerAdapter;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandlerListener;
import org.apache.directory.studio.schemaeditor.model.ObjectClassImpl;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.view.editors.objectclass.Messages;
import org.apache.directory.studio.schemaeditor.view.editors.objectclass.ObjectClassEditorInput;
import org.apache.directory.studio.schemaeditor.view.editors.objectclass.ObjectClassEditorOverviewPage;
import org.apache.directory.studio.schemaeditor.view.editors.objectclass.ObjectClassEditorSourceCodePage;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;

public class ObjectClassEditor
extends FormEditor {
    private static Logger logger = Logger.getLogger(ObjectClassEditor.class);
    public static final String ID = PluginConstants.EDITOR_OBJECT_CLASS_ID;
    private ObjectClassEditor instance;
    private ObjectClassEditorOverviewPage overview;
    private ObjectClassEditorSourceCodePage sourceCode;
    private boolean dirty = false;
    private ObjectClassImpl originalObjectClass;
    private ObjectClassImpl modifiedObjectClass;
    private Schema originalSchema;
    private IPageChangedListener pageChangedListener = new IPageChangedListener(){

        public void pageChanged(PageChangedEvent event) {
            Object selectedPage = event.getSelectedPage();
            if (selectedPage instanceof ObjectClassEditorOverviewPage) {
                if (!ObjectClassEditor.this.sourceCode.canLeaveThePage()) {
                    ObjectClassEditor.this.notifyError(Messages.getString("ObjectClassEditor.CodeError"));
                    return;
                }
                ObjectClassEditor.this.overview.refreshUI();
            } else if (selectedPage instanceof ObjectClassEditorSourceCodePage && ObjectClassEditor.this.sourceCode.canLeaveThePage()) {
                ObjectClassEditor.this.sourceCode.refreshUI();
            }
        }
    };
    private ObjectClassListener objectClassListener = new ObjectClassAdapter(){

        public void objectClassRemoved() {
            ObjectClassEditor.this.getEditorSite().getPage().closeEditor((IEditorPart)ObjectClassEditor.this.instance, false);
        }
    };
    private SchemaHandlerListener schemaHandlerListener = new SchemaHandlerAdapter(){

        public void schemaRemoved(Schema schema) {
            if (schema.equals(ObjectClassEditor.this.originalSchema)) {
                ObjectClassEditor.this.getEditorSite().getPage().closeEditor((IEditorPart)ObjectClassEditor.this.instance, false);
            }
        }
    };

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.instance = this;
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setPartName(input.getName());
        this.originalObjectClass = ((ObjectClassEditorInput)this.getEditorInput()).getObjectClass();
        this.modifiedObjectClass = PluginUtils.getClone(this.originalObjectClass);
        SchemaHandler schemaHandler = Activator.getDefault().getSchemaHandler();
        this.originalSchema = schemaHandler.getSchema(this.originalObjectClass.getSchema());
        schemaHandler.addListener(this.originalObjectClass, this.objectClassListener);
        schemaHandler.addListener(this.schemaHandlerListener);
        this.addPageChangedListener(this.pageChangedListener);
    }

    public void dispose() {
        SchemaHandler schemaHandler = Activator.getDefault().getSchemaHandler();
        schemaHandler.removeListener(this.originalObjectClass, this.objectClassListener);
        schemaHandler.removeListener(this.schemaHandlerListener);
        super.dispose();
    }

    protected void addPages() {
        try {
            this.overview = new ObjectClassEditorOverviewPage(this);
            this.addPage((IFormPage)this.overview);
            this.sourceCode = new ObjectClassEditorSourceCodePage(this);
            this.addPage((IFormPage)this.sourceCode);
        }
        catch (PartInitException e) {
            logger.debug((Object)"error when adding pages");
        }
    }

    public void doSave(IProgressMonitor monitor) {
        if (!this.sourceCode.canLeaveThePage()) {
            this.notifyError(Messages.getString("ObjectClassEditor.CodeErrorObject"));
            monitor.setCanceled(true);
            return;
        }
        Activator.getDefault().getSchemaHandler().modifyObjectClass(this.originalObjectClass, this.modifiedObjectClass);
        this.setPartName(this.getEditorInput().getName());
        if (!monitor.isCanceled()) {
            this.setDirty(false);
        }
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
        this.editorDirtyStateChanged();
    }

    public ObjectClassImpl getOriginalObjectClass() {
        return this.originalObjectClass;
    }

    public ObjectClassImpl getModifiedObjectClass() {
        return this.modifiedObjectClass;
    }

    public void setModifiedObjectClass(ObjectClassImpl modifiedObjectClass) {
        this.modifiedObjectClass = modifiedObjectClass;
    }

    private void notifyError(String message) {
        MessageBox messageBox = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 33);
        messageBox.setMessage(message);
        messageBox.open();
    }
}

