/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.editors.attributetype;

import java.io.IOException;
import java.text.ParseException;
import java.util.List;
import org.apache.directory.shared.ldap.schema.parsers.AttributeTypeLiteral;
import org.apache.directory.shared.ldap.schema.parsers.OpenLdapSchemaParser;
import org.apache.directory.studio.schemaeditor.PluginConstants;
import org.apache.directory.studio.schemaeditor.model.AttributeTypeImpl;
import org.apache.directory.studio.schemaeditor.model.io.OpenLdapSchemaFileExporter;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.AttributeTypeEditor;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.Messages;
import org.apache.directory.studio.schemaeditor.view.widget.SchemaSourceViewer;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class AttributeTypeEditorSourceCodePage
extends FormPage {
    public static final String ID = AttributeTypeEditor.ID + "sourceCodePage";
    private AttributeTypeImpl modifiedAttributeType;
    private SchemaSourceViewer schemaSourceViewer;
    private boolean canLeaveThePage = true;
    private ModifyListener schemaSourceViewerListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            AttributeTypeEditorSourceCodePage.this.canLeaveThePage = true;
            try {
                ((AttributeTypeEditor)AttributeTypeEditorSourceCodePage.this.getEditor()).setDirty(true);
                OpenLdapSchemaParser parser = new OpenLdapSchemaParser();
                parser.parse(AttributeTypeEditorSourceCodePage.this.schemaSourceViewer.getTextWidget().getText());
                List attributeTypes = parser.getAttributeTypes();
                if (attributeTypes.size() == 1) {
                    AttributeTypeEditorSourceCodePage.this.updateAttributeType((AttributeTypeLiteral)attributeTypes.get(0));
                }
            }
            catch (IOException e1) {
                AttributeTypeEditorSourceCodePage.this.canLeaveThePage = false;
            }
            catch (ParseException exception) {
                AttributeTypeEditorSourceCodePage.this.canLeaveThePage = false;
            }
        }
    };

    public AttributeTypeEditorSourceCodePage(FormEditor editor) {
        super(editor, ID, Messages.getString("AttributeTypeEditorSourceCodePage.SourceCode"));
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        form.getBody().setLayout((Layout)layout);
        toolkit.paintBordersFor(form.getBody());
        this.modifiedAttributeType = ((AttributeTypeEditor)this.getEditor()).getModifiedAttributeType();
        this.schemaSourceViewer = new SchemaSourceViewer(form.getBody(), null, null, false, 2816);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = 10;
        this.schemaSourceViewer.getTextWidget().setLayoutData((Object)gd);
        Font font = JFaceResources.getFont((String)"org.eclipse.jface.textfont");
        this.schemaSourceViewer.getTextWidget().setFont(font);
        Document document = new Document();
        this.schemaSourceViewer.setDocument((IDocument)document);
        this.fillInUiFields();
        this.schemaSourceViewer.getTextWidget().addModifyListener(this.schemaSourceViewerListener);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)form, PluginConstants.PLUGIN_ID + "." + "attribute_type_editor");
    }

    private void fillInUiFields() {
        this.schemaSourceViewer.getDocument().set(OpenLdapSchemaFileExporter.toSourceCode(this.modifiedAttributeType));
    }

    public boolean canLeaveThePage() {
        return this.canLeaveThePage;
    }

    private void updateAttributeType(AttributeTypeLiteral atl) {
        this.modifiedAttributeType.setCanUserModify(!atl.isNoUserModification());
        this.modifiedAttributeType.setCollective(atl.isCollective());
        this.modifiedAttributeType.setDescription(atl.getDescription());
        this.modifiedAttributeType.setEqualityName(atl.getEquality());
        this.modifiedAttributeType.setLength(atl.getLength());
        this.modifiedAttributeType.setNames(atl.getNames());
        this.modifiedAttributeType.setObsolete(atl.isObsolete());
        this.modifiedAttributeType.setOid(atl.getOid());
        this.modifiedAttributeType.setOrderingName(atl.getOrdering());
        this.modifiedAttributeType.setSingleValue(atl.isSingleValue());
        this.modifiedAttributeType.setSubstrName(atl.getSubstr());
        this.modifiedAttributeType.setSuperiorName(atl.getSuperior());
        this.modifiedAttributeType.setSyntaxOid(atl.getSyntax());
        this.modifiedAttributeType.setUsage(atl.getUsage());
    }

    public void refreshUI() {
        this.fillInUiFields();
    }
}

