/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.editors.attributetype;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.shared.asn1.primitives.OID;
import org.apache.directory.shared.ldap.schema.UsageEnum;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.PluginConstants;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandler;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandlerListener;
import org.apache.directory.studio.schemaeditor.model.AttributeTypeImpl;
import org.apache.directory.studio.schemaeditor.model.MatchingRuleImpl;
import org.apache.directory.studio.schemaeditor.model.ObjectClassImpl;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.model.SyntaxImpl;
import org.apache.directory.studio.schemaeditor.model.alias.Alias;
import org.apache.directory.studio.schemaeditor.model.alias.AliasWithError;
import org.apache.directory.studio.schemaeditor.model.alias.AliasesStringParser;
import org.apache.directory.studio.schemaeditor.view.ViewUtils;
import org.apache.directory.studio.schemaeditor.view.dialogs.EditAliasesDialog;
import org.apache.directory.studio.schemaeditor.view.editors.NonExistingAttributeType;
import org.apache.directory.studio.schemaeditor.view.editors.NonExistingMatchingRule;
import org.apache.directory.studio.schemaeditor.view.editors.NonExistingSyntax;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.ATEMatchingRulesComboContentProvider;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.ATEMatchingRulesComboInput;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.ATEMatchingRulesComboLabelProvider;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.ATESuperiorComboContentProvider;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.ATESuperiorComboInput;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.ATESuperiorComboLabelProvider;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.ATESyntaxComboContentProvider;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.ATESyntaxComboInput;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.ATESyntaxComboLabelProvider;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.AttributeTypeEditor;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.AttributeTypeEditorInput;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.Messages;
import org.apache.directory.studio.schemaeditor.view.editors.schema.SchemaEditor;
import org.apache.directory.studio.schemaeditor.view.editors.schema.SchemaEditorInput;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class AttributeTypeEditorOverviewPage
extends FormPage {
    public static final String ID = AttributeTypeEditor.ID + ".overviewPage";
    private AttributeTypeImpl originalAttributeType;
    private AttributeTypeImpl modifiedAttributeType;
    private Schema originalSchema;
    private SchemaHandler schemaHandler;
    private SchemaHandlerListener schemaHandlerListener = new SchemaHandlerListener(){

        public void attributeTypeAdded(AttributeTypeImpl at) {
            AttributeTypeEditorOverviewPage.this.refreshUI();
        }

        public void attributeTypeModified(AttributeTypeImpl at) {
            AttributeTypeEditorOverviewPage.this.refreshUI();
        }

        public void attributeTypeRemoved(AttributeTypeImpl at) {
            if (!at.equals((Object)AttributeTypeEditorOverviewPage.this.originalAttributeType)) {
                AttributeTypeEditorOverviewPage.this.refreshUI();
            }
        }

        public void matchingRuleAdded(MatchingRuleImpl mr) {
            AttributeTypeEditorOverviewPage.this.refreshUI();
        }

        public void matchingRuleModified(MatchingRuleImpl mr) {
            AttributeTypeEditorOverviewPage.this.refreshUI();
        }

        public void matchingRuleRemoved(MatchingRuleImpl mr) {
            AttributeTypeEditorOverviewPage.this.refreshUI();
        }

        public void objectClassAdded(ObjectClassImpl oc) {
            AttributeTypeEditorOverviewPage.this.refreshUI();
        }

        public void objectClassModified(ObjectClassImpl oc) {
            AttributeTypeEditorOverviewPage.this.refreshUI();
        }

        public void objectClassRemoved(ObjectClassImpl oc) {
            AttributeTypeEditorOverviewPage.this.refreshUI();
        }

        public void schemaAdded(Schema schema) {
            AttributeTypeEditorOverviewPage.this.refreshUI();
        }

        public void schemaRemoved(Schema schema) {
            if (!schema.equals(AttributeTypeEditorOverviewPage.this.originalSchema)) {
                AttributeTypeEditorOverviewPage.this.refreshUI();
            }
        }

        public void syntaxAdded(SyntaxImpl syntax) {
            AttributeTypeEditorOverviewPage.this.refreshUI();
        }

        public void syntaxModified(SyntaxImpl syntax) {
            AttributeTypeEditorOverviewPage.this.refreshUI();
        }

        public void syntaxRemoved(SyntaxImpl syntax) {
            AttributeTypeEditorOverviewPage.this.refreshUI();
        }
    };
    private Text aliasesText;
    private Button aliasesButton;
    private Text oidText;
    private Hyperlink schemaLink;
    private Label schemaLabel;
    private Text descriptionText;
    private Hyperlink supLabel;
    private Combo supCombo;
    private ComboViewer supComboViewer;
    private Combo usageCombo;
    private Combo syntaxCombo;
    private ComboViewer syntaxComboViewer;
    private Text syntaxLengthText;
    private Button obsoleteCheckbox;
    private Button singleValueCheckbox;
    private Button collectiveCheckbox;
    private Button noUserModificationCheckbox;
    private Combo equalityCombo;
    private ComboViewer equalityComboViewer;
    private Combo orderingCombo;
    private ComboViewer orderingComboViewer;
    private Combo substringCombo;
    private ComboViewer substringComboViewer;
    private ModifyListener aliasesTextModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            AliasesStringParser parser = new AliasesStringParser();
            parser.parse(AttributeTypeEditorOverviewPage.this.aliasesText.getText());
            List<Alias> parsedAliases = parser.getAliases();
            AttributeTypeEditorOverviewPage.this.modifiedAttributeType.setNames(new String[0]);
            ArrayList<String> aliasesList = new ArrayList<String>();
            for (Alias parsedAlias : parsedAliases) {
                if (parsedAlias instanceof AliasWithError) continue;
                aliasesList.add(parsedAlias.getAlias());
            }
            AttributeTypeEditorOverviewPage.this.modifiedAttributeType.setNames(aliasesList.toArray(new String[0]));
            AttributeTypeEditorOverviewPage.this.setEditorDirty();
        }
    };
    private SelectionAdapter aliasesButtonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            EditAliasesDialog editDialog = new EditAliasesDialog(AttributeTypeEditorOverviewPage.this.modifiedAttributeType.getNamesRef());
            if (editDialog.open() != 0) {
                return;
            }
            if (editDialog.isDirty()) {
                AttributeTypeEditorOverviewPage.this.modifiedAttributeType.setNames(editDialog.getAliases());
                if (AttributeTypeEditorOverviewPage.this.modifiedAttributeType.getNamesRef() != null && AttributeTypeEditorOverviewPage.this.modifiedAttributeType.getNamesRef().length != 0) {
                    AttributeTypeEditorOverviewPage.this.aliasesText.setText(ViewUtils.concateAliases(AttributeTypeEditorOverviewPage.this.modifiedAttributeType.getNamesRef()));
                } else {
                    AttributeTypeEditorOverviewPage.this.aliasesText.setText("");
                }
                AttributeTypeEditorOverviewPage.this.setEditorDirty();
            }
        }
    };
    private ModifyListener oidTextModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            AttributeTypeEditorOverviewPage.this.oidText.setForeground(ViewUtils.COLOR_BLACK);
            AttributeTypeEditorOverviewPage.this.oidText.setToolTipText("");
            String oid = AttributeTypeEditorOverviewPage.this.oidText.getText();
            if (OID.isOID((String)oid)) {
                if (AttributeTypeEditorOverviewPage.this.originalAttributeType.getOid().equals(oid) || !AttributeTypeEditorOverviewPage.this.schemaHandler.isAliasOrOidAlreadyTaken(oid)) {
                    AttributeTypeEditorOverviewPage.this.modifiedAttributeType.setOid(oid);
                    AttributeTypeEditorOverviewPage.this.setEditorDirty();
                } else {
                    AttributeTypeEditorOverviewPage.this.oidText.setForeground(ViewUtils.COLOR_RED);
                    AttributeTypeEditorOverviewPage.this.oidText.setToolTipText(Messages.getString("AttributeTypeEditorOverviewPage.ElementOIDExists"));
                }
            } else {
                AttributeTypeEditorOverviewPage.this.oidText.setForeground(ViewUtils.COLOR_RED);
                AttributeTypeEditorOverviewPage.this.oidText.setToolTipText(Messages.getString("AttributeTypeEditorOverviewPage.MalformedOID"));
            }
        }
    };
    private VerifyListener oidTextVerifyListener = new VerifyListener(){

        public void verifyText(VerifyEvent e) {
            if (!e.text.matches("([0-9]*\\.?)*")) {
                e.doit = false;
            }
        }
    };
    private HyperlinkAdapter schemaLinkListener = new HyperlinkAdapter(){

        public void linkActivated(HyperlinkEvent e) {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            SchemaEditorInput input = new SchemaEditorInput(AttributeTypeEditorOverviewPage.this.schemaHandler.getSchema(AttributeTypeEditorOverviewPage.this.modifiedAttributeType.getSchema()));
            String editorId = SchemaEditor.ID;
            try {
                page.openEditor((IEditorInput)input, editorId);
            }
            catch (PartInitException exception) {
                Logger.getLogger(AttributeTypeEditorInput.class).debug((Object)"error when opening the editor");
            }
        }
    };
    private ModifyListener descriptionTextListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            int caretPosition = AttributeTypeEditorOverviewPage.this.descriptionText.getCaretPosition();
            AttributeTypeEditorOverviewPage.this.modifiedAttributeType.setDescription(AttributeTypeEditorOverviewPage.this.descriptionText.getText());
            AttributeTypeEditorOverviewPage.this.descriptionText.setSelection(caretPosition);
            AttributeTypeEditorOverviewPage.this.setEditorDirty();
        }
    };
    private HyperlinkAdapter supLabelListener = new HyperlinkAdapter(){

        public void linkActivated(HyperlinkEvent e) {
            Object selectedItem = ((StructuredSelection)AttributeTypeEditorOverviewPage.this.supComboViewer.getSelection()).getFirstElement();
            if (selectedItem instanceof AttributeTypeImpl) {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                AttributeTypeEditorInput input = new AttributeTypeEditorInput((AttributeTypeImpl)((Object)selectedItem));
                try {
                    page.openEditor((IEditorInput)input, AttributeTypeEditor.ID);
                }
                catch (PartInitException exception) {
                    Logger.getLogger(AttributeTypeEditorInput.class).debug((Object)"error when opening the editor");
                }
            }
        }
    };
    private ISelectionChangedListener supComboViewerListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            Object selectedItem = ((StructuredSelection)AttributeTypeEditorOverviewPage.this.supComboViewer.getSelection()).getFirstElement();
            if (selectedItem instanceof AttributeTypeImpl) {
                AttributeTypeImpl at = (AttributeTypeImpl)((Object)selectedItem);
                String[] names = at.getNamesRef();
                if (names != null && names.length > 0) {
                    AttributeTypeEditorOverviewPage.this.modifiedAttributeType.setSuperiorName(names[0]);
                } else {
                    AttributeTypeEditorOverviewPage.this.modifiedAttributeType.setSuperiorName(at.getOid());
                }
            } else if (selectedItem instanceof NonExistingAttributeType) {
                NonExistingAttributeType neat = (NonExistingAttributeType)selectedItem;
                if ("(None)".equals(neat.getName())) {
                    AttributeTypeEditorOverviewPage.this.modifiedAttributeType.setSuperiorName(null);
                } else {
                    AttributeTypeEditorOverviewPage.this.modifiedAttributeType.setSuperiorName(((NonExistingAttributeType)selectedItem).getName());
                }
            }
            AttributeTypeEditorOverviewPage.this.setEditorDirty();
        }
    };
    private ModifyListener usageComboListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            if (AttributeTypeEditorOverviewPage.this.usageCombo.getSelectionIndex() == 0) {
                AttributeTypeEditorOverviewPage.this.modifiedAttributeType.setUsage(UsageEnum.DIRECTORY_OPERATION);
            } else if (AttributeTypeEditorOverviewPage.this.usageCombo.getSelectionIndex() == 1) {
                AttributeTypeEditorOverviewPage.this.modifiedAttributeType.setUsage(UsageEnum.DISTRIBUTED_OPERATION);
            } else if (AttributeTypeEditorOverviewPage.this.usageCombo.getSelectionIndex() == 2) {
                AttributeTypeEditorOverviewPage.this.modifiedAttributeType.setUsage(UsageEnum.DSA_OPERATION);
            } else if (AttributeTypeEditorOverviewPage.this.usageCombo.getSelectionIndex() == 3) {
                AttributeTypeEditorOverviewPage.this.modifiedAttributeType.setUsage(UsageEnum.USER_APPLICATIONS);
            }
            AttributeTypeEditorOverviewPage.this.setEditorDirty();
        }
    };
    private ISelectionChangedListener syntaxComboViewerListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            Object selectedItem = ((StructuredSelection)AttributeTypeEditorOverviewPage.this.syntaxComboViewer.getSelection()).getFirstElement();
            if (selectedItem instanceof SyntaxImpl) {
                AttributeTypeEditorOverviewPage.this.modifiedAttributeType.setSyntaxOid(((SyntaxImpl)((Object)selectedItem)).getOid());
            } else if (selectedItem instanceof NonExistingSyntax) {
                NonExistingSyntax nes = (NonExistingSyntax)selectedItem;
                if ("(None)".equals(nes.getName())) {
                    AttributeTypeEditorOverviewPage.this.modifiedAttributeType.setSyntaxOid(null);
                } else {
                    AttributeTypeEditorOverviewPage.this.modifiedAttributeType.setSyntaxOid(((NonExistingSyntax)selectedItem).getName());
                }
            }
            AttributeTypeEditorOverviewPage.this.setEditorDirty();
        }
    };
    private ModifyListener syntaxLengthTextModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            if (AttributeTypeEditorOverviewPage.this.syntaxLengthText.getText().length() == 0) {
                AttributeTypeEditorOverviewPage.this.modifiedAttributeType.setLength(-1);
            } else {
                AttributeTypeEditorOverviewPage.this.modifiedAttributeType.setLength(Integer.parseInt(AttributeTypeEditorOverviewPage.this.syntaxLengthText.getText()));
            }
            AttributeTypeEditorOverviewPage.this.setEditorDirty();
        }
    };
    private VerifyListener syntaxLengthTextVerifyListener = new VerifyListener(){

        public void verifyText(VerifyEvent e) {
            if (!e.text.matches("[0-9]*")) {
                e.doit = false;
            }
        }
    };
    private SelectionAdapter obsoleteCheckboxListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            AttributeTypeEditorOverviewPage.this.modifiedAttributeType.setObsolete(AttributeTypeEditorOverviewPage.this.obsoleteCheckbox.getSelection());
            AttributeTypeEditorOverviewPage.this.setEditorDirty();
        }
    };
    private SelectionAdapter singleValueCheckboxListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            AttributeTypeEditorOverviewPage.this.modifiedAttributeType.setSingleValue(AttributeTypeEditorOverviewPage.this.singleValueCheckbox.getSelection());
            AttributeTypeEditorOverviewPage.this.setEditorDirty();
        }
    };
    private SelectionAdapter collectiveCheckboxListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            AttributeTypeEditorOverviewPage.this.modifiedAttributeType.setCollective(AttributeTypeEditorOverviewPage.this.collectiveCheckbox.getSelection());
            AttributeTypeEditorOverviewPage.this.setEditorDirty();
        }
    };
    private SelectionAdapter noUserModificationCheckboxListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            AttributeTypeEditorOverviewPage.this.modifiedAttributeType.setCanUserModify(!AttributeTypeEditorOverviewPage.this.noUserModificationCheckbox.getSelection());
            AttributeTypeEditorOverviewPage.this.setEditorDirty();
        }
    };
    private ISelectionChangedListener equalityComboViewerListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            Object selectedItem = ((StructuredSelection)AttributeTypeEditorOverviewPage.this.equalityComboViewer.getSelection()).getFirstElement();
            if (selectedItem instanceof MatchingRuleImpl) {
                AttributeTypeEditorOverviewPage.this.modifiedAttributeType.setEqualityName(((MatchingRuleImpl)((Object)selectedItem)).getName());
            } else if (selectedItem instanceof NonExistingMatchingRule) {
                NonExistingMatchingRule nemr = (NonExistingMatchingRule)selectedItem;
                if ("(None)".equals(nemr.getName())) {
                    AttributeTypeEditorOverviewPage.this.modifiedAttributeType.setEqualityName(null);
                } else {
                    AttributeTypeEditorOverviewPage.this.modifiedAttributeType.setEqualityName(((NonExistingMatchingRule)selectedItem).getName());
                }
            }
            AttributeTypeEditorOverviewPage.this.setEditorDirty();
        }
    };
    private ISelectionChangedListener orderingComboViewerListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            Object selectedItem = ((StructuredSelection)AttributeTypeEditorOverviewPage.this.orderingComboViewer.getSelection()).getFirstElement();
            if (selectedItem instanceof MatchingRuleImpl) {
                AttributeTypeEditorOverviewPage.this.modifiedAttributeType.setOrderingName(((MatchingRuleImpl)((Object)selectedItem)).getName());
            } else if (selectedItem instanceof NonExistingMatchingRule) {
                NonExistingMatchingRule nemr = (NonExistingMatchingRule)selectedItem;
                if ("(None)".equals(nemr.getName())) {
                    AttributeTypeEditorOverviewPage.this.modifiedAttributeType.setOrderingName(null);
                } else {
                    AttributeTypeEditorOverviewPage.this.modifiedAttributeType.setOrderingName(((NonExistingMatchingRule)selectedItem).getName());
                }
            }
            AttributeTypeEditorOverviewPage.this.setEditorDirty();
        }
    };
    private ISelectionChangedListener substringComboViewerListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            Object selectedItem = ((StructuredSelection)AttributeTypeEditorOverviewPage.this.substringComboViewer.getSelection()).getFirstElement();
            if (selectedItem instanceof MatchingRuleImpl) {
                AttributeTypeEditorOverviewPage.this.modifiedAttributeType.setSubstrName(((MatchingRuleImpl)((Object)selectedItem)).getName());
            } else if (selectedItem instanceof NonExistingMatchingRule) {
                NonExistingMatchingRule nemr = (NonExistingMatchingRule)selectedItem;
                if ("(None)".equals(nemr.getName())) {
                    AttributeTypeEditorOverviewPage.this.modifiedAttributeType.setSubstrName(null);
                } else {
                    AttributeTypeEditorOverviewPage.this.modifiedAttributeType.setSubstrName(((NonExistingMatchingRule)selectedItem).getName());
                }
            }
            AttributeTypeEditorOverviewPage.this.setEditorDirty();
        }
    };
    private Listener mouseWheelFilter = new Listener(){

        public void handleEvent(Event event) {
            if (event.widget instanceof Combo) {
                event.doit = false;
            }
        }
    };

    public AttributeTypeEditorOverviewPage(FormEditor editor) {
        super(editor, ID, Messages.getString("AttributeTypeEditorOverviewPage.Overview"));
        this.schemaHandler = Activator.getDefault().getSchemaHandler();
        this.schemaHandler.addListener(this.schemaHandlerListener);
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.modifiedAttributeType = ((AttributeTypeEditor)this.getEditor()).getModifiedAttributeType();
        this.originalAttributeType = ((AttributeTypeEditor)this.getEditor()).getOriginalAttributeType();
        this.originalSchema = this.schemaHandler.getSchema(this.originalAttributeType.getSchema());
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        GridLayout layout = new GridLayout();
        form.getBody().setLayout((Layout)layout);
        this.createGeneralInformationSection(form.getBody(), toolkit);
        this.createMatchingRulesSection(form.getBody(), toolkit);
        this.fillInUiFields();
        this.addListeners();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)form, PluginConstants.PLUGIN_ID + "." + "attribute_type_editor");
    }

    private void createGeneralInformationSection(Composite parent, FormToolkit toolkit) {
        Section section_general_information = toolkit.createSection(parent, 448);
        section_general_information.setDescription(Messages.getString("AttributeTypeEditorOverviewPage.SpecifyGeneralInformation"));
        section_general_information.setText(Messages.getString("AttributeTypeEditorOverviewPage.GeneralInformation"));
        Composite client_general_information = toolkit.createComposite((Composite)section_general_information);
        client_general_information.setLayout((Layout)new GridLayout(2, false));
        toolkit.paintBordersFor(client_general_information);
        section_general_information.setClient((Control)client_general_information);
        section_general_information.setLayoutData((Object)new GridData(4, 0, true, false));
        toolkit.createLabel(client_general_information, Messages.getString("AttributeTypeEditorOverviewPage.Aliases"));
        Composite aliasComposite = toolkit.createComposite(client_general_information);
        GridLayout aliasCompositeGridLayout = new GridLayout(2, false);
        toolkit.paintBordersFor(aliasComposite);
        aliasCompositeGridLayout.marginHeight = 1;
        aliasCompositeGridLayout.marginWidth = 1;
        aliasComposite.setLayout((Layout)aliasCompositeGridLayout);
        aliasComposite.setLayoutData((Object)new GridData(4, 0, true, false));
        this.aliasesText = toolkit.createText(aliasComposite, "");
        this.aliasesText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.aliasesButton = toolkit.createButton(aliasComposite, Messages.getString("AttributeTypeEditorOverviewPage.EditAliases"), 8);
        this.aliasesButton.setLayoutData((Object)new GridData(0, 0x1000000, false, false));
        toolkit.createLabel(client_general_information, Messages.getString("AttributeTypeEditorOverviewPage.OID"));
        this.oidText = toolkit.createText(client_general_information, "");
        this.oidText.setLayoutData((Object)new GridData(4, 0, true, false));
        toolkit.createLabel(client_general_information, Messages.getString("AttributeTypeEditorOverviewPage.Description"));
        this.descriptionText = toolkit.createText(client_general_information, "", 514);
        GridData descriptionGridData = new GridData(4, 0, true, false);
        descriptionGridData.heightHint = 42;
        this.descriptionText.setLayoutData((Object)descriptionGridData);
        this.schemaLink = toolkit.createHyperlink(client_general_information, Messages.getString("AttributeTypeEditorOverviewPage.Schema"), 64);
        this.schemaLabel = toolkit.createLabel(client_general_information, "");
        this.schemaLabel.setLayoutData((Object)new GridData(4, 0, true, false));
        this.supLabel = toolkit.createHyperlink(client_general_information, Messages.getString("AttributeTypeEditorOverviewPage.SuperiorType"), 64);
        this.supCombo = new Combo(client_general_information, 12);
        this.supCombo.setLayoutData((Object)new GridData(4, 0, true, false));
        this.supComboViewer = new ComboViewer(this.supCombo);
        this.supComboViewer.setContentProvider((IContentProvider)new ATESuperiorComboContentProvider());
        this.supComboViewer.setLabelProvider((IBaseLabelProvider)new ATESuperiorComboLabelProvider());
        toolkit.createLabel(client_general_information, Messages.getString("AttributeTypeEditorOverviewPage.Usage"));
        this.usageCombo = new Combo(client_general_information, 12);
        this.usageCombo.setLayoutData((Object)new GridData(4, 0, true, false));
        this.initUsageCombo();
        toolkit.createLabel(client_general_information, Messages.getString("AttributeTypeEditorOverviewPage.Syntax"));
        this.syntaxCombo = new Combo(client_general_information, 12);
        this.syntaxCombo.setLayoutData((Object)new GridData(4, 0, true, false));
        this.syntaxComboViewer = new ComboViewer(this.syntaxCombo);
        this.syntaxComboViewer.setContentProvider((IContentProvider)new ATESyntaxComboContentProvider());
        this.syntaxComboViewer.setLabelProvider((IBaseLabelProvider)new ATESyntaxComboLabelProvider());
        toolkit.createLabel(client_general_information, Messages.getString("AttributeTypeEditorOverviewPage.SyntaxLength"));
        this.syntaxLengthText = toolkit.createText(client_general_information, "");
        this.syntaxLengthText.setLayoutData((Object)new GridData(4, 0, true, false));
        toolkit.createLabel(client_general_information, "");
        Composite propertiesComposite = toolkit.createComposite(client_general_information);
        GridLayout propertiesCompositeGridLayout = new GridLayout(2, true);
        propertiesCompositeGridLayout.horizontalSpacing = 0;
        propertiesCompositeGridLayout.verticalSpacing = 0;
        propertiesCompositeGridLayout.marginHeight = 0;
        propertiesCompositeGridLayout.marginWidth = 0;
        propertiesComposite.setLayout((Layout)propertiesCompositeGridLayout);
        propertiesComposite.setLayoutData((Object)new GridData(4, 0, true, false));
        this.obsoleteCheckbox = toolkit.createButton(propertiesComposite, Messages.getString("AttributeTypeEditorOverviewPage.Obsolete"), 32);
        this.obsoleteCheckbox.setLayoutData((Object)new GridData(4, 0, true, false));
        this.singleValueCheckbox = toolkit.createButton(propertiesComposite, Messages.getString("AttributeTypeEditorOverviewPage.SingleValue"), 32);
        this.singleValueCheckbox.setLayoutData((Object)new GridData(4, 0, true, false));
        toolkit.createLabel(client_general_information, "");
        this.collectiveCheckbox = toolkit.createButton(propertiesComposite, Messages.getString("AttributeTypeEditorOverviewPage.Collective"), 32);
        this.collectiveCheckbox.setLayoutData((Object)new GridData(4, 0, true, false));
        this.noUserModificationCheckbox = toolkit.createButton(propertiesComposite, "No-User-Modification", 32);
        this.noUserModificationCheckbox.setLayoutData((Object)new GridData(4, 0, true, false));
    }

    private void createMatchingRulesSection(Composite parent, FormToolkit toolkit) {
        Section section_matching_rules = toolkit.createSection(parent, 448);
        section_matching_rules.setDescription(Messages.getString("AttributeTypeEditorOverviewPage.SpecifyMatchingRules"));
        section_matching_rules.setText(Messages.getString("AttributeTypeEditorOverviewPage.MatchingRules"));
        Composite client_matching_rules = toolkit.createComposite((Composite)section_matching_rules);
        GridLayout layout_matching_rules = new GridLayout();
        layout_matching_rules.numColumns = 2;
        client_matching_rules.setLayout((Layout)layout_matching_rules);
        toolkit.paintBordersFor(client_matching_rules);
        section_matching_rules.setClient((Control)client_matching_rules);
        section_matching_rules.setLayoutData((Object)new GridData(4, 4, true, true));
        toolkit.createLabel(client_matching_rules, Messages.getString("AttributeTypeEditorOverviewPage.Equality"));
        this.equalityCombo = new Combo(client_matching_rules, 12);
        this.equalityCombo.setLayoutData((Object)new GridData(4, 0, true, false));
        this.equalityComboViewer = new ComboViewer(this.equalityCombo);
        this.equalityComboViewer.setContentProvider((IContentProvider)new ATEMatchingRulesComboContentProvider());
        this.equalityComboViewer.setLabelProvider((IBaseLabelProvider)new ATEMatchingRulesComboLabelProvider());
        toolkit.createLabel(client_matching_rules, Messages.getString("AttributeTypeEditorOverviewPage.Ordering"));
        this.orderingCombo = new Combo(client_matching_rules, 12);
        this.orderingCombo.setLayoutData((Object)new GridData(4, 0, true, false));
        this.orderingComboViewer = new ComboViewer(this.orderingCombo);
        this.orderingComboViewer.setContentProvider((IContentProvider)new ATEMatchingRulesComboContentProvider());
        this.orderingComboViewer.setLabelProvider((IBaseLabelProvider)new ATEMatchingRulesComboLabelProvider());
        toolkit.createLabel(client_matching_rules, Messages.getString("AttributeTypeEditorOverviewPage.Substring"));
        this.substringCombo = new Combo(client_matching_rules, 12);
        this.substringCombo.setLayoutData((Object)new GridData(4, 0, true, false));
        this.substringComboViewer = new ComboViewer(this.substringCombo);
        this.substringComboViewer.setContentProvider((IContentProvider)new ATEMatchingRulesComboContentProvider());
        this.substringComboViewer.setLabelProvider((IBaseLabelProvider)new ATEMatchingRulesComboLabelProvider());
    }

    private void initUsageCombo() {
        this.usageCombo.add("Directory Operation", 0);
        this.usageCombo.add("Distributed Operation", 1);
        this.usageCombo.add("DSA Operation", 2);
        this.usageCombo.add("User Applications", 3);
    }

    private void fillInUiFields() {
        if (this.modifiedAttributeType.getNamesRef() != null && this.modifiedAttributeType.getNamesRef().length != 0) {
            this.aliasesText.setText(ViewUtils.concateAliases(this.modifiedAttributeType.getNamesRef()));
        } else {
            this.aliasesText.setText("");
        }
        if (this.modifiedAttributeType.getOid() != null) {
            this.oidText.setText(this.modifiedAttributeType.getOid());
        }
        this.schemaLabel.setText(this.modifiedAttributeType.getSchema());
        if (this.modifiedAttributeType.getDescription() != null) {
            this.descriptionText.setText(this.modifiedAttributeType.getDescription());
        }
        this.fillSupCombo();
        this.fillInUsageCombo();
        this.fillSyntaxCombo();
        if (this.modifiedAttributeType.getLength() != -1) {
            this.syntaxLengthText.setText(this.modifiedAttributeType.getLength() + "");
        }
        this.obsoleteCheckbox.setSelection(this.modifiedAttributeType.isObsolete());
        this.singleValueCheckbox.setSelection(this.modifiedAttributeType.isSingleValue());
        this.collectiveCheckbox.setSelection(this.modifiedAttributeType.isCollective());
        this.noUserModificationCheckbox.setSelection(!this.modifiedAttributeType.isCanUserModify());
        this.fillEqualityCombo();
        this.fillOrderingCombo();
        this.fillSubstringCombo();
    }

    private void fillSupCombo() {
        this.supComboViewer.setInput((Object)new ATESuperiorComboInput(this.originalAttributeType));
        String supAtName = this.modifiedAttributeType.getSuperiorName();
        if (supAtName == null) {
            this.supComboViewer.setSelection((ISelection)new StructuredSelection((Object)new NonExistingAttributeType("(None)")), true);
        } else {
            AttributeTypeImpl supAT = this.schemaHandler.getAttributeType(supAtName);
            if (supAT != null) {
                this.supComboViewer.setSelection((ISelection)new StructuredSelection((Object)supAT), true);
            } else {
                ATESuperiorComboInput input = (ATESuperiorComboInput)this.supComboViewer.getInput();
                NonExistingAttributeType neat = new NonExistingAttributeType(supAtName);
                if (!input.getChildren().contains(neat)) {
                    input.addChild(neat);
                }
                this.supComboViewer.refresh();
                this.supComboViewer.setSelection((ISelection)new StructuredSelection((Object)neat), true);
            }
        }
    }

    private void fillInUsageCombo() {
        if (this.modifiedAttributeType.getUsage() == UsageEnum.DIRECTORY_OPERATION) {
            this.usageCombo.select(0);
        } else if (this.modifiedAttributeType.getUsage() == UsageEnum.DISTRIBUTED_OPERATION) {
            this.usageCombo.select(1);
        } else if (this.modifiedAttributeType.getUsage() == UsageEnum.DSA_OPERATION) {
            this.usageCombo.select(2);
        } else if (this.modifiedAttributeType.getUsage() == UsageEnum.USER_APPLICATIONS) {
            this.usageCombo.select(3);
        }
    }

    private void fillSyntaxCombo() {
        this.syntaxComboViewer.setInput((Object)new ATESyntaxComboInput());
        String syntaxOID = this.modifiedAttributeType.getSyntaxOid();
        if (syntaxOID == null) {
            this.syntaxComboViewer.setSelection((ISelection)new StructuredSelection((Object)new NonExistingSyntax("(None)")), true);
        } else {
            SyntaxImpl syntax = this.schemaHandler.getSyntax(syntaxOID);
            if (syntax != null) {
                this.syntaxComboViewer.setSelection((ISelection)new StructuredSelection((Object)syntax), true);
            } else {
                ATESyntaxComboInput input = (ATESyntaxComboInput)this.syntaxComboViewer.getInput();
                NonExistingSyntax nes = new NonExistingSyntax(syntaxOID);
                if (!input.getChildren().contains(nes)) {
                    input.addChild(nes);
                }
                this.syntaxComboViewer.refresh();
                this.syntaxComboViewer.setSelection((ISelection)new StructuredSelection((Object)nes), true);
            }
        }
    }

    private void fillEqualityCombo() {
        this.equalityComboViewer.setInput((Object)new ATEMatchingRulesComboInput());
        String equalityName = this.modifiedAttributeType.getEqualityName();
        if (equalityName == null) {
            this.equalityComboViewer.setSelection((ISelection)new StructuredSelection((Object)new NonExistingMatchingRule("(None)")), true);
        } else {
            MatchingRuleImpl matchingRule = this.schemaHandler.getMatchingRule(equalityName);
            if (matchingRule != null) {
                this.equalityComboViewer.setSelection((ISelection)new StructuredSelection((Object)matchingRule), true);
            } else {
                ATEMatchingRulesComboInput input = (ATEMatchingRulesComboInput)this.equalityComboViewer.getInput();
                NonExistingMatchingRule nemr = new NonExistingMatchingRule(equalityName);
                if (!input.getChildren().contains(nemr)) {
                    input.addChild(nemr);
                }
                this.equalityComboViewer.refresh();
                this.equalityComboViewer.setSelection((ISelection)new StructuredSelection((Object)nemr), true);
            }
        }
    }

    private void fillOrderingCombo() {
        this.orderingComboViewer.setInput((Object)new ATEMatchingRulesComboInput());
        String orderingName = this.modifiedAttributeType.getOrderingName();
        if (orderingName == null) {
            this.orderingComboViewer.setSelection((ISelection)new StructuredSelection((Object)new NonExistingMatchingRule("(None)")), true);
        } else {
            MatchingRuleImpl matchingRule = this.schemaHandler.getMatchingRule(orderingName);
            if (matchingRule != null) {
                this.orderingComboViewer.setSelection((ISelection)new StructuredSelection((Object)matchingRule), true);
            } else {
                ATEMatchingRulesComboInput input = (ATEMatchingRulesComboInput)this.orderingComboViewer.getInput();
                NonExistingMatchingRule nemr = new NonExistingMatchingRule(orderingName);
                if (!input.getChildren().contains(nemr)) {
                    input.addChild(nemr);
                }
                this.orderingComboViewer.refresh();
                this.orderingComboViewer.setSelection((ISelection)new StructuredSelection((Object)nemr), true);
            }
        }
    }

    private void fillSubstringCombo() {
        this.substringComboViewer.setInput((Object)new ATEMatchingRulesComboInput());
        String substringName = this.modifiedAttributeType.getSubstrName();
        if (substringName == null) {
            this.substringComboViewer.setSelection((ISelection)new StructuredSelection((Object)new NonExistingMatchingRule("(None)")), true);
        } else {
            MatchingRuleImpl matchingRule = this.schemaHandler.getMatchingRule(substringName);
            if (matchingRule != null) {
                this.substringComboViewer.setSelection((ISelection)new StructuredSelection((Object)matchingRule), true);
            } else {
                ATEMatchingRulesComboInput input = (ATEMatchingRulesComboInput)this.substringComboViewer.getInput();
                NonExistingMatchingRule nemr = new NonExistingMatchingRule(substringName);
                if (!input.getChildren().contains(nemr)) {
                    input.addChild(nemr);
                }
                this.substringComboViewer.refresh();
                this.substringComboViewer.setSelection((ISelection)new StructuredSelection((Object)nemr), true);
            }
        }
    }

    private void addListeners() {
        this.aliasesText.addModifyListener(this.aliasesTextModifyListener);
        this.aliasesButton.addSelectionListener((SelectionListener)this.aliasesButtonListener);
        this.oidText.addModifyListener(this.oidTextModifyListener);
        this.oidText.addVerifyListener(this.oidTextVerifyListener);
        this.schemaLink.addHyperlinkListener((IHyperlinkListener)this.schemaLinkListener);
        this.descriptionText.addModifyListener(this.descriptionTextListener);
        this.supLabel.addHyperlinkListener((IHyperlinkListener)this.supLabelListener);
        this.supComboViewer.addSelectionChangedListener(this.supComboViewerListener);
        this.usageCombo.addModifyListener(this.usageComboListener);
        this.syntaxComboViewer.addSelectionChangedListener(this.syntaxComboViewerListener);
        this.syntaxLengthText.addModifyListener(this.syntaxLengthTextModifyListener);
        this.syntaxLengthText.addVerifyListener(this.syntaxLengthTextVerifyListener);
        this.obsoleteCheckbox.addSelectionListener((SelectionListener)this.obsoleteCheckboxListener);
        this.singleValueCheckbox.addSelectionListener((SelectionListener)this.singleValueCheckboxListener);
        this.collectiveCheckbox.addSelectionListener((SelectionListener)this.collectiveCheckboxListener);
        this.noUserModificationCheckbox.addSelectionListener((SelectionListener)this.noUserModificationCheckboxListener);
        this.equalityComboViewer.addSelectionChangedListener(this.equalityComboViewerListener);
        this.orderingComboViewer.addSelectionChangedListener(this.orderingComboViewerListener);
        this.substringComboViewer.addSelectionChangedListener(this.substringComboViewerListener);
        Display.getCurrent().addFilter(37, this.mouseWheelFilter);
    }

    private void removeListeners() {
        this.aliasesText.removeModifyListener(this.aliasesTextModifyListener);
        this.aliasesButton.removeSelectionListener((SelectionListener)this.aliasesButtonListener);
        this.oidText.removeModifyListener(this.oidTextModifyListener);
        this.oidText.removeVerifyListener(this.oidTextVerifyListener);
        this.schemaLink.removeHyperlinkListener((IHyperlinkListener)this.schemaLinkListener);
        this.descriptionText.removeModifyListener(this.descriptionTextListener);
        this.supLabel.removeHyperlinkListener((IHyperlinkListener)this.supLabelListener);
        this.supComboViewer.removeSelectionChangedListener(this.supComboViewerListener);
        this.usageCombo.removeModifyListener(this.usageComboListener);
        this.syntaxComboViewer.removeSelectionChangedListener(this.syntaxComboViewerListener);
        this.syntaxLengthText.removeModifyListener(this.syntaxLengthTextModifyListener);
        this.syntaxLengthText.removeVerifyListener(this.syntaxLengthTextVerifyListener);
        this.obsoleteCheckbox.removeSelectionListener((SelectionListener)this.obsoleteCheckboxListener);
        this.singleValueCheckbox.removeSelectionListener((SelectionListener)this.singleValueCheckboxListener);
        this.collectiveCheckbox.removeSelectionListener((SelectionListener)this.collectiveCheckboxListener);
        this.noUserModificationCheckbox.removeSelectionListener((SelectionListener)this.noUserModificationCheckboxListener);
        this.equalityComboViewer.removeSelectionChangedListener(this.equalityComboViewerListener);
        this.orderingComboViewer.removeSelectionChangedListener(this.orderingComboViewerListener);
        this.substringComboViewer.removeSelectionChangedListener(this.substringComboViewerListener);
        Display.getCurrent().removeFilter(37, this.mouseWheelFilter);
    }

    private void setEditorDirty() {
        ((AttributeTypeEditor)this.getEditor()).setDirty(true);
    }

    public void refreshUI() {
        this.removeListeners();
        this.fillInUiFields();
        this.addListeners();
    }

    public void dispose() {
        this.schemaHandler.removeListener(this.schemaHandlerListener);
        super.dispose();
    }
}

