/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.editors.attributetype;

import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.PluginConstants;
import org.apache.directory.studio.schemaeditor.PluginUtils;
import org.apache.directory.studio.schemaeditor.controller.AttributeTypeAdapter;
import org.apache.directory.studio.schemaeditor.controller.AttributeTypeListener;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandler;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandlerAdapter;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandlerListener;
import org.apache.directory.studio.schemaeditor.model.AttributeTypeImpl;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.AttributeTypeEditorInput;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.AttributeTypeEditorOverviewPage;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.AttributeTypeEditorSourceCodePage;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.AttributeTypeEditorUsedByPage;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.Messages;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;

public class AttributeTypeEditor
extends FormEditor {
    private static Logger logger = Logger.getLogger(AttributeTypeEditor.class);
    public static final String ID = PluginConstants.EDITOR_ATTRIBUTE_TYPE_ID;
    private AttributeTypeEditor instance;
    private boolean dirty = false;
    private AttributeTypeEditorOverviewPage overview;
    private AttributeTypeEditorSourceCodePage sourceCode;
    private AttributeTypeEditorUsedByPage usedBy;
    private AttributeTypeImpl originalAttributeType;
    private AttributeTypeImpl modifiedAttributeType;
    private Schema originalSchema;
    private IPageChangedListener pageChangedListener = new IPageChangedListener(){

        public void pageChanged(PageChangedEvent event) {
            Object selectedPage = event.getSelectedPage();
            if (selectedPage instanceof AttributeTypeEditorOverviewPage) {
                if (!AttributeTypeEditor.this.sourceCode.canLeaveThePage()) {
                    AttributeTypeEditor.this.notifyError(Messages.getString("AttributeTypeEditor.CodeErrors"));
                    return;
                }
                AttributeTypeEditor.this.overview.refreshUI();
            } else if (selectedPage instanceof AttributeTypeEditorSourceCodePage && AttributeTypeEditor.this.sourceCode.canLeaveThePage()) {
                AttributeTypeEditor.this.sourceCode.refreshUI();
            }
        }
    };
    private AttributeTypeListener attributeTypeListener = new AttributeTypeAdapter(){

        public void attributeTypeRemoved() {
            AttributeTypeEditor.this.getEditorSite().getPage().closeEditor((IEditorPart)AttributeTypeEditor.this.instance, false);
        }
    };
    private SchemaHandlerListener schemaHandlerListener = new SchemaHandlerAdapter(){

        public void schemaRemoved(Schema schema) {
            if (schema.equals(AttributeTypeEditor.this.originalSchema)) {
                AttributeTypeEditor.this.getEditorSite().getPage().closeEditor((IEditorPart)AttributeTypeEditor.this.instance, false);
            }
        }
    };

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.instance = this;
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setPartName(input.getName());
        this.originalAttributeType = ((AttributeTypeEditorInput)this.getEditorInput()).getAttributeType();
        this.modifiedAttributeType = PluginUtils.getClone(this.originalAttributeType);
        SchemaHandler schemaHandler = Activator.getDefault().getSchemaHandler();
        this.originalSchema = schemaHandler.getSchema(this.originalAttributeType.getSchema());
        schemaHandler.addListener(this.originalAttributeType, this.attributeTypeListener);
        schemaHandler.addListener(this.schemaHandlerListener);
        this.addPageChangedListener(this.pageChangedListener);
    }

    public void dispose() {
        SchemaHandler schemaHandler = Activator.getDefault().getSchemaHandler();
        schemaHandler.removeListener(this.originalAttributeType, this.attributeTypeListener);
        schemaHandler.removeListener(this.schemaHandlerListener);
        super.dispose();
    }

    protected void addPages() {
        try {
            this.overview = new AttributeTypeEditorOverviewPage(this);
            this.addPage((IFormPage)this.overview);
            this.sourceCode = new AttributeTypeEditorSourceCodePage(this);
            this.addPage((IFormPage)this.sourceCode);
            this.usedBy = new AttributeTypeEditorUsedByPage(this);
            this.addPage((IFormPage)this.usedBy);
        }
        catch (PartInitException e) {
            logger.debug((Object)"error when adding pages");
        }
    }

    public void doSave(IProgressMonitor monitor) {
        if (!this.sourceCode.canLeaveThePage()) {
            this.notifyError(Messages.getString("AttributeTypeEditor.AttributeErrors"));
            monitor.setCanceled(true);
            return;
        }
        Activator.getDefault().getSchemaHandler().modifyAttributeType(this.originalAttributeType, this.modifiedAttributeType);
        this.setPartName(this.getEditorInput().getName());
        if (!monitor.isCanceled()) {
            this.setDirty(false);
        }
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
        this.editorDirtyStateChanged();
    }

    public AttributeTypeImpl getOriginalAttributeType() {
        return this.originalAttributeType;
    }

    public AttributeTypeImpl getModifiedAttributeType() {
        return this.modifiedAttributeType;
    }

    public void setModifiedAttributeType(AttributeTypeImpl modifiedAttributeType) {
        this.modifiedAttributeType = modifiedAttributeType;
    }

    private void notifyError(String message) {
        MessageBox messageBox = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 33);
        messageBox.setMessage(message);
        messageBox.open();
    }
}

