/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.editors.attributetype;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandler;
import org.apache.directory.studio.schemaeditor.model.AttributeTypeImpl;
import org.apache.directory.studio.schemaeditor.model.ObjectClassImpl;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ATEUsedByOptionalTableContentProvider
implements IStructuredContentProvider {
    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof AttributeTypeImpl) {
            ArrayList<ObjectClassImpl> results = new ArrayList<ObjectClassImpl>();
            AttributeTypeImpl inputAT = (AttributeTypeImpl)((Object)inputElement);
            SchemaHandler schemaHandler = Activator.getDefault().getSchemaHandler();
            ArrayList<String> names = new ArrayList<String>();
            String[] atNames = inputAT.getNamesRef();
            if (atNames != null) {
                for (String name : atNames) {
                    names.add(name.toLowerCase());
                }
            }
            List<ObjectClassImpl> objectClasses = schemaHandler.getObjectClasses();
            for (ObjectClassImpl oc : objectClasses) {
                String[] mays = oc.getMayNamesList();
                if (mays == null) continue;
                for (String may : mays) {
                    if (!names.contains(may.toLowerCase())) continue;
                    results.add(oc);
                }
            }
            Collections.sort(results, new Comparator<ObjectClassImpl>(){

                @Override
                public int compare(ObjectClassImpl oc1, ObjectClassImpl oc2) {
                    if (oc1 instanceof ObjectClassImpl && oc1 instanceof ObjectClassImpl) {
                        String[] oc1Names = oc1.getNamesRef();
                        String[] oc2Names = oc2.getNamesRef();
                        if (oc1Names != null && oc2Names != null && oc1Names.length > 0 && oc2Names.length > 0) {
                            return oc1Names[0].compareToIgnoreCase(oc2Names[0]);
                        }
                    }
                    return 0;
                }
            });
            return results.toArray();
        }
        return null;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

