/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.editors.attributetype;

import java.util.Collections;
import java.util.List;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandler;
import org.apache.directory.studio.schemaeditor.model.AttributeTypeImpl;
import org.apache.directory.studio.schemaeditor.view.editors.NonExistingAttributeType;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.ATESuperiorComboComparator;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.ATESuperiorComboInput;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ATESuperiorComboContentProvider
implements IStructuredContentProvider {
    private SchemaHandler schemaHandler = Activator.getDefault().getSchemaHandler();

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof ATESuperiorComboInput) {
            ATESuperiorComboInput input = (ATESuperiorComboInput)inputElement;
            if (input.getChildren().isEmpty()) {
                AttributeTypeImpl editorAT = input.getAttributeType();
                input.addChild(new NonExistingAttributeType("(None)"));
                List<AttributeTypeImpl> ats = this.schemaHandler.getAttributeTypes();
                for (AttributeTypeImpl at : ats) {
                    if (this.isSubType(at, editorAT)) continue;
                    input.addChild((Object)at);
                }
            }
            List<Object> children = input.getChildren();
            Collections.sort(children, new ATESuperiorComboComparator());
            return children.toArray();
        }
        return new Object[0];
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    private boolean isSubType(AttributeTypeImpl at1, AttributeTypeImpl at2) {
        if (at1.equals((Object)at2)) {
            return true;
        }
        String sup = at1.getSuperiorName();
        if (sup == null) {
            return false;
        }
        AttributeTypeImpl supAT = this.schemaHandler.getAttributeType(sup);
        if (supAT == null) {
            return false;
        }
        return this.isSubType(supAT, at2);
    }
}

