/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.dialogs;

import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.controller.ProjectsHandler;
import org.apache.directory.studio.schemaeditor.view.dialogs.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class RenameProjectDialog
extends Dialog {
    private String originalName;
    private String newName;
    private ProjectsHandler projectsHandler;
    private Text newNameText;
    private Composite errorComposite;
    private Image errorImage;
    private Label errorLabel;
    private Button okButton;

    public RenameProjectDialog(String originalName) {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        this.originalName = originalName;
        this.projectsHandler = Activator.getDefault().getProjectsHandler();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("RenameProjectDialog.Rename"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label newNameLabel = new Label(composite, 0);
        newNameLabel.setText(Messages.getString("RenameProjectDialog.NewName"));
        this.newNameText = new Text(composite, 2048);
        this.newNameText.setLayoutData((Object)new GridData(4, 0, true, false));
        this.newNameText.setText(this.originalName);
        this.newNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RenameProjectDialog.this.newName = RenameProjectDialog.this.newNameText.getText();
                if (!RenameProjectDialog.this.newName.equals(RenameProjectDialog.this.originalName) && RenameProjectDialog.this.projectsHandler.isProjectNameAlreadyTaken(RenameProjectDialog.this.newName)) {
                    RenameProjectDialog.this.okButton.setEnabled(false);
                    RenameProjectDialog.this.errorComposite.setVisible(true);
                    return;
                }
                RenameProjectDialog.this.okButton.setEnabled(true);
                RenameProjectDialog.this.errorComposite.setVisible(false);
            }
        });
        this.errorComposite = new Composite(composite, 0);
        this.errorComposite.setLayout((Layout)new GridLayout(2, false));
        this.errorComposite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.errorComposite.setVisible(false);
        this.errorImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
        Label label = new Label(this.errorComposite, 0);
        label.setImage(this.errorImage);
        label.setSize(16, 16);
        this.errorLabel = new Label(this.errorComposite, 0);
        this.errorLabel.setLayoutData((Object)new GridData(4, 4, true, true));
        this.errorLabel.setText(Messages.getString("RenameProjectDialog.NameExists"));
        this.newNameText.setFocus();
        this.newNameText.selectAll();
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    public String getNewName() {
        return this.newName;
    }
}

