/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.dialogs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandler;
import org.apache.directory.studio.schemaeditor.model.ObjectClassImpl;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectClassSelectionDialogContentProvider
implements IStructuredContentProvider {
    private SchemaHandler schemaHandler = Activator.getDefault().getSchemaHandler();
    private List<ObjectClassImpl> hiddenObjectClasses;

    public ObjectClassSelectionDialogContentProvider(List<ObjectClassImpl> hiddenObjectClasses) {
        this.hiddenObjectClasses = hiddenObjectClasses;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof String) {
            ArrayList<ObjectClassImpl> results = new ArrayList<ObjectClassImpl>();
            String searchText = (String)inputElement;
            String searchRegexp = searchText.length() == 0 ? ".*" : searchText + ".*";
            Pattern pattern = Pattern.compile(searchRegexp, 2);
            List<ObjectClassImpl> ocList = this.schemaHandler.getObjectClasses();
            Collections.sort(ocList, new Comparator<ObjectClassImpl>(){

                @Override
                public int compare(ObjectClassImpl oc1, ObjectClassImpl oc2) {
                    String[] oc1Names = oc1.getNamesRef();
                    String[] oc2Names = oc2.getNamesRef();
                    if (!(oc1Names != null && oc1Names.length != 0 || oc2Names != null && oc2Names.length != 0)) {
                        return 0;
                    }
                    if ((oc1Names == null || oc1Names.length == 0) && oc2Names != null && oc2Names.length > 0) {
                        return "".compareToIgnoreCase(oc2Names[0]);
                    }
                    if (oc1Names != null && oc1Names.length > 0 && (oc2Names == null || oc2Names.length == 0)) {
                        return oc1Names[0].compareToIgnoreCase("");
                    }
                    return oc1Names[0].compareToIgnoreCase(oc2Names[0]);
                }
            });
            for (ObjectClassImpl oc : ocList) {
                Matcher m;
                for (String name : oc.getNamesRef()) {
                    Matcher m2 = pattern.matcher(name);
                    if (!m2.matches()) continue;
                    if (this.hiddenObjectClasses.contains((Object)oc) || results.contains((Object)oc)) break;
                    results.add(oc);
                    break;
                }
                if (!(m = pattern.matcher(oc.getOid())).matches() || this.hiddenObjectClasses.contains((Object)oc) || results.contains((Object)oc)) continue;
                results.add(oc);
            }
            return results.toArray();
        }
        return new Object[0];
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

