/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.dialogs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandler;
import org.apache.directory.studio.schemaeditor.model.AttributeTypeImpl;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeTypeSelectionDialogContentProvider
implements IStructuredContentProvider {
    private SchemaHandler schemaHandler;
    private List<AttributeTypeImpl> hiddenAttributeTypes;

    public AttributeTypeSelectionDialogContentProvider(List<AttributeTypeImpl> hiddenAttributeTypes) {
        this.hiddenAttributeTypes = hiddenAttributeTypes;
        this.schemaHandler = Activator.getDefault().getSchemaHandler();
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof String) {
            ArrayList<AttributeTypeImpl> results = new ArrayList<AttributeTypeImpl>();
            String searchText = (String)inputElement;
            String searchRegexp = searchText.length() == 0 ? ".*" : searchText + ".*";
            Pattern pattern = Pattern.compile(searchRegexp, 2);
            List<AttributeTypeImpl> atList = this.schemaHandler.getAttributeTypes();
            Collections.sort(atList, new Comparator<AttributeTypeImpl>(){

                @Override
                public int compare(AttributeTypeImpl at1, AttributeTypeImpl at2) {
                    String[] at1Names = at1.getNamesRef();
                    String[] at2Names = at2.getNamesRef();
                    if (!(at1Names != null && at1Names.length != 0 || at2Names != null && at2Names.length != 0)) {
                        return 0;
                    }
                    if ((at1Names == null || at1Names.length == 0) && at2Names != null && at2Names.length > 0) {
                        return "".compareToIgnoreCase(at2Names[0]);
                    }
                    if (at1Names != null && at1Names.length > 0 && (at2Names == null || at2Names.length == 0)) {
                        return at1Names[0].compareToIgnoreCase("");
                    }
                    return at1Names[0].compareToIgnoreCase(at2Names[0]);
                }
            });
            for (AttributeTypeImpl at : atList) {
                Matcher m;
                for (String name : at.getNamesRef()) {
                    Matcher m2 = pattern.matcher(name);
                    if (!m2.matches()) continue;
                    if (this.hiddenAttributeTypes.contains((Object)at) || results.contains((Object)at)) break;
                    results.add(at);
                    break;
                }
                if (!(m = pattern.matcher(at.getOid())).matches() || this.hiddenAttributeTypes.contains((Object)at) || results.contains((Object)at)) continue;
                results.add(at);
            }
            return results.toArray();
        }
        return new Object[0];
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

