/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.model.AttributeTypeImpl;
import org.apache.directory.studio.schemaeditor.view.dialogs.AttributeTypeSelectionDialogContentProvider;
import org.apache.directory.studio.schemaeditor.view.dialogs.AttributeTypeSelectionDialogLabelProvider;
import org.apache.directory.studio.schemaeditor.view.dialogs.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeTypeSelectionDialog
extends Dialog {
    private AttributeTypeImpl selectedAttributeType;
    private List<AttributeTypeImpl> hiddenAttributeTypes = new ArrayList<AttributeTypeImpl>();
    private Text searchText;
    private Table attributeTypesTable;
    private TableViewer attributeTypesTableViewer;
    private Label schemaIconLabel;
    private Label schemaNameLabel;
    private Button chooseButton;

    public AttributeTypeSelectionDialog() {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("AttributeTypeSelectionDialog.TypeSelection"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        Label chooseLabel = new Label(composite, 0);
        chooseLabel.setText(Messages.getString("AttributeTypeSelectionDialog.ChooseAType"));
        chooseLabel.setLayoutData((Object)new GridData(4, 0, true, false));
        this.searchText = new Text(composite, 2048);
        this.searchText.setLayoutData((Object)new GridData(4, 0, true, false));
        this.searchText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AttributeTypeSelectionDialog.this.setSearchInput(AttributeTypeSelectionDialog.this.searchText.getText());
            }
        });
        this.searchText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    AttributeTypeSelectionDialog.this.attributeTypesTable.setFocus();
                }
            }
        });
        Label matchingLabel = new Label(composite, 0);
        matchingLabel.setText(Messages.getString("AttributeTypeSelectionDialog.MatchingTypes"));
        matchingLabel.setLayoutData((Object)new GridData(4, 0, true, false));
        this.attributeTypesTable = new Table(composite, 101124);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 148;
        gridData.minimumHeight = 148;
        gridData.widthHint = 350;
        gridData.minimumWidth = 350;
        this.attributeTypesTable.setLayoutData((Object)gridData);
        this.attributeTypesTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (AttributeTypeSelectionDialog.this.attributeTypesTable.getSelectionIndex() != -1) {
                    AttributeTypeSelectionDialog.this.okPressed();
                }
            }
        });
        this.attributeTypesTableViewer = new TableViewer(this.attributeTypesTable);
        this.attributeTypesTableViewer.setContentProvider((IContentProvider)new AttributeTypeSelectionDialogContentProvider(this.hiddenAttributeTypes));
        this.attributeTypesTableViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new AttributeTypeSelectionDialogLabelProvider(), Activator.getDefault().getWorkbench().getDecoratorManager().getLabelDecorator()));
        this.attributeTypesTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)AttributeTypeSelectionDialog.this.attributeTypesTableViewer.getSelection();
                if (selection.isEmpty()) {
                    if (AttributeTypeSelectionDialog.this.chooseButton != null && !AttributeTypeSelectionDialog.this.chooseButton.isDisposed()) {
                        AttributeTypeSelectionDialog.this.chooseButton.setEnabled(false);
                    }
                    AttributeTypeSelectionDialog.this.schemaIconLabel.setImage(Activator.getDefault().getImage("resources/icons/transparent_16x16.gif"));
                    AttributeTypeSelectionDialog.this.schemaNameLabel.setText("");
                } else {
                    if (AttributeTypeSelectionDialog.this.chooseButton != null && !AttributeTypeSelectionDialog.this.chooseButton.isDisposed()) {
                        AttributeTypeSelectionDialog.this.chooseButton.setEnabled(true);
                    }
                    AttributeTypeSelectionDialog.this.schemaIconLabel.setImage(Activator.getDefault().getImage("resources/icons/schema.gif"));
                    AttributeTypeSelectionDialog.this.schemaNameLabel.setText(((AttributeTypeImpl)((Object)selection.getFirstElement())).getSchema());
                }
            }
        });
        Composite schemaComposite = new Composite(composite, 2048);
        schemaComposite.setLayoutData((Object)new GridData(4, 0, true, false));
        GridLayout schemaCompositeGridLayout = new GridLayout(2, false);
        schemaCompositeGridLayout.horizontalSpacing = 0;
        schemaCompositeGridLayout.verticalSpacing = 0;
        schemaCompositeGridLayout.marginWidth = 2;
        schemaCompositeGridLayout.marginHeight = 2;
        schemaComposite.setLayout((Layout)schemaCompositeGridLayout);
        this.schemaIconLabel = new Label(schemaComposite, 0);
        GridData schemaIconLabelGridData = new GridData(0, 1024, false, false);
        schemaIconLabelGridData.widthHint = 18;
        schemaIconLabelGridData.heightHint = 16;
        this.schemaIconLabel.setLayoutData((Object)schemaIconLabelGridData);
        this.schemaIconLabel.setImage(Activator.getDefault().getImage("resources/icons/transparent_16x16.gif"));
        this.schemaNameLabel = new Label(schemaComposite, 0);
        this.schemaNameLabel.setLayoutData((Object)new GridData(4, 1024, true, false));
        this.schemaNameLabel.setText("");
        this.setSearchInput("");
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.chooseButton = this.createButton(parent, 0, "Choose", true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        StructuredSelection selection = (StructuredSelection)this.attributeTypesTableViewer.getSelection();
        if (selection.isEmpty()) {
            if (this.chooseButton != null && !this.chooseButton.isDisposed()) {
                this.chooseButton.setEnabled(false);
            }
        } else if (this.chooseButton != null && !this.chooseButton.isDisposed()) {
            this.chooseButton.setEnabled(true);
        }
    }

    protected void okPressed() {
        StructuredSelection selection = (StructuredSelection)this.attributeTypesTableViewer.getSelection();
        if (selection.isEmpty()) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("AttributeTypeSelectionDialog.InvalidSelection"), (String)Messages.getString("AttributeTypeSelectionDialog.MustChooseType"));
            return;
        }
        this.selectedAttributeType = (AttributeTypeImpl)((Object)selection.getFirstElement());
        super.okPressed();
    }

    public AttributeTypeImpl getSelectedAttributeType() {
        return this.selectedAttributeType;
    }

    public void setHiddenAttributeTypes(List<AttributeTypeImpl> list) {
        this.hiddenAttributeTypes = list;
    }

    public void setHiddenAttributeTypes(AttributeTypeImpl[] attributeTypes) {
        for (AttributeTypeImpl objectClass : attributeTypes) {
            this.hiddenAttributeTypes.add(objectClass);
        }
    }

    private void setSearchInput(String searchString) {
        this.attributeTypesTableViewer.setInput((Object)searchString);
        Object firstElement = this.attributeTypesTableViewer.getElementAt(0);
        if (firstElement != null) {
            this.attributeTypesTableViewer.setSelection((ISelection)new StructuredSelection(firstElement), true);
        }
    }

    public boolean close() {
        this.hiddenAttributeTypes.clear();
        this.hiddenAttributeTypes = null;
        this.attributeTypesTableViewer = null;
        this.attributeTypesTable.dispose();
        this.attributeTypesTable = null;
        this.searchText.dispose();
        this.searchText = null;
        this.schemaIconLabel.dispose();
        this.schemaIconLabel = null;
        this.schemaNameLabel.dispose();
        this.schemaNameLabel = null;
        return super.close();
    }
}

