/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view;

import org.apache.directory.studio.schemaeditor.view.Messages;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.PlatformUI;

public class ViewUtils {
    public static final Color COLOR_BLACK = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay().getSystemColor(2);
    public static final Color COLOR_RED = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay().getSystemColor(3);

    public static String concateAliases(String[] aliases) {
        StringBuffer sb = new StringBuffer();
        if (aliases.length > 0) {
            sb.append(aliases[0]);
            for (int i = 1; i < aliases.length; ++i) {
                sb.append(", ");
                sb.append(aliases[i]);
            }
        }
        return sb.toString();
    }

    public static boolean verifyName(String name) {
        return name.matches(Messages.getString("ViewUtils.AllowedCharacters"));
    }

    public static int displayErrorMessageBox(String title, String message) {
        return ViewUtils.displayMessageBox(33, title, message);
    }

    public static int displayWarningMessageBox(String title, String message) {
        return ViewUtils.displayMessageBox(40, title, message);
    }

    public static int displayInformationMessageBox(String title, String message) {
        return ViewUtils.displayMessageBox(34, title, message);
    }

    public static int displayQuestionMessageBox(int buttonStyle, String title, String message) {
        return ViewUtils.displayMessageBox(4 | buttonStyle, title, message);
    }

    private static int displayMessageBox(int style, String title, String message) {
        MessageBox messageBox = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), style);
        messageBox.setText(title);
        messageBox.setMessage(message);
        return messageBox.open();
    }
}

