/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.model.schemachecker;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.directory.shared.ldap.schema.ObjectClassTypeEnum;
import org.apache.directory.shared.ldap.schema.SchemaObject;
import org.apache.directory.shared.ldap.schema.UsageEnum;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.controller.ProjectsHandlerAdapter;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandler;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandlerAdapter;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandlerListener;
import org.apache.directory.studio.schemaeditor.model.AttributeTypeImpl;
import org.apache.directory.studio.schemaeditor.model.MatchingRuleImpl;
import org.apache.directory.studio.schemaeditor.model.ObjectClassImpl;
import org.apache.directory.studio.schemaeditor.model.Project;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.model.SyntaxImpl;
import org.apache.directory.studio.schemaeditor.model.schemachecker.ClassTypeHierarchyError;
import org.apache.directory.studio.schemaeditor.model.schemachecker.DifferentCollectiveAsSuperiorError;
import org.apache.directory.studio.schemaeditor.model.schemachecker.DifferentUsageAsSuperiorError;
import org.apache.directory.studio.schemaeditor.model.schemachecker.DuplicateAliasError;
import org.apache.directory.studio.schemaeditor.model.schemachecker.DuplicateOidError;
import org.apache.directory.studio.schemaeditor.model.schemachecker.NoAliasWarning;
import org.apache.directory.studio.schemaeditor.model.schemachecker.NonExistingATSuperiorError;
import org.apache.directory.studio.schemaeditor.model.schemachecker.NonExistingMandatoryATError;
import org.apache.directory.studio.schemaeditor.model.schemachecker.NonExistingMatchingRuleError;
import org.apache.directory.studio.schemaeditor.model.schemachecker.NonExistingOCSuperiorError;
import org.apache.directory.studio.schemaeditor.model.schemachecker.NonExistingOptionalATError;
import org.apache.directory.studio.schemaeditor.model.schemachecker.NonExistingSyntaxError;
import org.apache.directory.studio.schemaeditor.model.schemachecker.SchemaCheckerListener;
import org.apache.directory.studio.schemaeditor.model.schemachecker.SchemaError;
import org.apache.directory.studio.schemaeditor.model.schemachecker.SchemaWarning;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaChecker {
    private static SchemaChecker instance;
    private List<SchemaError> errorsList;
    private MultiMap errorsMap;
    private List<SchemaWarning> warningsList;
    private MultiMap warningsMap;
    private MultiMap dependenciesMap;
    private MultiMap dependsOnMap;
    private boolean listeningToModifications = false;
    private List<SchemaCheckerListener> listeners;
    private SchemaHandlerListener schemaHandlerListener = new SchemaHandlerAdapter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void attributeTypeAdded(AttributeTypeImpl at) {
            1 var2_2 = this;
            synchronized (var2_2) {
                List deps = SchemaChecker.this.getAndDeleteDependencies((SchemaObject)at);
                SchemaChecker.this.checkAttributeType(at);
                SchemaChecker.this.checkDependencies(deps);
                SchemaChecker.this.notifyListeners();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void attributeTypeModified(AttributeTypeImpl at) {
            1 var2_2 = this;
            synchronized (var2_2) {
                ArrayList deps = new ArrayList();
                List atDeps = (List)SchemaChecker.this.dependenciesMap.get((Object)at);
                if (atDeps != null) {
                    deps.addAll(atDeps);
                }
                SchemaChecker.this.checkAttributeType(at);
                SchemaChecker.this.checkDependencies(deps);
                SchemaChecker.this.notifyListeners();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void attributeTypeRemoved(AttributeTypeImpl at) {
            1 var2_2 = this;
            synchronized (var2_2) {
                ArrayList deps = new ArrayList();
                List atDeps = (List)SchemaChecker.this.dependenciesMap.get((Object)at);
                if (atDeps != null) {
                    deps.addAll(atDeps);
                }
                SchemaChecker.this.removeSchemaObject((SchemaObject)at);
                SchemaChecker.this.checkDependencies(deps);
                SchemaChecker.this.notifyListeners();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void objectClassAdded(ObjectClassImpl oc) {
            1 var2_2 = this;
            synchronized (var2_2) {
                List deps = SchemaChecker.this.getAndDeleteDependencies((SchemaObject)oc);
                SchemaChecker.this.checkObjectClass(oc);
                SchemaChecker.this.checkDependencies(deps);
                SchemaChecker.this.notifyListeners();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void objectClassModified(ObjectClassImpl oc) {
            1 var2_2 = this;
            synchronized (var2_2) {
                ArrayList deps = new ArrayList();
                List ocDeps = (List)SchemaChecker.this.dependenciesMap.get((Object)oc);
                if (ocDeps != null) {
                    deps.addAll(ocDeps);
                }
                SchemaChecker.this.checkObjectClass(oc);
                SchemaChecker.this.checkDependencies(deps);
                SchemaChecker.this.notifyListeners();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void objectClassRemoved(ObjectClassImpl oc) {
            1 var2_2 = this;
            synchronized (var2_2) {
                ArrayList deps = new ArrayList();
                List ocDeps = (List)SchemaChecker.this.dependenciesMap.get((Object)oc);
                if (ocDeps != null) {
                    deps.addAll(ocDeps);
                }
                SchemaChecker.this.removeSchemaObject((SchemaObject)oc);
                SchemaChecker.this.checkDependencies(deps);
                SchemaChecker.this.notifyListeners();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void schemaAdded(Schema schema) {
            1 var2_2 = this;
            synchronized (var2_2) {
                List<AttributeTypeImpl> ats = schema.getAttributeTypes();
                for (AttributeTypeImpl at : ats) {
                    SchemaChecker.this.checkAttributeType(at);
                }
                List<ObjectClassImpl> ocs = schema.getObjectClasses();
                for (ObjectClassImpl oc : ocs) {
                    SchemaChecker.this.checkObjectClass(oc);
                }
                SchemaChecker.this.notifyListeners();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void schemaRemoved(Schema schema) {
            1 var2_2 = this;
            synchronized (var2_2) {
                List<AttributeTypeImpl> ats = schema.getAttributeTypes();
                for (AttributeTypeImpl at : ats) {
                    SchemaChecker.this.removeSchemaObject((SchemaObject)at);
                }
                List<ObjectClassImpl> ocs = schema.getObjectClasses();
                for (ObjectClassImpl oc : ocs) {
                    SchemaChecker.this.removeSchemaObject((SchemaObject)oc);
                }
                SchemaChecker.this.notifyListeners();
            }
        }
    };

    private SchemaChecker() {
        this.errorsList = new ArrayList<SchemaError>();
        this.errorsMap = new MultiValueMap();
        this.warningsList = new ArrayList<SchemaWarning>();
        this.warningsMap = new MultiValueMap();
        this.dependenciesMap = new MultiValueMap();
        this.dependsOnMap = new MultiValueMap();
        this.listeners = new ArrayList<SchemaCheckerListener>();
        Activator.getDefault().getProjectsHandler().addListener(new ProjectsHandlerAdapter(){

            public void openProjectChanged(Project oldProject, Project newProject) {
                if (oldProject != null) {
                    oldProject.getSchemaHandler().removeListener(SchemaChecker.this.schemaHandlerListener);
                }
                if (newProject != null) {
                    newProject.getSchemaHandler().addListener(SchemaChecker.this.schemaHandlerListener);
                }
            }
        });
    }

    public static SchemaChecker getInstance() {
        if (instance == null) {
            instance = new SchemaChecker();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableModificationsListening() {
        SchemaChecker schemaChecker = this;
        synchronized (schemaChecker) {
            if (!this.listeningToModifications) {
                Activator.getDefault().getSchemaHandler().addListener(this.schemaHandlerListener);
                this.listeningToModifications = true;
                this.checkWholeSchema();
                this.notifyListeners();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableModificationsListening() {
        SchemaChecker schemaChecker = this;
        synchronized (schemaChecker) {
            if (this.listeningToModifications) {
                Activator.getDefault().getSchemaHandler().removeListener(this.schemaHandlerListener);
                this.listeningToModifications = false;
                this.clearErrorsAndWarnings();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        SchemaChecker schemaChecker = this;
        synchronized (schemaChecker) {
            this.clearErrorsAndWarnings();
            this.checkWholeSchema();
        }
    }

    public boolean isListeningToModifications() {
        return this.listeningToModifications;
    }

    private void clearErrorsAndWarnings() {
        this.errorsList.clear();
        this.errorsMap.clear();
        this.warningsList.clear();
        this.warningsMap.clear();
        this.dependenciesMap.clear();
        this.dependsOnMap.clear();
    }

    private synchronized void checkWholeSchema() {
        Job job = new Job("Checking Schema"){

            protected IStatus run(IProgressMonitor monitor) {
                SchemaHandler schemaHandler = Activator.getDefault().getSchemaHandler();
                if (schemaHandler != null) {
                    List<Schema> schemas = schemaHandler.getSchemas();
                    monitor.beginTask("Checking schemas: ", schemas.size());
                    for (Schema schema : schemas) {
                        monitor.subTask(schema.getName());
                        List<AttributeTypeImpl> ats = schema.getAttributeTypes();
                        for (AttributeTypeImpl at : ats) {
                            SchemaChecker.this.checkAttributeType(at);
                        }
                        List<ObjectClassImpl> ocs = schema.getObjectClasses();
                        for (ObjectClassImpl oc : ocs) {
                            SchemaChecker.this.checkObjectClass(oc);
                        }
                        monitor.worked(1);
                    }
                }
                SchemaChecker.this.notifyListeners();
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    private void checkAttributeType(AttributeTypeImpl at) {
        String substring;
        String ordering;
        String equality;
        String syntaxOid;
        SchemaError error;
        String[] aliases;
        SchemaError error2;
        List<?> list;
        this.removeSchemaObject((SchemaObject)at);
        String oid = at.getOid();
        if (oid != null && !"".equals(oid) && (list = this.getSchemaElementList(oid)) != null && list.size() >= 2) {
            int counter = 0;
            Object o = list.get(counter);
            while (at.equals(o) && counter < list.size() - 1) {
                o = list.get(++counter);
            }
            error2 = new DuplicateOidError((SchemaObject)at, oid, (SchemaObject)o);
            this.errorsList.add(error2);
            this.errorsMap.put((Object)at, (Object)error2);
        }
        if ((aliases = at.getNamesRef()) == null || aliases.length == 0) {
            NoAliasWarning warning = new NoAliasWarning((SchemaObject)at);
            this.warningsList.add(warning);
            this.warningsMap.put((Object)at, (Object)warning);
        } else if (aliases != null && aliases.length >= 1) {
            for (String alias : aliases) {
                List<?> list2 = this.getSchemaElementList(alias);
                if (list2 == null || list2.size() < 2) continue;
                int counter = 0;
                Object o = list2.get(counter);
                while (at.equals(o) && counter < list2.size() - 1) {
                    o = list2.get(++counter);
                }
                DuplicateAliasError error3 = new DuplicateAliasError((SchemaObject)at, alias, (SchemaObject)o);
                this.errorsList.add(error3);
                this.errorsMap.put((Object)at, (Object)error3);
            }
        }
        String superior = at.getSuperiorName();
        if (superior != null && !"".equals(superior)) {
            AttributeTypeImpl superiorAT = Activator.getDefault().getSchemaHandler().getAttributeType(superior);
            if (superiorAT == null) {
                error2 = new NonExistingATSuperiorError((SchemaObject)at, superior);
                this.errorsList.add(error2);
                this.errorsMap.put((Object)at, (Object)error2);
                this.dependenciesMap.put((Object)superior, (Object)at);
                this.dependsOnMap.put((Object)at, (Object)superior);
            } else {
                this.dependenciesMap.put((Object)superiorAT, (Object)at);
                this.dependsOnMap.put((Object)at, (Object)superiorAT);
                UsageEnum usage = at.getUsage();
                UsageEnum superiorATUsage = superiorAT.getUsage();
                if (!usage.equals((Object)superiorATUsage)) {
                    DifferentUsageAsSuperiorError error4 = new DifferentUsageAsSuperiorError((SchemaObject)at, (SchemaObject)superiorAT);
                    this.errorsList.add(error4);
                    this.errorsMap.put((Object)at, (Object)error4);
                }
                boolean collective = at.isCollective();
                boolean superiorATCollective = superiorAT.isCollective();
                if (superiorATCollective && !collective) {
                    error = new DifferentCollectiveAsSuperiorError((SchemaObject)at, (SchemaObject)superiorAT);
                    this.errorsList.add(error);
                    this.errorsMap.put((Object)at, (Object)error);
                }
            }
        }
        if ((syntaxOid = at.getSyntaxOid()) != null && !"".equals(syntaxOid)) {
            SyntaxImpl syntax = Activator.getDefault().getSchemaHandler().getSyntax(syntaxOid);
            if (syntax == null) {
                NonExistingSyntaxError error5 = new NonExistingSyntaxError((SchemaObject)at, syntaxOid);
                this.errorsList.add(error5);
                this.errorsMap.put((Object)at, (Object)error5);
                this.dependenciesMap.put((Object)syntaxOid, (Object)at);
                this.dependsOnMap.put((Object)at, (Object)syntaxOid);
            } else {
                this.dependenciesMap.put((Object)syntax, (Object)at);
                this.dependsOnMap.put((Object)at, (Object)syntax);
            }
        }
        if ((equality = at.getEqualityName()) != null && !"".equals(equality)) {
            MatchingRuleImpl equalityMR = Activator.getDefault().getSchemaHandler().getMatchingRule(equality);
            if (equalityMR == null) {
                NonExistingMatchingRuleError error6 = new NonExistingMatchingRuleError((SchemaObject)at, equality, NonExistingMatchingRuleError.NonExistingMatchingRuleErrorEnum.EQUALITY);
                this.errorsList.add(error6);
                this.errorsMap.put((Object)at, (Object)error6);
                this.dependenciesMap.put((Object)equality, (Object)at);
                this.dependsOnMap.put((Object)at, (Object)equality);
            } else {
                this.dependenciesMap.put((Object)equalityMR, (Object)at);
                this.dependsOnMap.put((Object)at, (Object)equalityMR);
            }
        }
        if ((ordering = at.getOrderingName()) != null && !"".equals(ordering)) {
            MatchingRuleImpl orderingMR = Activator.getDefault().getSchemaHandler().getMatchingRule(ordering);
            if (orderingMR == null) {
                NonExistingMatchingRuleError error7 = new NonExistingMatchingRuleError((SchemaObject)at, ordering, NonExistingMatchingRuleError.NonExistingMatchingRuleErrorEnum.ORDERING);
                this.errorsList.add(error7);
                this.errorsMap.put((Object)at, (Object)error7);
                this.dependenciesMap.put((Object)ordering, (Object)at);
                this.dependsOnMap.put((Object)at, (Object)ordering);
            } else {
                this.dependenciesMap.put((Object)orderingMR, (Object)at);
                this.dependsOnMap.put((Object)at, (Object)orderingMR);
            }
        }
        if ((substring = at.getSubstrName()) != null && !"".equals(substring)) {
            MatchingRuleImpl substringMR = Activator.getDefault().getSchemaHandler().getMatchingRule(substring);
            if (substringMR == null) {
                error = new NonExistingMatchingRuleError((SchemaObject)at, substring, NonExistingMatchingRuleError.NonExistingMatchingRuleErrorEnum.SUBSTRING);
                this.errorsList.add(error);
                this.errorsMap.put((Object)at, (Object)error);
                this.dependenciesMap.put((Object)substring, (Object)at);
                this.dependsOnMap.put((Object)at, (Object)substring);
            } else {
                this.dependenciesMap.put((Object)substringMR, (Object)at);
                this.dependsOnMap.put((Object)at, (Object)substringMR);
            }
        }
    }

    private void checkObjectClass(ObjectClassImpl oc) {
        SchemaError error;
        SchemaError error2;
        String[] aliases;
        List<?> list;
        this.removeSchemaObject((SchemaObject)oc);
        String oid = oc.getOid();
        if (oid != null && !"".equals(oid) && (list = this.getSchemaElementList(oid)) != null && list.size() >= 2) {
            int counter = 0;
            Object o = list.get(counter);
            while (oc.equals(o) && counter < list.size() - 1) {
                o = list.get(++counter);
            }
            DuplicateOidError error3 = new DuplicateOidError((SchemaObject)oc, oid, (SchemaObject)o);
            this.errorsList.add(error3);
            this.errorsMap.put((Object)oc, (Object)error3);
        }
        if ((aliases = oc.getNamesRef()) == null || aliases.length == 0) {
            NoAliasWarning warning = new NoAliasWarning((SchemaObject)oc);
            this.warningsList.add(warning);
            this.warningsMap.put((Object)oc, (Object)warning);
        } else if (aliases != null && aliases.length >= 1) {
            for (String alias : aliases) {
                List<?> list2 = this.getSchemaElementList(alias);
                if (list2 == null || list2.size() < 2) continue;
                int counter = 0;
                Object o = list2.get(counter);
                while (oc.equals(o) && counter < list2.size() - 1) {
                    o = list2.get(++counter);
                }
                error2 = new DuplicateAliasError((SchemaObject)oc, oid, (SchemaObject)o);
                this.errorsList.add(error2);
                this.errorsMap.put((Object)oc, (Object)error2);
            }
        }
        String[] superiors = oc.getSuperClassesNames();
        if (superiors != null && superiors.length >= 1) {
            ObjectClassTypeEnum type = oc.getType();
            block7: for (String superior : superiors) {
                ObjectClassImpl superiorOC = Activator.getDefault().getSchemaHandler().getObjectClass(superior);
                if (superiorOC == null) {
                    error2 = new NonExistingOCSuperiorError((SchemaObject)oc, superior);
                    this.errorsList.add(error2);
                    this.errorsMap.put((Object)oc, (Object)error2);
                    this.dependenciesMap.put((Object)superior, (Object)oc);
                    this.dependsOnMap.put((Object)oc, (Object)superior);
                    continue;
                }
                this.dependenciesMap.put((Object)superiorOC, (Object)oc);
                this.dependsOnMap.put((Object)oc, (Object)superiorOC);
                ObjectClassTypeEnum superiorOCType = superiorOC.getType();
                switch (type) {
                    case ABSTRACT: {
                        if (superiorOCType.equals((Object)ObjectClassTypeEnum.ABSTRACT) || superiorOC.getOid().equals("2.5.6.0")) continue block7;
                        error = new ClassTypeHierarchyError((SchemaObject)oc, (SchemaObject)superiorOC);
                        this.errorsList.add(error);
                        this.errorsMap.put((Object)oc, (Object)error);
                        continue block7;
                    }
                    case AUXILIARY: {
                        if (!superiorOCType.equals((Object)ObjectClassTypeEnum.STRUCTURAL) || superiorOC.getOid().equals("2.5.6.0")) continue block7;
                        error = new ClassTypeHierarchyError((SchemaObject)oc, (SchemaObject)superiorOC);
                        this.errorsList.add(error);
                        this.errorsMap.put((Object)oc, (Object)error);
                        continue block7;
                    }
                }
            }
        }
        String[] mandatoryATNames = oc.getMustNamesList();
        String[] optionalATNames = oc.getMayNamesList();
        if (mandatoryATNames != null && optionalATNames != null) {
            for (String mandatoryATName : mandatoryATNames) {
                AttributeTypeImpl mandatoryAT = Activator.getDefault().getSchemaHandler().getAttributeType(mandatoryATName);
                if (mandatoryAT == null) {
                    error = new NonExistingMandatoryATError((SchemaObject)oc, mandatoryATName);
                    this.errorsList.add(error);
                    this.errorsMap.put((Object)oc, (Object)error);
                    this.dependenciesMap.put((Object)mandatoryATName, (Object)oc);
                    this.dependsOnMap.put((Object)oc, (Object)mandatoryATName);
                    continue;
                }
                this.dependenciesMap.put((Object)mandatoryAT, (Object)oc);
                this.dependsOnMap.put((Object)oc, (Object)mandatoryAT);
            }
            for (String optionalATName : optionalATNames) {
                AttributeTypeImpl optionalAT = Activator.getDefault().getSchemaHandler().getAttributeType(optionalATName);
                if (optionalAT == null) {
                    error = new NonExistingOptionalATError((SchemaObject)oc, optionalATName);
                    this.errorsList.add(error);
                    this.errorsMap.put((Object)oc, (Object)error);
                    this.dependenciesMap.put((Object)optionalATName, (Object)oc);
                    this.dependsOnMap.put((Object)oc, (Object)optionalATName);
                    continue;
                }
                this.dependenciesMap.put((Object)optionalAT, (Object)oc);
                this.dependsOnMap.put((Object)oc, (Object)optionalAT);
            }
        }
    }

    private void removeSchemaObject(SchemaObject element) {
        List dependsOn;
        List warnings;
        List errors = (List)this.errorsMap.get((Object)element);
        if (errors != null && errors.size() >= 1) {
            for (Object error : errors) {
                this.errorsList.remove(error);
            }
            this.errorsMap.remove((Object)element);
        }
        if ((warnings = (List)this.warningsMap.get((Object)element)) != null && warnings.size() >= 1) {
            for (Object warning : warnings) {
                this.warningsList.remove(warning);
            }
            this.warningsMap.remove((Object)element);
        }
        if ((dependsOn = (List)this.dependsOnMap.get((Object)element)) != null) {
            for (Object dep : dependsOn) {
                this.dependenciesMap.remove(dep, (Object)element);
            }
            this.dependsOnMap.remove((Object)element);
        }
    }

    private List<?> getSchemaElementList(String id) {
        List<?> ocList;
        ArrayList results = new ArrayList();
        List<?> atList = Activator.getDefault().getSchemaHandler().getAttributeTypeList(id);
        if (atList != null && atList.size() >= 1) {
            results.addAll(atList);
        }
        if ((ocList = Activator.getDefault().getSchemaHandler().getObjectClassList(id)) != null && ocList.size() >= 1) {
            results.addAll(ocList);
        }
        return results;
    }

    public List<SchemaError> getErrors() {
        return this.errorsList;
    }

    public List<SchemaWarning> getWarnings() {
        return this.warningsList;
    }

    public void addListener(SchemaCheckerListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(SchemaCheckerListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyListeners() {
        for (SchemaCheckerListener listener : this.listeners) {
            listener.schemaCheckerUpdated();
        }
    }

    public List<?> getErrors(SchemaObject so) {
        return (List)this.errorsMap.get((Object)so);
    }

    public boolean hasErrors(SchemaObject so) {
        List<?> errors = this.getErrors(so);
        if (errors == null) {
            return false;
        }
        return errors.size() > 0;
    }

    public List<?> getWarnings(SchemaObject so) {
        return (List)this.warningsMap.get((Object)so);
    }

    public boolean hasWarnings(SchemaObject so) {
        List<?> warnings = this.getWarnings(so);
        if (warnings == null) {
            return false;
        }
        return warnings.size() > 0;
    }

    public void checkDependencies(List<?> deps) {
        if (deps != null) {
            for (Object object : deps) {
                if (object instanceof AttributeTypeImpl) {
                    this.checkAttributeType((AttributeTypeImpl)((Object)object));
                    continue;
                }
                if (!(object instanceof ObjectClassImpl)) continue;
                this.checkObjectClass((ObjectClassImpl)((Object)object));
            }
        }
    }

    private List<Object> getAndDeleteDependencies(SchemaObject sc) {
        String[] aliases;
        List oidDependencies;
        ArrayList<Object> deps = new ArrayList<Object>();
        String oid = sc.getOid();
        if (oid != null && !"".equals(oid) && (oidDependencies = (List)this.dependenciesMap.get((Object)oid)) != null) {
            deps.addAll(oidDependencies);
            this.dependenciesMap.remove((Object)oid);
            for (Object oidDependency : oidDependencies) {
                this.dependsOnMap.remove(oidDependency, (Object)oid);
            }
        }
        if ((aliases = sc.getNamesRef()) != null && aliases.length > 0) {
            for (String alias : aliases) {
                List aliasDependencies = (List)this.dependenciesMap.get((Object)alias);
                if (aliasDependencies == null) continue;
                deps.addAll(aliasDependencies);
                this.dependenciesMap.remove((Object)alias);
                for (Object aliasDependency : aliasDependencies) {
                    this.dependsOnMap.remove(aliasDependency, (Object)alias);
                }
            }
        }
        return deps;
    }
}

