/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.model.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.directory.shared.ldap.schema.ObjectClassTypeEnum;
import org.apache.directory.shared.ldap.schema.UsageEnum;
import org.apache.directory.studio.schemaeditor.model.AttributeTypeImpl;
import org.apache.directory.studio.schemaeditor.model.MatchingRuleImpl;
import org.apache.directory.studio.schemaeditor.model.ObjectClassImpl;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.model.SyntaxImpl;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class XMLSchemaFileExporter {
    private static final String ALIAS_TAG = "alias";
    private static final String ALIASES_TAG = "aliases";
    private static final String ATTRIBUTE_TYPE_TAG = "attributetype";
    private static final String ATTRIBUTE_TYPES_TAG = "attributetypes";
    private static final String BOOLEAN_FALSE = "false";
    private static final String BOOLEAN_TRUE = "true";
    private static final String COLLECTIVE_TAG = "collective";
    private static final String DESCRIPTION_TAG = "description";
    private static final String EQUALITY_TAG = "equality";
    private static final String HUMAN_READABLE_TAG = "humanreadable";
    private static final String MANDATORY_TAG = "mandatory";
    private static final String MATCHING_RULE_TAG = "matchingrule";
    private static final String MATCHING_RULES_TAG = "matchingrules";
    private static final String NAME_TAG = "name";
    private static final String NO_USER_MODIFICATION_TAG = "nousermodification";
    private static final String OBJECT_CLASS_TAG = "objectclass";
    private static final String OBJECT_CLASSES_TAG = "objectclasses";
    private static final String OBSOLETE_TAG = "obsolete";
    private static final String OID_TAG = "oid";
    private static final String OPTIONAL_TAG = "optional";
    private static final String ORDERING_TAG = "ordering";
    private static final String SCHEMA_TAG = "schema";
    private static final String SCHEMAS_TAG = "schemas";
    private static final String SINGLE_VALUE_TAG = "singlevalue";
    private static final String SUBSTRING_TAG = "substring";
    private static final String SUPERIOR_TAG = "superior";
    private static final String SUPERIORS_TAG = "superiors";
    private static final String SYNTAX_LENGTH_TAG = "syntaxlength";
    private static final String SYNTAX_OID_TAG = "syntaxoid";
    private static final String SYNTAX_TAG = "syntax";
    private static final String SYNTAXES_TAG = "syntaxes";
    private static final String TYPE_TAG = "type";
    private static final String USAGE_TAG = "usage";

    public static String toXml(Schema schema) throws IOException {
        Document document = DocumentHelper.createDocument();
        XMLSchemaFileExporter.addSchema(schema, (Branch)document);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        OutputFormat outformat = OutputFormat.createPrettyPrint();
        outformat.setEncoding("UTF-8");
        XMLWriter writer = new XMLWriter((OutputStream)os, outformat);
        writer.write(document);
        writer.flush();
        writer.close();
        return ((Object)os).toString();
    }

    public static String toXml(Schema[] schemas) throws IOException {
        Document document = DocumentHelper.createDocument();
        XMLSchemaFileExporter.addSchemas(schemas, (Branch)document);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        OutputFormat outformat = OutputFormat.createPrettyPrint();
        outformat.setEncoding("UTF-8");
        XMLWriter writer = new XMLWriter((OutputStream)os, outformat);
        writer.write(document);
        writer.flush();
        writer.close();
        return ((Object)os).toString();
    }

    public static void addSchemas(Schema[] schemas, Branch branch) {
        Element element = branch.addElement(SCHEMAS_TAG);
        if (schemas != null) {
            for (Schema schema : schemas) {
                XMLSchemaFileExporter.addSchema(schema, (Branch)element);
            }
        }
    }

    public static void addSchema(Schema schema, Branch branch) {
        Element element = branch.addElement(SCHEMA_TAG);
        if (schema != null) {
            List<SyntaxImpl> syntaxes;
            List<MatchingRuleImpl> mrs;
            List<ObjectClassImpl> ocs;
            List<AttributeTypeImpl> ats;
            String name = schema.getName();
            if (name != null && !name.equals("")) {
                element.addAttribute(NAME_TAG, name);
            }
            if ((ats = schema.getAttributeTypes()) != null && ats.size() >= 1) {
                Element attributeTypesNode = element.addElement(ATTRIBUTE_TYPES_TAG);
                for (AttributeTypeImpl at : ats) {
                    XMLSchemaFileExporter.toXml(at, attributeTypesNode);
                }
            }
            if ((ocs = schema.getObjectClasses()) != null && ocs.size() >= 1) {
                Element objectClassesNode = element.addElement(OBJECT_CLASSES_TAG);
                for (ObjectClassImpl oc : ocs) {
                    XMLSchemaFileExporter.toXml(oc, objectClassesNode);
                }
            }
            if ((mrs = schema.getMatchingRules()) != null && mrs.size() >= 1) {
                Element matchingRulesNode = element.addElement(MATCHING_RULES_TAG);
                for (MatchingRuleImpl mr : mrs) {
                    XMLSchemaFileExporter.toXml(mr, matchingRulesNode);
                }
            }
            if ((syntaxes = schema.getSyntaxes()) != null && syntaxes.size() >= 1) {
                Element syntaxesNode = element.addElement(SYNTAXES_TAG);
                for (SyntaxImpl syntax : syntaxes) {
                    XMLSchemaFileExporter.toXml(syntax, syntaxesNode);
                }
            }
        }
    }

    private static void toXml(AttributeTypeImpl at, Element root) {
        String substring;
        String ordering;
        int syntaxLength;
        String syntax;
        UsageEnum usage;
        String superior;
        String description;
        String[] aliases;
        Element atNode = root.addElement(ATTRIBUTE_TYPE_TAG);
        String oid = at.getOid();
        if (oid != null && !oid.equals("")) {
            atNode.addAttribute(OID_TAG, oid);
        }
        if ((aliases = at.getNamesRef()) != null && aliases.length >= 1) {
            Element aliasesNode = atNode.addElement(ALIASES_TAG);
            for (String alias : aliases) {
                aliasesNode.addElement(ALIAS_TAG).setText(alias);
            }
        }
        if ((description = at.getDescription()) != null && !description.equals("")) {
            atNode.addElement(DESCRIPTION_TAG).setText(description);
        }
        if ((superior = at.getSuperiorName()) != null && !superior.equals("")) {
            atNode.addElement(SUPERIOR_TAG).setText(superior);
        }
        if ((usage = at.getUsage()) != null) {
            atNode.addElement(USAGE_TAG).setText(usage.toString());
        }
        if ((syntax = at.getSyntaxOid()) != null && !syntax.equals("")) {
            atNode.addElement(SYNTAX_TAG).setText(syntax);
        }
        if ((syntaxLength = at.getLength()) > 0) {
            atNode.addElement(SYNTAX_LENGTH_TAG).setText("" + syntaxLength);
        }
        if (at.isObsolete()) {
            atNode.addAttribute(OBSOLETE_TAG, BOOLEAN_TRUE);
        } else {
            atNode.addAttribute(OBSOLETE_TAG, BOOLEAN_FALSE);
        }
        if (at.isSingleValue()) {
            atNode.addAttribute(SINGLE_VALUE_TAG, BOOLEAN_TRUE);
        } else {
            atNode.addAttribute(SINGLE_VALUE_TAG, BOOLEAN_FALSE);
        }
        if (at.isCollective()) {
            atNode.addAttribute(COLLECTIVE_TAG, BOOLEAN_TRUE);
        } else {
            atNode.addAttribute(COLLECTIVE_TAG, BOOLEAN_FALSE);
        }
        if (at.isCanUserModify()) {
            atNode.addAttribute(NO_USER_MODIFICATION_TAG, BOOLEAN_FALSE);
        } else {
            atNode.addAttribute(NO_USER_MODIFICATION_TAG, BOOLEAN_TRUE);
        }
        String equality = at.getEqualityName();
        if (equality != null && !equality.equals("")) {
            atNode.addElement(EQUALITY_TAG).setText(equality);
        }
        if ((ordering = at.getOrderingName()) != null && !ordering.equals("")) {
            atNode.addElement(ORDERING_TAG).setText(ordering);
        }
        if ((substring = at.getSubstrName()) != null && !substring.equals("")) {
            atNode.addElement(SUBSTRING_TAG).setText(substring);
        }
    }

    private static void toXml(ObjectClassImpl oc, Element root) {
        String[] optionalATs;
        ObjectClassTypeEnum type;
        String[] superiors;
        String description;
        String[] aliases;
        Element ocNode = root.addElement(OBJECT_CLASS_TAG);
        String oid = oc.getOid();
        if (oid != null && !oid.equals("")) {
            ocNode.addAttribute(OID_TAG, oid);
        }
        if ((aliases = oc.getNamesRef()) != null && aliases.length >= 1) {
            Element aliasesNode = ocNode.addElement(ALIASES_TAG);
            for (String alias : aliases) {
                aliasesNode.addElement(ALIAS_TAG).setText(alias);
            }
        }
        if ((description = oc.getDescription()) != null && !description.equals("")) {
            ocNode.addElement(DESCRIPTION_TAG).setText(description);
        }
        if ((superiors = oc.getSuperClassesNames()) != null && superiors.length >= 1) {
            Element superiorsNode = ocNode.addElement(SUPERIORS_TAG);
            for (String superior : superiors) {
                superiorsNode.addElement(SUPERIOR_TAG).setText(superior);
            }
        }
        if ((type = oc.getType()) != null) {
            ocNode.addElement(TYPE_TAG).setText(type.toString());
        }
        if (oc.isObsolete()) {
            ocNode.addAttribute(OBSOLETE_TAG, BOOLEAN_TRUE);
        } else {
            ocNode.addAttribute(OBSOLETE_TAG, BOOLEAN_FALSE);
        }
        String[] mandatoryATs = oc.getMustNamesList();
        if (mandatoryATs != null && mandatoryATs.length >= 1) {
            Element mandatoryNode = ocNode.addElement(MANDATORY_TAG);
            for (String mandatoryAT : mandatoryATs) {
                mandatoryNode.addElement(ATTRIBUTE_TYPE_TAG).setText(mandatoryAT);
            }
        }
        if ((optionalATs = oc.getMayNamesList()) != null && optionalATs.length >= 1) {
            Element optionalNode = ocNode.addElement(OPTIONAL_TAG);
            for (String optionalAT : optionalATs) {
                optionalNode.addElement(ATTRIBUTE_TYPE_TAG).setText(optionalAT);
            }
        }
    }

    private static void toXml(MatchingRuleImpl mr, Element root) {
        String description;
        String[] aliases;
        Element mrNode = root.addElement(MATCHING_RULE_TAG);
        String oid = mr.getOid();
        if (oid != null && !oid.equals("")) {
            mrNode.addAttribute(OID_TAG, oid);
        }
        if ((aliases = mr.getNamesRef()) != null && aliases.length >= 1) {
            Element aliasesNode = mrNode.addElement(ALIASES_TAG);
            for (String alias : aliases) {
                aliasesNode.addElement(ALIAS_TAG).setText(alias);
            }
        }
        if ((description = mr.getDescription()) != null && !description.equals("")) {
            mrNode.addElement(DESCRIPTION_TAG).setText(description);
        }
        if (mr.isObsolete()) {
            mrNode.addAttribute(OBSOLETE_TAG, BOOLEAN_TRUE);
        } else {
            mrNode.addAttribute(OBSOLETE_TAG, BOOLEAN_FALSE);
        }
        String syntaxOid = mr.getSyntaxOid();
        if (syntaxOid != null && !syntaxOid.equals("")) {
            mrNode.addElement(SYNTAX_OID_TAG).setText(syntaxOid);
        }
    }

    private static void toXml(SyntaxImpl syntax, Element root) {
        String description;
        String[] aliases;
        Element syntaxNode = root.addElement(SYNTAX_TAG);
        String oid = syntax.getOid();
        if (oid != null && !oid.equals("")) {
            syntaxNode.addAttribute(OID_TAG, oid);
        }
        if ((aliases = syntax.getNamesRef()) != null && aliases.length >= 1) {
            Element aliasesNode = syntaxNode.addElement(ALIASES_TAG);
            for (String alias : aliases) {
                aliasesNode.addElement(ALIAS_TAG).setText(alias);
            }
        }
        if ((description = syntax.getDescription()) != null && !description.equals("")) {
            syntaxNode.addElement(DESCRIPTION_TAG).setText(description);
        }
        if (syntax.isObsolete()) {
            syntaxNode.addAttribute(OBSOLETE_TAG, BOOLEAN_TRUE);
        } else {
            syntaxNode.addAttribute(OBSOLETE_TAG, BOOLEAN_FALSE);
        }
        if (syntax.isHumanReadable()) {
            syntaxNode.addAttribute(HUMAN_READABLE_TAG, BOOLEAN_TRUE);
        } else {
            syntaxNode.addAttribute(HUMAN_READABLE_TAG, BOOLEAN_FALSE);
        }
    }
}

