/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.model.io;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.List;
import java.util.Scanner;
import java.util.regex.MatchResult;
import org.apache.directory.shared.ldap.schema.parsers.AttributeTypeLiteral;
import org.apache.directory.shared.ldap.schema.parsers.ObjectClassLiteral;
import org.apache.directory.shared.ldap.schema.parsers.OpenLdapSchemaParser;
import org.apache.directory.studio.schemaeditor.model.AttributeTypeImpl;
import org.apache.directory.studio.schemaeditor.model.ObjectClassImpl;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.model.SchemaImpl;
import org.apache.directory.studio.schemaeditor.model.io.Messages;
import org.apache.directory.studio.schemaeditor.model.io.OpenLdapSchemaFileImportException;
import org.eclipse.osgi.util.NLS;

public class OpenLdapSchemaFileImporter {
    public static Schema getSchema(InputStream inputStream, String path) throws OpenLdapSchemaFileImportException {
        OpenLdapSchemaParser parser = null;
        try {
            parser = new OpenLdapSchemaParser();
        }
        catch (IOException e) {
            throw new OpenLdapSchemaFileImportException(NLS.bind((String)Messages.getString("OpenLdapSchemaFileImporter.NotReadCorrectly"), (Object[])new String[]{path}), e);
        }
        try {
            parser.parse(inputStream);
        }
        catch (IOException e) {
            throw new OpenLdapSchemaFileImportException(NLS.bind((String)Messages.getString("OpenLdapSchemaFileImporter.NotReadCorrectly"), (Object[])new String[]{path}), e);
        }
        catch (ParseException e) {
            ExceptionMessage exceptionMessage = OpenLdapSchemaFileImporter.parseExceptionMessage(e.getMessage());
            throw new OpenLdapSchemaFileImportException(NLS.bind((String)Messages.getString("OpenLdapSchemaFileImporter.NotReadCorrectly"), (Object[])new String[]{path}) + (exceptionMessage == null ? "" : NLS.bind((String)Messages.getString("OpenLdapSchemaFileImporter.ErrorMessage"), (Object[])new String[]{exceptionMessage.lineNumber, exceptionMessage.columnNumber, exceptionMessage.cause})), e);
        }
        String schemaName = OpenLdapSchemaFileImporter.getNameFromPath(path);
        SchemaImpl schema = new SchemaImpl(schemaName);
        List ats = parser.getAttributeTypes();
        for (int i = 0; i < ats.size(); ++i) {
            AttributeTypeImpl at = OpenLdapSchemaFileImporter.convertAttributeType((AttributeTypeLiteral)ats.get(i));
            at.setSchema(schemaName);
            at.setSchemaObject(schema);
            schema.addAttributeType(at);
        }
        List ocs = parser.getObjectClassTypes();
        for (int i = 0; i < ocs.size(); ++i) {
            ObjectClassImpl oc = OpenLdapSchemaFileImporter.convertObjectClass((ObjectClassLiteral)ocs.get(i));
            oc.setSchema(schemaName);
            oc.setSchemaObject(schema);
            schema.addObjectClass(oc);
        }
        return schema;
    }

    private static final String getNameFromPath(String path) {
        File file = new File(path);
        String fileName = file.getName();
        if (fileName.endsWith(".schema")) {
            String[] fileNameSplitted = fileName.split("\\.");
            return fileNameSplitted[0];
        }
        return fileName;
    }

    private static final AttributeTypeImpl convertAttributeType(AttributeTypeLiteral at) {
        AttributeTypeImpl newAT = new AttributeTypeImpl(at.getOid());
        newAT.setNames(at.getNames());
        newAT.setDescription(at.getDescription());
        newAT.setSuperiorName(at.getSuperior());
        newAT.setUsage(at.getUsage());
        newAT.setSyntaxOid(at.getSyntax());
        newAT.setLength(at.getLength());
        newAT.setObsolete(at.isObsolete());
        newAT.setSingleValue(at.isSingleValue());
        newAT.setCollective(at.isCollective());
        newAT.setCanUserModify(!at.isNoUserModification());
        newAT.setEqualityName(at.getEquality());
        newAT.setOrderingName(at.getOrdering());
        newAT.setSubstrName(at.getSubstr());
        return newAT;
    }

    private static final ObjectClassImpl convertObjectClass(ObjectClassLiteral oc) {
        ObjectClassImpl newOC = new ObjectClassImpl(oc.getOid());
        newOC.setNames(oc.getNames());
        newOC.setDescription(oc.getDescription());
        newOC.setSuperClassesNames(oc.getSuperiors());
        newOC.setType(oc.getClassType());
        newOC.setObsolete(oc.isObsolete());
        newOC.setMustNamesList(oc.getMust());
        newOC.setMayNamesList(oc.getMay());
        return newOC;
    }

    private static ExceptionMessage parseExceptionMessage(String message) {
        MatchResult result;
        Scanner scanner = new Scanner(new ByteArrayInputStream(message.getBytes()));
        String foundString = scanner.findWithinHorizon(".*line (\\d+):(\\d+): *([^\\n]*).*", message.length());
        if (foundString != null && (result = scanner.match()).groupCount() == 3) {
            ExceptionMessage exceptionMessage = new ExceptionMessage();
            exceptionMessage.lineNumber = result.group(1);
            exceptionMessage.columnNumber = result.group(2);
            exceptionMessage.cause = result.group(3);
            scanner.close();
            return exceptionMessage;
        }
        scanner.close();
        return null;
    }

    private static class ExceptionMessage {
        String lineNumber;
        String columnNumber;
        String cause;

        private ExceptionMessage() {
        }
    }
}

