/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.model.io;

import org.apache.directory.shared.ldap.schema.ObjectClassTypeEnum;
import org.apache.directory.shared.ldap.schema.UsageEnum;
import org.apache.directory.studio.schemaeditor.model.AttributeTypeImpl;
import org.apache.directory.studio.schemaeditor.model.ObjectClassImpl;
import org.apache.directory.studio.schemaeditor.model.Schema;

public class OpenLdapSchemaFileExporter {
    public static String toSourceCode(Schema schema) {
        StringBuffer sb = new StringBuffer();
        for (AttributeTypeImpl at : schema.getAttributeTypes()) {
            sb.append(OpenLdapSchemaFileExporter.toSourceCode(at));
            sb.append("\n");
        }
        for (ObjectClassImpl oc : schema.getObjectClasses()) {
            sb.append(OpenLdapSchemaFileExporter.toSourceCode(oc));
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String toSourceCode(AttributeTypeImpl at) {
        UsageEnum usage;
        StringBuffer sb = new StringBuffer();
        sb.append("attributetype ( " + at.getOid() + " \n");
        String[] names = at.getNamesRef();
        if (names != null && names.length > 0) {
            sb.append("\tNAME ");
            if (names.length > 1) {
                sb.append("( ");
                for (String name : names) {
                    sb.append("'" + name + "' ");
                }
                sb.append(") \n");
            } else {
                sb.append("'" + names[0] + "' \n");
            }
        }
        if (at.getDescription() != null && !at.getDescription().equals("")) {
            sb.append("\tDESC '" + at.getDescription() + "' \n");
        }
        if (at.isObsolete()) {
            sb.append("\tOBSOLETE \n");
        }
        if (at.getSuperiorName() != null && !at.getSuperiorName().equals("")) {
            sb.append("\tSUP " + at.getSuperiorName() + " \n");
        }
        if (at.getEqualityName() != null && !at.getEqualityName().equals("")) {
            sb.append("\tEQUALITY " + at.getEqualityName() + " \n");
        }
        if (at.getOrderingName() != null && !at.getOrderingName().equals("")) {
            sb.append("\tORDERING " + at.getOrderingName() + " \n");
        }
        if (at.getSubstrName() != null && !at.getSubstrName().equals("")) {
            sb.append("\tSUBSTR " + at.getSubstrName() + " \n");
        }
        if (at.getSyntaxOid() != null && !at.getSyntaxOid().equals("")) {
            sb.append("\tSYNTAX " + at.getSyntaxOid());
            if (at.getLength() > 0) {
                sb.append("{" + at.getLength() + "}");
            }
            sb.append(" \n");
        }
        if (at.isSingleValue()) {
            sb.append("\tSINGLE-VALUE \n");
        }
        if (at.isCollective()) {
            sb.append("\tCOLLECTIVE \n");
        }
        if (!at.isCanUserModify()) {
            sb.append("\tNO-USER-MODIFICATION \n");
        }
        if ((usage = at.getUsage()) != null) {
            if (usage == UsageEnum.DIRECTORY_OPERATION) {
                sb.append("\tUSAGE directoryOperation \n");
            } else if (usage == UsageEnum.DISTRIBUTED_OPERATION) {
                sb.append("\tUSAGE distributedOperation \n");
            } else if (usage == UsageEnum.DSA_OPERATION) {
                sb.append("\tUSAGE dSAOperation \n");
            } else if (usage == UsageEnum.USER_APPLICATIONS) {
                // empty if block
            }
        }
        sb.append(" )\n");
        return sb.toString();
    }

    public static String toSourceCode(ObjectClassImpl oc) {
        String[] may;
        ObjectClassTypeEnum classtype;
        String[] superiors;
        StringBuffer sb = new StringBuffer();
        sb.append("objectclass ( " + oc.getOid() + " \n");
        String[] names = oc.getNamesRef();
        if (names != null && names.length > 0) {
            sb.append("\tNAME ");
            if (names.length > 1) {
                sb.append("( ");
                for (String name : names) {
                    sb.append("'" + name + "' ");
                }
                sb.append(") \n");
            } else {
                sb.append("'" + names[0] + "' \n");
            }
        }
        if (oc.getDescription() != null && !oc.getDescription().equals("")) {
            sb.append("\tDESC '" + oc.getDescription() + "' \n");
        }
        if (oc.isObsolete()) {
            sb.append("\tOBSOLETE \n");
        }
        if ((superiors = oc.getSuperClassesNames()) != null && superiors.length != 0) {
            if (superiors.length > 1) {
                sb.append("\tSUP (" + superiors[0]);
                for (int i = 1; i < superiors.length; ++i) {
                    sb.append(" $ " + superiors[i]);
                }
                sb.append(") \n");
            } else {
                sb.append("\tSUP " + superiors[0] + " \n");
            }
        }
        if ((classtype = oc.getType()) == ObjectClassTypeEnum.ABSTRACT) {
            sb.append("\tABSTRACT \n");
        } else if (classtype == ObjectClassTypeEnum.AUXILIARY) {
            sb.append("\tAUXILIARY \n");
        } else if (classtype == ObjectClassTypeEnum.STRUCTURAL) {
            sb.append("\tSTRUCTURAL \n");
        }
        String[] must = oc.getMustNamesList();
        if (must != null && must.length != 0) {
            sb.append("\tMUST ");
            if (must.length > 1) {
                sb.append("( " + must[0] + " ");
                for (int i = 1; i < must.length; ++i) {
                    sb.append("$ " + must[i] + " ");
                }
                sb.append(") \n");
            } else if (must.length == 1) {
                sb.append(must[0] + " \n");
            }
        }
        if ((may = oc.getMayNamesList()) != null && may.length != 0) {
            sb.append("\tMAY ");
            if (may.length > 1) {
                sb.append("( " + may[0] + " ");
                for (int i = 1; i < may.length; ++i) {
                    sb.append("$ " + may[i] + " ");
                }
                sb.append(") \n");
            } else if (may.length == 1) {
                sb.append(may[0] + " \n");
            }
        }
        sb.append(" )\n");
        return sb.toString();
    }
}

