/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.model.io;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.directory.shared.ldap.schema.parsers.AttributeTypeDescription;
import org.apache.directory.shared.ldap.schema.parsers.AttributeTypeDescriptionSchemaParser;
import org.apache.directory.shared.ldap.schema.parsers.LdapSyntaxDescription;
import org.apache.directory.shared.ldap.schema.parsers.LdapSyntaxDescriptionSchemaParser;
import org.apache.directory.shared.ldap.schema.parsers.MatchingRuleDescription;
import org.apache.directory.shared.ldap.schema.parsers.MatchingRuleDescriptionSchemaParser;
import org.apache.directory.shared.ldap.schema.parsers.ObjectClassDescription;
import org.apache.directory.shared.ldap.schema.parsers.ObjectClassDescriptionSchemaParser;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.Utils;
import org.apache.directory.studio.connection.core.io.jndi.JNDIConnectionWrapper;
import org.apache.directory.studio.connection.core.io.jndi.StudioNamingEnumeration;
import org.apache.directory.studio.connection.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.schemaeditor.model.AttributeTypeImpl;
import org.apache.directory.studio.schemaeditor.model.MatchingRuleImpl;
import org.apache.directory.studio.schemaeditor.model.ObjectClassImpl;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.model.SchemaImpl;
import org.apache.directory.studio.schemaeditor.model.SyntaxImpl;
import org.apache.directory.studio.schemaeditor.model.io.AbstractSchemaConnector;
import org.apache.directory.studio.schemaeditor.model.io.Messages;
import org.apache.directory.studio.schemaeditor.model.io.SchemaConnector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericSchemaConnector
extends AbstractSchemaConnector
implements SchemaConnector {
    private static final Connection.AliasDereferencingMethod DEREF_ALIAS_METHOD = Connection.AliasDereferencingMethod.ALWAYS;
    private static final Connection.ReferralHandlingMethod HANDLE_REFERALS_METHOD = Connection.ReferralHandlingMethod.FOLLOW;

    @Override
    public void exportSchema(Connection connection, StudioProgressMonitor monitor) {
    }

    @Override
    public List<Schema> importSchema(Connection connection, StudioProgressMonitor monitor) {
        ArrayList<Schema> schemas = new ArrayList<Schema>();
        JNDIConnectionWrapper wrapper = connection.getJNDIConnectionWrapper();
        monitor.beginTask(Messages.getString("GenericSchemaConnector.FetchingSchema"), 1);
        SearchControls constraintSearch = new SearchControls();
        constraintSearch.setSearchScope(0);
        constraintSearch.setReturningAttributes(new String[]{"attributeTypes", "objectClasses", "ldapSyntaxes", "matchingRules"});
        String schemaDn = GenericSchemaConnector.getSubschemaSubentry(connection, monitor);
        StudioNamingEnumeration answer = wrapper.search(schemaDn, "(objectclass=subschema)", constraintSearch, DEREF_ALIAS_METHOD, HANDLE_REFERALS_METHOD, null, monitor, null);
        if (answer != null) {
            block4: while (true) {
                try {
                    while (answer.hasMore()) {
                        SearchResult searchResult = (SearchResult)answer.next();
                        try {
                            schemas.add(GenericSchemaConnector.getSchema(wrapper, searchResult, monitor));
                            continue block4;
                        }
                        catch (Exception e) {
                            monitor.reportError(e);
                        }
                    }
                    break;
                }
                catch (NamingException e) {
                    monitor.reportError((Exception)e);
                    break;
                }
            }
        }
        monitor.worked(1);
        return schemas;
    }

    @Override
    public boolean isSuitableConnector(Connection connection, StudioProgressMonitor monitor) {
        return GenericSchemaConnector.getSubschemaSubentry(connection, monitor) != null;
    }

    private static String getSubschemaSubentry(Connection connection, StudioProgressMonitor monitor) {
        block7: {
            JNDIConnectionWrapper wrapper = connection.getJNDIConnectionWrapper();
            SearchControls constraintSearch = new SearchControls();
            constraintSearch.setSearchScope(0);
            constraintSearch.setReturningAttributes(new String[]{"subschemaSubentry"});
            StudioNamingEnumeration answer = wrapper.search("", "(objectclass=*)", constraintSearch, DEREF_ALIAS_METHOD, HANDLE_REFERALS_METHOD, null, monitor, null);
            if (answer != null) {
                try {
                    if (!answer.hasMore()) break block7;
                    SearchResult searchResult = (SearchResult)answer.next();
                    Attribute subschemaSubentryAttribute = searchResult.getAttributes().get("subschemaSubentry");
                    if (subschemaSubentryAttribute == null) {
                        return null;
                    }
                    if (subschemaSubentryAttribute.size() != 1) {
                        return null;
                    }
                    String subschemaSubentry = null;
                    try {
                        subschemaSubentry = (String)subschemaSubentryAttribute.get();
                    }
                    catch (NamingException e) {
                        return null;
                    }
                    return subschemaSubentry;
                }
                catch (NamingException e) {
                    monitor.reportError((Exception)e);
                }
            }
        }
        return null;
    }

    private static Schema getSchema(JNDIConnectionWrapper wrapper, SearchResult searchResult, StudioProgressMonitor monitor) throws NamingException, ParseException {
        NamingEnumeration<?> ne;
        NamingEnumeration<?> ne2;
        Attribute ldapSyntaxesAttribute;
        Object impl;
        NamingEnumeration<?> ne3;
        Attribute objectClassesAttribute;
        NamingEnumeration<?> ne4;
        SchemaImpl schema = new SchemaImpl("schema");
        Attribute attributeTypesAttribute = searchResult.getAttributes().get("attributeTypes");
        if (attributeTypesAttribute != null && (ne4 = attributeTypesAttribute.getAll()) != null) {
            while (ne4.hasMoreElements()) {
                String value = (String)ne4.nextElement();
                AttributeTypeDescriptionSchemaParser parser = new AttributeTypeDescriptionSchemaParser();
                parser.setQuirksMode(true);
                AttributeTypeDescription atd = parser.parseAttributeTypeDescription(value);
                AttributeTypeImpl impl2 = new AttributeTypeImpl(atd.getNumericOid());
                impl2.setOid(atd.getNumericOid());
                impl2.setNames(atd.getNames().toArray(new String[0]));
                impl2.setDescription(atd.getDescription());
                impl2.setSuperiorName(atd.getSuperType());
                impl2.setUsage(atd.getUsage());
                impl2.setSyntaxOid(atd.getSyntax());
                impl2.setLength(atd.getSyntaxLength());
                impl2.setObsolete(atd.isObsolete());
                impl2.setCollective(atd.isCollective());
                impl2.setSingleValue(atd.isSingleValued());
                impl2.setCanUserModify(atd.isUserModifiable());
                impl2.setEqualityName(atd.getEqualityMatchingRule());
                impl2.setOrderingName(atd.getOrderingMatchingRule());
                impl2.setSubstrName(atd.getSubstringsMatchingRule());
                impl2.setSchema(schema.getName());
                impl2.setSchemaObject(schema);
                if (impl2.getSyntaxOid() != null && "OctetString".equalsIgnoreCase(impl2.getSyntaxOid())) {
                    impl2.setSyntaxOid("1.3.6.1.4.1.1466.115.121.1.40");
                }
                schema.addAttributeType(impl2);
            }
        }
        if ((objectClassesAttribute = searchResult.getAttributes().get("objectClasses")) != null && (ne3 = objectClassesAttribute.getAll()) != null) {
            while (ne3.hasMoreElements()) {
                String value = (String)ne3.nextElement();
                ObjectClassDescriptionSchemaParser parser = new ObjectClassDescriptionSchemaParser();
                parser.setQuirksMode(true);
                ObjectClassDescription ocd = parser.parseObjectClassDescription(value);
                impl = new ObjectClassImpl(ocd.getNumericOid());
                ((ObjectClassImpl)((Object)impl)).setOid(ocd.getNumericOid());
                ((ObjectClassImpl)((Object)impl)).setNames(ocd.getNames().toArray(new String[0]));
                ((ObjectClassImpl)((Object)impl)).setDescription(ocd.getDescription());
                ((ObjectClassImpl)((Object)impl)).setSuperClassesNames(ocd.getSuperiorObjectClasses().toArray(new String[0]));
                ((ObjectClassImpl)((Object)impl)).setType(ocd.getKind());
                ((ObjectClassImpl)((Object)impl)).setObsolete(ocd.isObsolete());
                ((ObjectClassImpl)((Object)impl)).setMustNamesList(ocd.getMustAttributeTypes().toArray(new String[0]));
                ((ObjectClassImpl)((Object)impl)).setMayNamesList(ocd.getMayAttributeTypes().toArray(new String[0]));
                impl.setSchema(schema.getName());
                ((ObjectClassImpl)((Object)impl)).setSchemaObject(schema);
                schema.addObjectClass((ObjectClassImpl)((Object)impl));
            }
        }
        if ((ldapSyntaxesAttribute = searchResult.getAttributes().get("ldapSyntaxes")) != null && (ne2 = ldapSyntaxesAttribute.getAll()) != null) {
            while (ne2.hasMoreElements()) {
                String value = (String)ne2.nextElement();
                LdapSyntaxDescriptionSchemaParser parser = new LdapSyntaxDescriptionSchemaParser();
                parser.setQuirksMode(true);
                LdapSyntaxDescription lsd = parser.parseLdapSyntaxDescription(value);
                SyntaxImpl impl3 = new SyntaxImpl(lsd.getNumericOid());
                impl3.setDescription(lsd.getDescription());
                impl3.setNames(new String[]{lsd.getDescription()});
                impl3.setHumanReadable(true);
                impl3.setSchema(schema.getName());
                impl3.setSchemaObject(schema);
                schema.addSyntax(impl3);
            }
        }
        for (AttributeTypeImpl at : schema.getAttributeTypes()) {
            String syntaxOid = at.getSyntaxOid();
            if (syntaxOid == null || schema.getSyntax(syntaxOid) != null) continue;
            impl = new SyntaxImpl(syntaxOid);
            impl.setSchema(schema.getName());
            ((SyntaxImpl)((Object)impl)).setSchemaObject(schema);
            String oidDescription = Utils.getOidDescription((String)syntaxOid);
            ((SyntaxImpl)((Object)impl)).setDescription(oidDescription != null ? oidDescription : "Dummy");
            ((SyntaxImpl)((Object)impl)).setNames(new String[]{impl.getDescription()});
            schema.addSyntax((SyntaxImpl)((Object)impl));
        }
        Attribute matchingRulesAttribute = searchResult.getAttributes().get("matchingRules");
        if (matchingRulesAttribute != null && (ne = matchingRulesAttribute.getAll()) != null) {
            while (ne.hasMoreElements()) {
                String value = (String)ne.nextElement();
                MatchingRuleDescriptionSchemaParser parser = new MatchingRuleDescriptionSchemaParser();
                parser.setQuirksMode(true);
                MatchingRuleDescription mrd = parser.parseMatchingRuleDescription(value);
                MatchingRuleImpl impl4 = new MatchingRuleImpl(mrd.getNumericOid());
                impl4.setDescription(mrd.getDescription());
                impl4.setNames(mrd.getNames().toArray(new String[0]));
                impl4.setObsolete(mrd.isObsolete());
                impl4.setSyntaxOid(mrd.getSyntax());
                impl4.setSchema(schema.getName());
                impl4.setSchemaObject(schema);
                schema.addMatchingRule(impl4);
            }
        }
        for (AttributeTypeImpl at : schema.getAttributeTypes()) {
            String equalityName = at.getEqualityName();
            String orderingName = at.getOrderingName();
            String substrName = at.getSubstrName();
            GenericSchemaConnector.checkMatchingRules(schema, equalityName, orderingName, substrName);
        }
        return schema;
    }

    private static void checkMatchingRules(Schema schema, String ... matchingRuleNames) {
        for (String matchingRuleName : matchingRuleNames) {
            if (matchingRuleName == null || schema.getMatchingRule(matchingRuleName) != null) continue;
            MatchingRuleImpl impl = new MatchingRuleImpl(matchingRuleName);
            impl.setSchema(schema.getName());
            impl.setSchemaObject(schema);
            impl.setDescription("Dummy");
            impl.setNames(new String[]{matchingRuleName});
            schema.addMatchingRule(impl);
        }
    }
}

