/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.model.io;

import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.directory.shared.ldap.schema.ObjectClassTypeEnum;
import org.apache.directory.shared.ldap.schema.UsageEnum;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.io.jndi.JNDIConnectionWrapper;
import org.apache.directory.studio.connection.core.io.jndi.StudioNamingEnumeration;
import org.apache.directory.studio.connection.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.schemaeditor.model.AttributeTypeImpl;
import org.apache.directory.studio.schemaeditor.model.MatchingRuleImpl;
import org.apache.directory.studio.schemaeditor.model.ObjectClassImpl;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.model.SchemaImpl;
import org.apache.directory.studio.schemaeditor.model.SyntaxImpl;
import org.apache.directory.studio.schemaeditor.model.io.AbstractSchemaConnector;
import org.apache.directory.studio.schemaeditor.model.io.Messages;
import org.apache.directory.studio.schemaeditor.model.io.SchemaConnector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApacheDsSchemaConnector
extends AbstractSchemaConnector
implements SchemaConnector {
    public static final String SCHEMA_DN = "ou=schema";
    private static final String META_ATTRIBUTE_TYPE = "metaAttributeType";
    private static final String META_OBJECT_CLASS = "metaObjectClass";
    private static final String META_MATCHING_RULE = "metaMatchingRule";
    private static final String META_SYNTAX = "metaSyntax";
    private static final Connection.AliasDereferencingMethod DEREF_ALIAS_METHOD = Connection.AliasDereferencingMethod.ALWAYS;
    private static final Connection.ReferralHandlingMethod HANDLE_REFERALS_METHOD = Connection.ReferralHandlingMethod.FOLLOW;

    @Override
    public void exportSchema(Connection connection, StudioProgressMonitor monitor) {
    }

    @Override
    public List<Schema> importSchema(Connection connection, StudioProgressMonitor monitor) {
        ArrayList<Schema> schemas = new ArrayList<Schema>();
        JNDIConnectionWrapper wrapper = connection.getJNDIConnectionWrapper();
        monitor.beginTask(Messages.getString("GenericSchemaConnector.FetchingSchema"), 1);
        SearchControls constraintSearch = new SearchControls();
        constraintSearch.setSearchScope(1);
        StudioNamingEnumeration answer = wrapper.search(SCHEMA_DN, "(objectclass=metaSchema)", constraintSearch, DEREF_ALIAS_METHOD, HANDLE_REFERALS_METHOD, null, monitor, null);
        if (answer != null) {
            try {
                while (answer.hasMore()) {
                    SearchResult searchResult = (SearchResult)answer.next();
                    Attribute cnAttribute = searchResult.getAttributes().get("cn");
                    NamingEnumeration<?> ne = null;
                    ne = cnAttribute.getAll();
                    if (ne == null) continue;
                    while (ne.hasMore()) {
                        String value = (String)ne.next();
                        schemas.add(ApacheDsSchemaConnector.getSchema(wrapper, value, monitor));
                    }
                }
            }
            catch (NamingException e) {
                monitor.reportError((Exception)e);
            }
        }
        monitor.worked(1);
        return schemas;
    }

    @Override
    public boolean isSuitableConnector(Connection connection, StudioProgressMonitor monitor) {
        block7: {
            JNDIConnectionWrapper wrapper = connection.getJNDIConnectionWrapper();
            SearchControls constraintSearch = new SearchControls();
            constraintSearch.setSearchScope(0);
            constraintSearch.setReturningAttributes(new String[]{"+"});
            StudioNamingEnumeration answer = wrapper.search("", "(objectclass=*)", constraintSearch, DEREF_ALIAS_METHOD, HANDLE_REFERALS_METHOD, null, monitor, null);
            if (answer != null) {
                try {
                    if (!answer.hasMore()) break block7;
                    SearchResult searchResult = (SearchResult)answer.next();
                    Attribute vendorNameAttribute = searchResult.getAttributes().get("vendorName");
                    if (vendorNameAttribute == null) {
                        return false;
                    }
                    if (vendorNameAttribute.size() != 1) {
                        return false;
                    }
                    String vendorName = null;
                    try {
                        vendorName = (String)vendorNameAttribute.get();
                    }
                    catch (NamingException e) {
                        return false;
                    }
                    return vendorName != null && vendorName.equalsIgnoreCase("Apache Software Foundation");
                }
                catch (NamingException e) {
                    monitor.reportError((Exception)e);
                }
            }
        }
        return false;
    }

    private static Schema getSchema(JNDIConnectionWrapper wrapper, String name, StudioProgressMonitor monitor) throws NamingException {
        monitor.subTask(name);
        SchemaImpl schema = new SchemaImpl(name);
        SearchControls constraintSearch = new SearchControls();
        constraintSearch.setSearchScope(2);
        StudioNamingEnumeration answer = wrapper.search("cn=" + name + ", ou=schema", "(objectclass=*)", constraintSearch, DEREF_ALIAS_METHOD, HANDLE_REFERALS_METHOD, null, monitor, null);
        if (answer != null) {
            try {
                while (answer.hasMore()) {
                    SearchResult searchResult = (SearchResult)answer.next();
                    switch (ApacheDsSchemaConnector.getNodeType(searchResult)) {
                        case ATTRIBUTE_TYPE: {
                            AttributeTypeImpl at = ApacheDsSchemaConnector.createAttributeType(searchResult);
                            at.setSchema(name);
                            at.setSchemaObject(schema);
                            schema.addAttributeType(at);
                            break;
                        }
                        case OBJECT_CLASS: {
                            ObjectClassImpl oc = ApacheDsSchemaConnector.createObjectClass(searchResult);
                            oc.setSchema(name);
                            oc.setSchemaObject(schema);
                            schema.addObjectClass(oc);
                            break;
                        }
                        case MATCHING_RULE: {
                            MatchingRuleImpl mr = ApacheDsSchemaConnector.createMatchingRule(searchResult);
                            mr.setSchema(name);
                            mr.setSchemaObject(schema);
                            schema.addMatchingRule(mr);
                            break;
                        }
                        case SYNTAX: {
                            SyntaxImpl syntax = ApacheDsSchemaConnector.createSyntax(searchResult);
                            syntax.setSchema(name);
                            syntax.setSchemaObject(schema);
                            schema.addSyntax(syntax);
                            break;
                        }
                    }
                }
            }
            catch (NamingException e) {
                monitor.reportError((Exception)e);
            }
        }
        return schema;
    }

    private static SchemaNodeTypes getNodeType(SearchResult sr) throws NamingException {
        Attribute objectClassAttribute = sr.getAttributes().get("objectClass");
        NamingEnumeration<?> ne = objectClassAttribute.getAll();
        while (ne.hasMore()) {
            String value = (String)ne.next();
            if (META_ATTRIBUTE_TYPE.equals(value)) {
                return SchemaNodeTypes.ATTRIBUTE_TYPE;
            }
            if (META_OBJECT_CLASS.equals(value)) {
                return SchemaNodeTypes.OBJECT_CLASS;
            }
            if (META_MATCHING_RULE.equals(value)) {
                return SchemaNodeTypes.MATCHING_RULE;
            }
            if (!META_SYNTAX.equals(value)) continue;
            return SchemaNodeTypes.SYNTAX;
        }
        return SchemaNodeTypes.UNKNOWN;
    }

    private static AttributeTypeImpl createAttributeType(SearchResult sr) throws NamingException {
        AttributeTypeImpl at = new AttributeTypeImpl(ApacheDsSchemaConnector.getOid(sr));
        at.setNames(ApacheDsSchemaConnector.getNames(sr));
        at.setDescription(ApacheDsSchemaConnector.getDescription(sr));
        at.setObsolete(ApacheDsSchemaConnector.isObsolete(sr));
        at.setSuperiorName(ApacheDsSchemaConnector.getSuperior(sr));
        at.setUsage(ApacheDsSchemaConnector.getUsage(sr));
        at.setSyntaxOid(ApacheDsSchemaConnector.getSyntax(sr));
        at.setLength(ApacheDsSchemaConnector.getSyntaxLength(sr));
        at.setCollective(ApacheDsSchemaConnector.isCollective(sr));
        at.setSingleValue(ApacheDsSchemaConnector.isSingleValue(sr));
        at.setCanUserModify(ApacheDsSchemaConnector.isCanUserModify(sr));
        at.setEqualityName(ApacheDsSchemaConnector.getEquality(sr));
        at.setOrderingName(ApacheDsSchemaConnector.getOrdering(sr));
        at.setSubstrName(ApacheDsSchemaConnector.getSubstr(sr));
        return at;
    }

    private static ObjectClassImpl createObjectClass(SearchResult sr) throws NamingException {
        ObjectClassImpl oc = new ObjectClassImpl(ApacheDsSchemaConnector.getOid(sr));
        oc.setNames(ApacheDsSchemaConnector.getNames(sr));
        oc.setDescription(ApacheDsSchemaConnector.getDescription(sr));
        oc.setObsolete(ApacheDsSchemaConnector.isObsolete(sr));
        oc.setSuperClassesNames(ApacheDsSchemaConnector.getSuperiors(sr));
        oc.setType(ApacheDsSchemaConnector.getType(sr));
        oc.setMayNamesList(ApacheDsSchemaConnector.getMay(sr));
        oc.setMustNamesList(ApacheDsSchemaConnector.getMust(sr));
        return oc;
    }

    private static MatchingRuleImpl createMatchingRule(SearchResult sr) throws NamingException {
        MatchingRuleImpl mr = new MatchingRuleImpl(ApacheDsSchemaConnector.getOid(sr));
        mr.setNames(ApacheDsSchemaConnector.getNames(sr));
        mr.setDescription(ApacheDsSchemaConnector.getDescription(sr));
        mr.setObsolete(ApacheDsSchemaConnector.isObsolete(sr));
        mr.setSyntaxOid(ApacheDsSchemaConnector.getSyntax(sr));
        return mr;
    }

    private static SyntaxImpl createSyntax(SearchResult sr) throws NamingException {
        SyntaxImpl syntax = new SyntaxImpl(ApacheDsSchemaConnector.getOid(sr));
        syntax.setNames(ApacheDsSchemaConnector.getNames(sr));
        syntax.setDescription(ApacheDsSchemaConnector.getDescription(sr));
        syntax.setObsolete(ApacheDsSchemaConnector.isObsolete(sr));
        syntax.setHumanReadable(ApacheDsSchemaConnector.isHumanReadable(sr));
        return syntax;
    }

    private static String getOid(SearchResult sr) throws NamingException {
        Attribute at = sr.getAttributes().get("m-oid");
        if (at == null) {
            return null;
        }
        return (String)at.get();
    }

    private static String[] getNames(SearchResult sr) throws NamingException {
        ArrayList<String> names = new ArrayList<String>();
        Attribute at = sr.getAttributes().get("m-name");
        if (at != null) {
            NamingEnumeration<?> ne = at.getAll();
            while (ne.hasMore()) {
                names.add((String)ne.next());
            }
        }
        return names.toArray(new String[0]);
    }

    private static String getDescription(SearchResult sr) throws NamingException {
        Attribute at = sr.getAttributes().get("m-description");
        if (at == null) {
            return null;
        }
        return (String)at.get();
    }

    private static String getSuperior(SearchResult sr) throws NamingException {
        Attribute at = sr.getAttributes().get("m-supAttributeType");
        if (at == null) {
            return null;
        }
        return (String)at.get();
    }

    private static UsageEnum getUsage(SearchResult sr) throws NamingException {
        Attribute at = sr.getAttributes().get("m-usage");
        if (at == null) {
            return UsageEnum.USER_APPLICATIONS;
        }
        try {
            return Enum.valueOf(UsageEnum.class, (String)at.get());
        }
        catch (IllegalArgumentException e) {
            return UsageEnum.USER_APPLICATIONS;
        }
        catch (NullPointerException e) {
            return UsageEnum.USER_APPLICATIONS;
        }
    }

    private static String getSyntax(SearchResult sr) throws NamingException {
        Attribute at = sr.getAttributes().get("m-syntax");
        if (at == null) {
            return null;
        }
        return (String)at.get();
    }

    private static int getSyntaxLength(SearchResult sr) throws NamingException {
        Attribute at = sr.getAttributes().get("m-length");
        if (at == null) {
            return -1;
        }
        try {
            return Integer.parseInt((String)at.get());
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private static boolean isObsolete(SearchResult sr) throws NamingException {
        Attribute at = sr.getAttributes().get("m-obsolete");
        if (at == null) {
            return false;
        }
        return Boolean.parseBoolean((String)at.get());
    }

    private static boolean isCollective(SearchResult sr) throws NamingException {
        Attribute at = sr.getAttributes().get("m-collective");
        if (at == null) {
            return false;
        }
        return Boolean.parseBoolean((String)at.get());
    }

    private static boolean isSingleValue(SearchResult sr) throws NamingException {
        Attribute at = sr.getAttributes().get("m-singleValue");
        if (at == null) {
            return false;
        }
        return Boolean.parseBoolean((String)at.get());
    }

    private static boolean isCanUserModify(SearchResult sr) throws NamingException {
        Attribute at = sr.getAttributes().get("m-noUserModification");
        if (at == null) {
            return true;
        }
        return !Boolean.parseBoolean((String)at.get());
    }

    private static String getEquality(SearchResult sr) throws NamingException {
        Attribute at = sr.getAttributes().get("m-equality");
        if (at == null) {
            return null;
        }
        return (String)at.get();
    }

    private static String getOrdering(SearchResult sr) throws NamingException {
        Attribute at = sr.getAttributes().get("m-ordering");
        if (at == null) {
            return null;
        }
        return (String)at.get();
    }

    private static String getSubstr(SearchResult sr) throws NamingException {
        Attribute at = sr.getAttributes().get("m-substr");
        if (at == null) {
            return null;
        }
        return (String)at.get();
    }

    private static String[] getSuperiors(SearchResult sr) throws NamingException {
        ArrayList<String> names = new ArrayList<String>();
        Attribute at = sr.getAttributes().get("m-supObjectClass");
        if (at != null) {
            NamingEnumeration<?> ne = at.getAll();
            while (ne.hasMore()) {
                names.add((String)ne.next());
            }
        }
        return names.toArray(new String[0]);
    }

    private static ObjectClassTypeEnum getType(SearchResult sr) throws NamingException {
        Attribute at = sr.getAttributes().get("m-typeObjectClass");
        if (at == null) {
            return ObjectClassTypeEnum.STRUCTURAL;
        }
        try {
            return Enum.valueOf(ObjectClassTypeEnum.class, (String)at.get());
        }
        catch (IllegalArgumentException e) {
            return ObjectClassTypeEnum.STRUCTURAL;
        }
        catch (NullPointerException e) {
            return ObjectClassTypeEnum.STRUCTURAL;
        }
    }

    private static String[] getMay(SearchResult sr) throws NamingException {
        ArrayList<String> names = new ArrayList<String>();
        Attribute at = sr.getAttributes().get("m-may");
        if (at != null) {
            NamingEnumeration<?> ne = at.getAll();
            while (ne.hasMore()) {
                names.add((String)ne.next());
            }
        }
        return names.toArray(new String[0]);
    }

    private static String[] getMust(SearchResult sr) throws NamingException {
        ArrayList<String> names = new ArrayList<String>();
        Attribute at = sr.getAttributes().get("m-must");
        if (at != null) {
            NamingEnumeration<?> ne = at.getAll();
            while (ne.hasMore()) {
                names.add((String)ne.next());
            }
        }
        return names.toArray(new String[0]);
    }

    private static boolean isHumanReadable(SearchResult sr) throws NamingException {
        Attribute at = sr.getAttributes().get("x-humanReadable");
        if (at == null) {
            return false;
        }
        return Boolean.parseBoolean((String)at.get());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SchemaNodeTypes {
        ATTRIBUTE_TYPE,
        OBJECT_CLASS,
        MATCHING_RULE,
        SYNTAX,
        UNKNOWN;

    }
}

