/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.model.hierarchy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchyWrapper {
    private Object wrappedObject;
    private Object parent;
    private List<HierarchyWrapper> children = new ArrayList<HierarchyWrapper>();

    public HierarchyWrapper(Object obj) {
        this.wrappedObject = obj;
        this.parent = null;
    }

    public HierarchyWrapper(Object obj, Object parent) {
        this.wrappedObject = obj;
        this.parent = parent;
    }

    public boolean addChild(HierarchyWrapper child) {
        return this.children.add(child);
    }

    public boolean addChildren(Collection<? extends HierarchyWrapper> children) {
        return this.children.addAll(children);
    }

    public boolean equalsWrappedObject(Object obj) {
        if (obj != null) {
            return obj.equals(this.wrappedObject);
        }
        return false;
    }

    public List<HierarchyWrapper> getChildren() {
        return this.children;
    }

    public Object getParent() {
        return this.parent;
    }

    public Object getWrappedObject() {
        return this.wrappedObject;
    }

    public boolean removeChild(HierarchyWrapper child) {
        return this.children.remove(child);
    }

    public boolean removeChildren(Collection<? extends HierarchyWrapper> children) {
        return this.children.removeAll(children);
    }

    public void setChildren(List<HierarchyWrapper> children) {
        this.children = children;
    }

    public void setParent(Object parent) {
        this.parent = parent;
    }

    public void setWrappedObject(Object wrappedObject) {
        this.wrappedObject = wrappedObject;
    }

    public String toString() {
        return "{|" + this.wrappedObject + "|" + this.children + "}";
    }
}

