/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.model.hierarchy;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.directory.shared.ldap.schema.SchemaObject;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandler;
import org.apache.directory.studio.schemaeditor.model.AttributeTypeImpl;
import org.apache.directory.studio.schemaeditor.model.ObjectClassImpl;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.model.hierarchy.RootObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchyManager {
    private MultiValueMap parentsMap = new MultiValueMap();
    private MultiValueMap childrenMap = new MultiValueMap();
    private SchemaHandler schemaHandler = Activator.getDefault().getSchemaHandler();
    private RootObject root;

    public HierarchyManager() {
        this.loadSchema();
    }

    private void addAttributeType(AttributeTypeImpl at) {
        this.checkAliasesAndOID((SchemaObject)at);
        String superiorName = at.getSuperiorName();
        if (superiorName != null) {
            AttributeTypeImpl superior = this.schemaHandler.getAttributeType(superiorName);
            if (superior != null) {
                this.parentsMap.put((Object)at, (Object)superior);
                this.childrenMap.put((Object)superior, (Object)at);
            } else {
                this.parentsMap.put((Object)at, (Object)superiorName.toLowerCase());
                this.childrenMap.put((Object)superiorName.toLowerCase(), (Object)at);
                this.childrenMap.put((Object)this.root, (Object)at);
            }
        } else {
            this.parentsMap.put((Object)at, (Object)this.root);
            this.childrenMap.put((Object)this.root, (Object)at);
        }
    }

    private void addObjectClass(ObjectClassImpl oc) {
        this.checkAliasesAndOID((SchemaObject)oc);
        String[] superClasseNames = oc.getSuperClassesNames();
        if (superClasseNames != null && superClasseNames.length > 0) {
            for (String superClassName : superClasseNames) {
                ObjectClassImpl superClass = this.schemaHandler.getObjectClass(superClassName);
                if (superClass == null) {
                    this.parentsMap.put((Object)oc, (Object)superClassName.toLowerCase());
                    this.childrenMap.put((Object)superClassName.toLowerCase(), (Object)oc);
                    this.childrenMap.put((Object)this.root, (Object)oc);
                    continue;
                }
                this.parentsMap.put((Object)oc, (Object)superClass);
                this.childrenMap.put((Object)superClass, (Object)oc);
            }
        } else {
            ObjectClassImpl topOC = this.schemaHandler.getObjectClass("2.5.6.0");
            if (oc.equals((Object)topOC)) {
                this.parentsMap.put((Object)oc, (Object)this.root);
                this.childrenMap.put((Object)this.root, (Object)oc);
            } else if (topOC != null) {
                this.parentsMap.put((Object)oc, (Object)topOC);
                this.childrenMap.put((Object)topOC, (Object)oc);
            } else {
                this.parentsMap.put((Object)oc, (Object)"2.5.6.0");
                this.childrenMap.put((Object)"2.5.6.0", (Object)oc);
                this.childrenMap.put((Object)this.root, (Object)oc);
            }
        }
    }

    public void attributeTypeAdded(AttributeTypeImpl at) {
        this.addAttributeType(at);
    }

    public void attributeTypeModified(AttributeTypeImpl at) {
        List<Object> parents = this.getParents((Object)at);
        if (parents != null) {
            for (Object parent : parents) {
                this.childrenMap.remove(parent, (Object)at);
            }
            this.parentsMap.remove((Object)at);
        }
        this.addAttributeType(at);
    }

    public void attributeTypeRemoved(AttributeTypeImpl at) {
        this.removeAttributeType(at);
    }

    private void checkAliasesAndOID(SchemaObject object) {
        List children;
        String oid;
        String[] aliases = object.getNamesRef();
        if (aliases != null) {
            for (String alias : aliases) {
                List children2 = (List)this.childrenMap.get((Object)alias.toLowerCase());
                if (children2 == null) continue;
                for (Object value : children2) {
                    this.childrenMap.put((Object)object, value);
                    this.parentsMap.remove(value, (Object)alias.toLowerCase());
                    this.parentsMap.put(value, (Object)object);
                }
                this.childrenMap.remove((Object)alias.toLowerCase());
            }
        }
        if ((oid = object.getOid()) != null && (children = (List)this.childrenMap.get((Object)oid.toLowerCase())) != null) {
            for (Object value : children) {
                this.childrenMap.put((Object)object, value);
                if (oid.equals("2.5.6.0")) {
                    this.childrenMap.remove((Object)this.root, value);
                }
                this.parentsMap.remove(value, (Object)oid.toLowerCase());
                this.parentsMap.put(value, (Object)object);
            }
            this.childrenMap.remove((Object)oid.toLowerCase());
        }
    }

    public List<Object> getChildren(Object o) {
        return (List)this.childrenMap.get(o);
    }

    public List<Object> getParents(Object o) {
        return (List)this.parentsMap.get(o);
    }

    public RootObject getRootObject() {
        return this.root;
    }

    private void loadSchema() {
        if (this.schemaHandler != null) {
            this.root = new RootObject();
            for (Schema schema : this.schemaHandler.getSchemas()) {
                for (AttributeTypeImpl at : schema.getAttributeTypes()) {
                    this.addAttributeType(at);
                }
                for (ObjectClassImpl oc : schema.getObjectClasses()) {
                    this.addObjectClass(oc);
                }
            }
        }
    }

    public void objectClassAdded(ObjectClassImpl oc) {
        this.addObjectClass(oc);
    }

    public void objectClassModified(ObjectClassImpl oc) {
        List<Object> parents = this.getParents((Object)oc);
        if (parents != null) {
            for (Object parent : parents) {
                this.childrenMap.remove(parent, (Object)oc);
            }
            this.parentsMap.remove((Object)oc);
        }
        this.addObjectClass(oc);
    }

    public void objectClassRemoved(ObjectClassImpl oc) {
        this.removeObjectClass(oc);
    }

    private void removeAttributeType(AttributeTypeImpl at) {
        String superiorName = at.getSuperiorName();
        if (superiorName != null && !"".equals(superiorName)) {
            AttributeTypeImpl superiorAT = this.schemaHandler.getAttributeType(superiorName);
            if (superiorAT == null) {
                this.childrenMap.remove((Object)superiorName.toLowerCase(), (Object)at);
            } else {
                this.childrenMap.remove((Object)superiorAT, (Object)at);
            }
        } else {
            this.childrenMap.remove((Object)this.root, (Object)at);
        }
        List<Object> children = this.getChildren((Object)at);
        if (children != null) {
            for (Object child : children) {
                AttributeTypeImpl childAT = (AttributeTypeImpl)((Object)child);
                this.parentsMap.remove(child, (Object)at);
                this.parentsMap.put(child, (Object)this.root);
                this.childrenMap.put((Object)this.root, child);
                String childSuperiorName = childAT.getSuperiorName();
                if (childSuperiorName == null || "".equals(childSuperiorName)) continue;
                this.parentsMap.put(child, (Object)childSuperiorName.toLowerCase());
                this.childrenMap.put((Object)childSuperiorName.toLowerCase(), child);
            }
        }
        this.childrenMap.remove((Object)at);
        this.parentsMap.remove((Object)at);
    }

    private void removeObjectClass(ObjectClassImpl oc) {
        String[] superClassesNames = oc.getSuperClassesNames();
        if (superClassesNames != null && superClassesNames.length > 0) {
            for (String superClassName : superClassesNames) {
                if ("".equals(superClassName)) continue;
                ObjectClassImpl superClassOC = this.schemaHandler.getObjectClass(superClassName);
                if (superClassOC == null) {
                    this.childrenMap.remove((Object)superClassName.toLowerCase(), (Object)oc);
                    this.childrenMap.remove((Object)this.root, (Object)oc);
                    continue;
                }
                this.childrenMap.remove((Object)superClassOC, (Object)oc);
            }
        } else if (oc.getOid().equals("2.5.6.0")) {
            this.childrenMap.remove((Object)this.root, (Object)oc);
        } else {
            ObjectClassImpl topOC = this.schemaHandler.getObjectClass("2.5.6.0");
            if (topOC != null) {
                this.childrenMap.remove((Object)topOC, (Object)oc);
            } else {
                this.childrenMap.remove((Object)"2.5.6.0", (Object)oc);
            }
        }
        List<Object> children = this.getChildren((Object)oc);
        if (children != null) {
            for (Object child : children) {
                ObjectClassImpl childOC = (ObjectClassImpl)((Object)child);
                this.parentsMap.remove(child, (Object)oc);
                this.parentsMap.put(child, (Object)this.root);
                this.childrenMap.put((Object)this.root, child);
                String[] childSuperClassesNames = childOC.getSuperClassesNames();
                if (childSuperClassesNames != null && childSuperClassesNames.length > 0) {
                    String correctSuperClassName = this.getCorrectSuperClassName(oc, childSuperClassesNames);
                    if (correctSuperClassName == null) continue;
                    this.parentsMap.put(child, (Object)correctSuperClassName.toLowerCase());
                    this.childrenMap.put((Object)correctSuperClassName.toLowerCase(), child);
                    continue;
                }
                this.parentsMap.put(child, (Object)"2.5.6.0");
                this.childrenMap.put((Object)"2.5.6.0", child);
            }
        }
        this.childrenMap.remove((Object)oc);
        this.parentsMap.remove((Object)oc);
    }

    private String getCorrectSuperClassName(ObjectClassImpl oc, String[] childSuperClassesNames) {
        List<String> aliases;
        if (childSuperClassesNames != null && (aliases = Arrays.asList(oc.getNamesRef())) != null) {
            for (String childSuperClassName : childSuperClassesNames) {
                if (!aliases.contains(childSuperClassName)) continue;
                return childSuperClassName;
            }
        }
        return null;
    }
}

