/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.model.difference;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.directory.shared.ldap.schema.ObjectClassTypeEnum;
import org.apache.directory.shared.ldap.schema.SchemaObject;
import org.apache.directory.shared.ldap.schema.UsageEnum;
import org.apache.directory.studio.schemaeditor.model.AttributeTypeImpl;
import org.apache.directory.studio.schemaeditor.model.ObjectClassImpl;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.model.difference.AliasDifference;
import org.apache.directory.studio.schemaeditor.model.difference.AttributeTypeDifference;
import org.apache.directory.studio.schemaeditor.model.difference.ClassTypeDifference;
import org.apache.directory.studio.schemaeditor.model.difference.CollectiveDifference;
import org.apache.directory.studio.schemaeditor.model.difference.DescriptionDifference;
import org.apache.directory.studio.schemaeditor.model.difference.DifferenceType;
import org.apache.directory.studio.schemaeditor.model.difference.EqualityDifference;
import org.apache.directory.studio.schemaeditor.model.difference.MandatoryATDifference;
import org.apache.directory.studio.schemaeditor.model.difference.NoUserModificationDifference;
import org.apache.directory.studio.schemaeditor.model.difference.ObjectClassDifference;
import org.apache.directory.studio.schemaeditor.model.difference.ObsoleteDifference;
import org.apache.directory.studio.schemaeditor.model.difference.OptionalATDifference;
import org.apache.directory.studio.schemaeditor.model.difference.OrderingDifference;
import org.apache.directory.studio.schemaeditor.model.difference.PropertyDifference;
import org.apache.directory.studio.schemaeditor.model.difference.SchemaDifference;
import org.apache.directory.studio.schemaeditor.model.difference.SingleValueDifference;
import org.apache.directory.studio.schemaeditor.model.difference.SubstringDifference;
import org.apache.directory.studio.schemaeditor.model.difference.SuperiorATDifference;
import org.apache.directory.studio.schemaeditor.model.difference.SuperiorOCDifference;
import org.apache.directory.studio.schemaeditor.model.difference.SyntaxDifference;
import org.apache.directory.studio.schemaeditor.model.difference.SyntaxLengthDifference;
import org.apache.directory.studio.schemaeditor.model.difference.UsageDifference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DifferenceEngine {
    public static List<SchemaDifference> getDifferences(List<Schema> l1, List<Schema> l2) {
        SchemaDifference schemaDifference;
        ArrayList<SchemaDifference> differences = new ArrayList<SchemaDifference>();
        HashMap<String, Schema> mapL1 = new HashMap<String, Schema>();
        for (Schema schema : l1) {
            mapL1.put(schema.getName().toLowerCase(), schema);
        }
        HashMap<String, Schema> mapL2 = new HashMap<String, Schema>();
        for (Schema schema : l2) {
            mapL2.put(schema.getName().toLowerCase(), schema);
        }
        for (Schema schemaFromL1 : l1) {
            ObjectClassDifference objectClassDifference;
            AttributeTypeDifference attributeTypeDifference;
            Schema schemaFromL2 = (Schema)mapL2.get(schemaFromL1.getName().toLowerCase());
            if (schemaFromL2 == null) {
                schemaDifference = new SchemaDifference(schemaFromL1, null, DifferenceType.REMOVED);
                differences.add(schemaDifference);
                for (AttributeTypeImpl at : schemaFromL1.getAttributeTypes()) {
                    schemaDifference.addAttributeTypeDifference(new AttributeTypeDifference(null, (Object)at, DifferenceType.REMOVED));
                }
                for (ObjectClassImpl oc : schemaFromL1.getObjectClasses()) {
                    schemaDifference.addObjectClassDifference(new ObjectClassDifference(null, (Object)oc, DifferenceType.REMOVED));
                }
                continue;
            }
            schemaDifference = new SchemaDifference(schemaFromL1, schemaFromL2, DifferenceType.IDENTICAL);
            differences.add(schemaDifference);
            HashMap<String, AttributeTypeImpl> atMapL1 = new HashMap<String, AttributeTypeImpl>();
            for (AttributeTypeImpl at : schemaFromL1.getAttributeTypes()) {
                atMapL1.put(at.getOid(), at);
            }
            HashMap<String, AttributeTypeImpl> atMapL2 = new HashMap<String, AttributeTypeImpl>();
            for (AttributeTypeImpl at : schemaFromL2.getAttributeTypes()) {
                atMapL2.put(at.getOid(), at);
            }
            for (AttributeTypeImpl atFromL1 : schemaFromL1.getAttributeTypes()) {
                AttributeTypeImpl atFromL2 = (AttributeTypeImpl)((Object)atMapL2.get(atFromL1.getOid()));
                if (atFromL2 == null) {
                    attributeTypeDifference = new AttributeTypeDifference((Object)atFromL1, null, DifferenceType.REMOVED);
                    schemaDifference.addAttributeTypeDifference(attributeTypeDifference);
                    schemaDifference.setType(DifferenceType.MODIFIED);
                    continue;
                }
                attributeTypeDifference = new AttributeTypeDifference((Object)atFromL1, (Object)atFromL2, DifferenceType.IDENTICAL);
                schemaDifference.addAttributeTypeDifference(attributeTypeDifference);
                List<PropertyDifference> atDifferences = DifferenceEngine.getDifferences(atFromL1, atFromL2);
                if (atDifferences.size() <= 0) continue;
                attributeTypeDifference.setType(DifferenceType.MODIFIED);
                attributeTypeDifference.addDifferences(atDifferences);
                schemaDifference.setType(DifferenceType.MODIFIED);
            }
            for (AttributeTypeImpl atFromL2 : schemaFromL2.getAttributeTypes()) {
                AttributeTypeImpl atFromL1 = (AttributeTypeImpl)((Object)atMapL1.get(atFromL2.getOid()));
                if (atFromL1 != null) continue;
                attributeTypeDifference = new AttributeTypeDifference(null, (Object)atFromL2, DifferenceType.ADDED);
                schemaDifference.addAttributeTypeDifference(attributeTypeDifference);
                schemaDifference.setType(DifferenceType.MODIFIED);
            }
            HashMap<String, ObjectClassImpl> ocMapL1 = new HashMap<String, ObjectClassImpl>();
            for (ObjectClassImpl oc : schemaFromL1.getObjectClasses()) {
                ocMapL1.put(oc.getOid(), oc);
            }
            HashMap<String, ObjectClassImpl> ocMapL2 = new HashMap<String, ObjectClassImpl>();
            for (ObjectClassImpl oc : schemaFromL2.getObjectClasses()) {
                ocMapL2.put(oc.getOid(), oc);
            }
            for (ObjectClassImpl ocFromL1 : schemaFromL1.getObjectClasses()) {
                ObjectClassImpl ocFromL2 = (ObjectClassImpl)((Object)ocMapL2.get(ocFromL1.getOid()));
                if (ocFromL2 == null) {
                    objectClassDifference = new ObjectClassDifference((Object)ocFromL1, null, DifferenceType.REMOVED);
                    schemaDifference.addObjectClassDifference(objectClassDifference);
                    schemaDifference.setType(DifferenceType.MODIFIED);
                    continue;
                }
                objectClassDifference = new ObjectClassDifference((Object)ocFromL1, (Object)ocFromL2, DifferenceType.IDENTICAL);
                schemaDifference.addObjectClassDifference(objectClassDifference);
                List<PropertyDifference> ocDifferences = DifferenceEngine.getDifferences(ocFromL1, ocFromL2);
                if (ocDifferences.size() <= 0) continue;
                objectClassDifference.setType(DifferenceType.MODIFIED);
                objectClassDifference.addDifferences(ocDifferences);
                schemaDifference.setType(DifferenceType.MODIFIED);
            }
            for (ObjectClassImpl ocFromL2 : schemaFromL2.getObjectClasses()) {
                ObjectClassImpl ocFromL1 = (ObjectClassImpl)((Object)ocMapL1.get(ocFromL2.getOid()));
                if (ocFromL1 != null) continue;
                objectClassDifference = new ObjectClassDifference(null, (Object)ocFromL2, DifferenceType.ADDED);
                schemaDifference.addObjectClassDifference(objectClassDifference);
                schemaDifference.setType(DifferenceType.MODIFIED);
            }
        }
        for (Schema schemaFromL2 : l2) {
            Schema schemaFromL1 = (Schema)mapL1.get(schemaFromL2.getName().toLowerCase());
            if (schemaFromL1 != null) continue;
            schemaDifference = new SchemaDifference(null, schemaFromL2, DifferenceType.ADDED);
            differences.add(schemaDifference);
            for (AttributeTypeImpl at : schemaFromL2.getAttributeTypes()) {
                schemaDifference.addAttributeTypeDifference(new AttributeTypeDifference(null, (Object)at, DifferenceType.ADDED));
            }
            for (ObjectClassImpl oc : schemaFromL2.getObjectClasses()) {
                schemaDifference.addObjectClassDifference(new ObjectClassDifference(null, (Object)oc, DifferenceType.ADDED));
            }
        }
        return differences;
    }

    public static List<PropertyDifference> getDifferences(ObjectClassImpl oc1, ObjectClassImpl oc2) {
        PropertyDifference classTypeDifference;
        PropertyDifference obsoleteDifference;
        ArrayList<PropertyDifference> differences = new ArrayList<PropertyDifference>();
        differences.addAll(DifferenceEngine.getAliasesDifferences((SchemaObject)oc1, (SchemaObject)oc2));
        PropertyDifference descriptionDifference = DifferenceEngine.getDescriptionDifference((SchemaObject)oc1, (SchemaObject)oc2);
        if (descriptionDifference != null) {
            differences.add(descriptionDifference);
        }
        if ((obsoleteDifference = DifferenceEngine.getObsoleteDifference((SchemaObject)oc1, (SchemaObject)oc2)) != null) {
            differences.add(obsoleteDifference);
        }
        if ((classTypeDifference = DifferenceEngine.getClassTypeDifference(oc1, oc2)) != null) {
            differences.add(classTypeDifference);
        }
        differences.addAll(DifferenceEngine.getSuperiorClassesDifferences(oc1, oc2));
        differences.addAll(DifferenceEngine.getMandatoryAttributeTypesDifferences(oc1, oc2));
        differences.addAll(DifferenceEngine.getOptionalAttributeTypesDifferences(oc1, oc2));
        return differences;
    }

    public static List<PropertyDifference> getDifferences(AttributeTypeImpl at1, AttributeTypeImpl at2) {
        PropertyDifference substringDifference;
        PropertyDifference orderingDifference;
        PropertyDifference equalityDifference;
        PropertyDifference noUserModificationDifference;
        PropertyDifference collectiveDifference;
        PropertyDifference singleValueDifference;
        PropertyDifference syntaxLengthDifference;
        PropertyDifference syntaxDifference;
        PropertyDifference superiorDifference;
        PropertyDifference usageDifference;
        PropertyDifference obsoleteDifference;
        ArrayList<PropertyDifference> differences = new ArrayList<PropertyDifference>();
        differences.addAll(DifferenceEngine.getAliasesDifferences((SchemaObject)at1, (SchemaObject)at2));
        PropertyDifference descriptionDifference = DifferenceEngine.getDescriptionDifference((SchemaObject)at1, (SchemaObject)at2);
        if (descriptionDifference != null) {
            differences.add(descriptionDifference);
        }
        if ((obsoleteDifference = DifferenceEngine.getObsoleteDifference((SchemaObject)at1, (SchemaObject)at2)) != null) {
            differences.add(obsoleteDifference);
        }
        if ((usageDifference = DifferenceEngine.getUsageDifference(at1, at2)) != null) {
            differences.add(usageDifference);
        }
        if ((superiorDifference = DifferenceEngine.getSuperiorDifference(at1, at2)) != null) {
            differences.add(superiorDifference);
        }
        if ((syntaxDifference = DifferenceEngine.getSyntaxDifference(at1, at2)) != null) {
            differences.add(syntaxDifference);
        }
        if ((syntaxLengthDifference = DifferenceEngine.getSyntaxLengthDifference(at1, at2)) != null) {
            differences.add(syntaxLengthDifference);
        }
        if ((singleValueDifference = DifferenceEngine.getSingleValueDifference(at1, at2)) != null) {
            differences.add(singleValueDifference);
        }
        if ((collectiveDifference = DifferenceEngine.getCollectiveDifference(at1, at2)) != null) {
            differences.add(collectiveDifference);
        }
        if ((noUserModificationDifference = DifferenceEngine.getNoUserModificationDifference(at1, at2)) != null) {
            differences.add(noUserModificationDifference);
        }
        if ((equalityDifference = DifferenceEngine.getEqualityDifference(at1, at2)) != null) {
            differences.add(equalityDifference);
        }
        if ((orderingDifference = DifferenceEngine.getOrderingDifference(at1, at2)) != null) {
            differences.add(orderingDifference);
        }
        if ((substringDifference = DifferenceEngine.getSubstringDifference(at1, at2)) != null) {
            differences.add(substringDifference);
        }
        return differences;
    }

    private static List<PropertyDifference> getAliasesDifferences(SchemaObject so1, SchemaObject so2) {
        ArrayList<PropertyDifference> differences = new ArrayList<PropertyDifference>();
        String[] so1Names = so1.getNamesRef();
        ArrayList<String> so1NamesList = new ArrayList<String>();
        if (so1Names != null) {
            for (String name : so1Names) {
                so1NamesList.add(name);
            }
        }
        String[] so2Names = so2.getNamesRef();
        ArrayList<String> so2NamesList = new ArrayList<String>();
        if (so2Names != null) {
            for (String name : so2Names) {
                so2NamesList.add(name);
            }
        }
        for (String name : so1NamesList) {
            if (so2NamesList.contains(name)) continue;
            AliasDifference diff = new AliasDifference(so1, so2, DifferenceType.REMOVED);
            diff.setOldValue(name);
            differences.add(diff);
        }
        for (String name : so2NamesList) {
            if (so1NamesList.contains(name)) continue;
            AliasDifference diff = new AliasDifference(so1, so2, DifferenceType.ADDED);
            diff.setNewValue(name);
            differences.add(diff);
        }
        return differences;
    }

    private static PropertyDifference getDescriptionDifference(SchemaObject so1, SchemaObject so2) {
        String so1Description = so1.getDescription();
        String so2Description = so2.getDescription();
        if (so1Description == null && so2Description != null) {
            DescriptionDifference diff = new DescriptionDifference(so1, so2, DifferenceType.ADDED);
            diff.setNewValue(so2Description);
            return diff;
        }
        if (so1Description != null && so2Description == null) {
            DescriptionDifference diff = new DescriptionDifference(so1, so2, DifferenceType.REMOVED);
            diff.setOldValue(so1Description);
            return diff;
        }
        if (so1Description != null && so2Description != null && !so1Description.equals(so2Description)) {
            DescriptionDifference diff = new DescriptionDifference(so1, so2, DifferenceType.MODIFIED);
            diff.setOldValue(so1Description);
            diff.setNewValue(so2Description);
            return diff;
        }
        return null;
    }

    private static PropertyDifference getObsoleteDifference(SchemaObject so1, SchemaObject so2) {
        boolean so2Obsolete;
        boolean so1Obsolete = so1.isObsolete();
        if (so1Obsolete != (so2Obsolete = so2.isObsolete())) {
            ObsoleteDifference diff = new ObsoleteDifference(so1, so2);
            diff.setOldValue(so1Obsolete);
            diff.setNewValue(so2Obsolete);
            return diff;
        }
        return null;
    }

    private static PropertyDifference getClassTypeDifference(ObjectClassImpl oc1, ObjectClassImpl oc2) {
        ObjectClassTypeEnum oc2ClassType;
        ObjectClassTypeEnum oc1ClassType = oc1.getType();
        if (oc1ClassType != (oc2ClassType = oc2.getType())) {
            ClassTypeDifference diff = new ClassTypeDifference((Object)oc1, (Object)oc2);
            diff.setOldValue(oc1ClassType);
            diff.setNewValue(oc2ClassType);
            return diff;
        }
        return null;
    }

    private static List<PropertyDifference> getSuperiorClassesDifferences(ObjectClassImpl oc1, ObjectClassImpl oc2) {
        ArrayList<PropertyDifference> differences = new ArrayList<PropertyDifference>();
        String[] oc1Sups = oc1.getSuperClassesNames();
        ArrayList<String> oc1SupsList = new ArrayList<String>();
        if (oc1Sups != null) {
            for (String name : oc1Sups) {
                oc1SupsList.add(name);
            }
        }
        String[] oc2Sups = oc2.getSuperClassesNames();
        ArrayList<String> oc2SupsList = new ArrayList<String>();
        if (oc2Sups != null) {
            for (String name : oc2Sups) {
                oc2SupsList.add(name);
            }
        }
        for (String name : oc1SupsList) {
            if (oc2SupsList.contains(name)) continue;
            SuperiorOCDifference diff = new SuperiorOCDifference((Object)oc1, (Object)oc2, DifferenceType.REMOVED);
            diff.setOldValue(name);
            differences.add(diff);
        }
        for (String name : oc2SupsList) {
            if (oc1SupsList.contains(name)) continue;
            SuperiorOCDifference diff = new SuperiorOCDifference((Object)oc1, (Object)oc2, DifferenceType.ADDED);
            diff.setNewValue(name);
            differences.add(diff);
        }
        return differences;
    }

    private static List<PropertyDifference> getMandatoryAttributeTypesDifferences(ObjectClassImpl oc1, ObjectClassImpl oc2) {
        ArrayList<PropertyDifference> differences = new ArrayList<PropertyDifference>();
        String[] oc1Musts = oc1.getMustNamesList();
        ArrayList<String> oc1MustsList = new ArrayList<String>();
        if (oc1Musts != null) {
            for (String name : oc1Musts) {
                oc1MustsList.add(name);
            }
        }
        String[] oc2Musts = oc2.getMustNamesList();
        ArrayList<String> oc2MustsList = new ArrayList<String>();
        if (oc2Musts != null) {
            for (String name : oc2Musts) {
                oc2MustsList.add(name);
            }
        }
        for (String name : oc1MustsList) {
            if (oc2MustsList.contains(name)) continue;
            MandatoryATDifference diff = new MandatoryATDifference((Object)oc1, (Object)oc2, DifferenceType.REMOVED);
            diff.setOldValue(name);
            differences.add(diff);
        }
        for (String name : oc2MustsList) {
            if (oc1MustsList.contains(name)) continue;
            MandatoryATDifference diff = new MandatoryATDifference((Object)oc1, (Object)oc2, DifferenceType.ADDED);
            diff.setNewValue(name);
            differences.add(diff);
        }
        return differences;
    }

    private static List<PropertyDifference> getOptionalAttributeTypesDifferences(ObjectClassImpl oc1, ObjectClassImpl oc2) {
        ArrayList<PropertyDifference> differences = new ArrayList<PropertyDifference>();
        String[] oc1Mays = oc1.getMayNamesList();
        ArrayList<String> oc1MaysList = new ArrayList<String>();
        if (oc1Mays != null) {
            for (String name : oc1Mays) {
                oc1MaysList.add(name);
            }
        }
        String[] oc2Mays = oc2.getMayNamesList();
        ArrayList<String> oc2MaysList = new ArrayList<String>();
        if (oc2Mays != null) {
            for (String name : oc2Mays) {
                oc2MaysList.add(name);
            }
        }
        for (String name : oc1MaysList) {
            if (oc2MaysList.contains(name)) continue;
            OptionalATDifference diff = new OptionalATDifference((Object)oc1, (Object)oc2, DifferenceType.REMOVED);
            diff.setOldValue(name);
            differences.add(diff);
        }
        for (String name : oc2MaysList) {
            if (oc1MaysList.contains(name)) continue;
            OptionalATDifference diff = new OptionalATDifference((Object)oc1, (Object)oc2, DifferenceType.ADDED);
            diff.setNewValue(name);
            differences.add(diff);
        }
        return differences;
    }

    private static PropertyDifference getUsageDifference(AttributeTypeImpl at1, AttributeTypeImpl at2) {
        UsageEnum at2Usage;
        UsageEnum at1Usage = at1.getUsage();
        if (at1Usage != (at2Usage = at2.getUsage())) {
            UsageDifference diff = new UsageDifference((Object)at1, (Object)at2);
            diff.setOldValue(at1Usage);
            diff.setNewValue(at2Usage);
            return diff;
        }
        return null;
    }

    private static PropertyDifference getSuperiorDifference(AttributeTypeImpl at1, AttributeTypeImpl at2) {
        String at1Superior = at1.getSuperiorName();
        String at2Superior = at2.getSuperiorName();
        if (at1Superior == null && at2Superior != null) {
            SuperiorATDifference diff = new SuperiorATDifference((Object)at1, (Object)at2, DifferenceType.ADDED);
            diff.setNewValue(at2Superior);
            return diff;
        }
        if (at1Superior != null && at2Superior == null) {
            SuperiorATDifference diff = new SuperiorATDifference((Object)at1, (Object)at2, DifferenceType.REMOVED);
            diff.setOldValue(at1Superior);
            return diff;
        }
        if (at1Superior != null && at2Superior != null && !at1Superior.equals(at2Superior)) {
            SuperiorATDifference diff = new SuperiorATDifference((Object)at1, (Object)at2, DifferenceType.MODIFIED);
            diff.setOldValue(at1Superior);
            diff.setNewValue(at2Superior);
            return diff;
        }
        return null;
    }

    private static PropertyDifference getSyntaxDifference(AttributeTypeImpl at1, AttributeTypeImpl at2) {
        String at1Syntax = at1.getSyntaxOid();
        String at2Syntax = at2.getSyntaxOid();
        if (at1Syntax == null && at2Syntax != null) {
            SyntaxDifference diff = new SyntaxDifference((Object)at1, (Object)at2, DifferenceType.ADDED);
            diff.setNewValue(at2Syntax);
            return diff;
        }
        if (at1Syntax != null && at2Syntax == null) {
            SyntaxDifference diff = new SyntaxDifference((Object)at1, (Object)at2, DifferenceType.REMOVED);
            diff.setOldValue(at1Syntax);
            return diff;
        }
        if (at1Syntax != null && at2Syntax != null && !at1Syntax.equals(at2Syntax)) {
            SyntaxDifference diff = new SyntaxDifference((Object)at1, (Object)at2, DifferenceType.MODIFIED);
            diff.setOldValue(at1Syntax);
            diff.setNewValue(at2Syntax);
            return diff;
        }
        return null;
    }

    private static PropertyDifference getSyntaxLengthDifference(AttributeTypeImpl at1, AttributeTypeImpl at2) {
        int at1SyntaxLength = at1.getLength();
        int at2SyntaxLength = at2.getLength();
        if (at1SyntaxLength == -1 && at2SyntaxLength != -1) {
            SyntaxLengthDifference diff = new SyntaxLengthDifference((Object)at1, (Object)at2, DifferenceType.ADDED);
            diff.setNewValue(at2SyntaxLength);
            return diff;
        }
        if (at1SyntaxLength != -1 && at2SyntaxLength == -1) {
            SyntaxLengthDifference diff = new SyntaxLengthDifference((Object)at1, (Object)at2, DifferenceType.REMOVED);
            diff.setOldValue(at1SyntaxLength);
            return diff;
        }
        if (at1SyntaxLength != -1 && at2SyntaxLength != -1 && at1SyntaxLength != at2SyntaxLength) {
            SyntaxLengthDifference diff = new SyntaxLengthDifference((Object)at1, (Object)at2, DifferenceType.MODIFIED);
            diff.setOldValue(at1SyntaxLength);
            diff.setNewValue(at2SyntaxLength);
            return diff;
        }
        return null;
    }

    private static PropertyDifference getSingleValueDifference(AttributeTypeImpl at1, AttributeTypeImpl at2) {
        boolean at2SingleValue;
        boolean at1SingleValue = at1.isSingleValue();
        if (at1SingleValue != (at2SingleValue = at2.isSingleValue())) {
            SingleValueDifference diff = new SingleValueDifference((Object)at1, (Object)at2);
            diff.setOldValue(at1SingleValue);
            diff.setNewValue(at2SingleValue);
            return diff;
        }
        return null;
    }

    private static PropertyDifference getCollectiveDifference(AttributeTypeImpl at1, AttributeTypeImpl at2) {
        boolean at2Collective;
        boolean at1Collective = at1.isCollective();
        if (at1Collective != (at2Collective = at2.isCollective())) {
            CollectiveDifference diff = new CollectiveDifference((Object)at1, (Object)at2);
            diff.setOldValue(at1Collective);
            diff.setNewValue(at2Collective);
            return diff;
        }
        return null;
    }

    private static PropertyDifference getNoUserModificationDifference(AttributeTypeImpl at1, AttributeTypeImpl at2) {
        boolean at2CanUserModify;
        boolean at1CanUserModify = at1.isCanUserModify();
        if (at1CanUserModify != (at2CanUserModify = at2.isCanUserModify())) {
            NoUserModificationDifference diff = new NoUserModificationDifference((Object)at1, (Object)at2);
            diff.setOldValue(at1CanUserModify);
            diff.setNewValue(at2CanUserModify);
            return diff;
        }
        return null;
    }

    private static PropertyDifference getEqualityDifference(AttributeTypeImpl at1, AttributeTypeImpl at2) {
        String at1Equality = at1.getEqualityName();
        String at2Equality = at2.getEqualityName();
        if (at1Equality == null && at2Equality != null) {
            EqualityDifference diff = new EqualityDifference((Object)at1, (Object)at2, DifferenceType.ADDED);
            diff.setNewValue(at2Equality);
            return diff;
        }
        if (at1Equality != null && at2Equality == null) {
            EqualityDifference diff = new EqualityDifference((Object)at1, (Object)at2, DifferenceType.REMOVED);
            diff.setOldValue(at1Equality);
            return diff;
        }
        if (at1Equality != null && at2Equality != null && !at1Equality.equals(at2Equality)) {
            EqualityDifference diff = new EqualityDifference((Object)at1, (Object)at2, DifferenceType.MODIFIED);
            diff.setOldValue(at1Equality);
            diff.setNewValue(at2Equality);
            return diff;
        }
        return null;
    }

    private static PropertyDifference getOrderingDifference(AttributeTypeImpl at1, AttributeTypeImpl at2) {
        String at1Ordering = at1.getOrderingName();
        String at2Ordering = at2.getOrderingName();
        if (at1Ordering == null && at2Ordering != null) {
            OrderingDifference diff = new OrderingDifference((Object)at1, (Object)at2, DifferenceType.ADDED);
            diff.setNewValue(at2Ordering);
            return diff;
        }
        if (at1Ordering != null && at2Ordering == null) {
            OrderingDifference diff = new OrderingDifference((Object)at1, (Object)at2, DifferenceType.REMOVED);
            diff.setOldValue(at1Ordering);
            return diff;
        }
        if (at1Ordering != null && at2Ordering != null && !at1Ordering.equals(at2Ordering)) {
            OrderingDifference diff = new OrderingDifference((Object)at1, (Object)at2, DifferenceType.MODIFIED);
            diff.setOldValue(at1Ordering);
            diff.setNewValue(at2Ordering);
            return diff;
        }
        return null;
    }

    private static PropertyDifference getSubstringDifference(AttributeTypeImpl at1, AttributeTypeImpl at2) {
        String at1Substring = at1.getSubstrName();
        String at2Substring = at2.getSubstrName();
        if (at1Substring == null && at2Substring != null) {
            SubstringDifference diff = new SubstringDifference((Object)at1, (Object)at2, DifferenceType.ADDED);
            diff.setNewValue(at2Substring);
            return diff;
        }
        if (at1Substring != null && at2Substring == null) {
            SubstringDifference diff = new SubstringDifference((Object)at1, (Object)at2, DifferenceType.REMOVED);
            diff.setOldValue(at1Substring);
            return diff;
        }
        if (at1Substring != null && at2Substring != null && !at1Substring.equals(at2Substring)) {
            SubstringDifference diff = new SubstringDifference((Object)at1, (Object)at2, DifferenceType.MODIFIED);
            diff.setOldValue(at1Substring);
            diff.setNewValue(at2Substring);
            return diff;
        }
        return null;
    }
}

