/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.studio.schemaeditor.model.AttributeTypeImpl;
import org.apache.directory.studio.schemaeditor.model.MatchingRuleImpl;
import org.apache.directory.studio.schemaeditor.model.ObjectClassImpl;
import org.apache.directory.studio.schemaeditor.model.Project;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.model.SyntaxImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaImpl
implements Schema {
    private String name;
    private Project project;
    private List<AttributeTypeImpl> attributeTypes = new ArrayList<AttributeTypeImpl>();
    private List<ObjectClassImpl> objectClasses = new ArrayList<ObjectClassImpl>();
    private List<MatchingRuleImpl> matchingRules = new ArrayList<MatchingRuleImpl>();
    private List<SyntaxImpl> syntaxes = new ArrayList<SyntaxImpl>();

    public SchemaImpl(String name) {
        this.name = name;
    }

    @Override
    public boolean addAttributeType(AttributeTypeImpl at) {
        return this.attributeTypes.add(at);
    }

    @Override
    public boolean addMatchingRule(MatchingRuleImpl mr) {
        return this.matchingRules.add(mr);
    }

    @Override
    public boolean addObjectClass(ObjectClassImpl oc) {
        return this.objectClasses.add(oc);
    }

    @Override
    public boolean addSyntax(SyntaxImpl syntax) {
        return this.syntaxes.add(syntax);
    }

    @Override
    public AttributeTypeImpl getAttributeType(String id) {
        for (AttributeTypeImpl at : this.attributeTypes) {
            String[] aliases = at.getNamesRef();
            if (aliases != null) {
                for (String alias : aliases) {
                    if (!alias.equalsIgnoreCase(id)) continue;
                    return at;
                }
            }
            if (!at.getOid().equalsIgnoreCase(id)) continue;
            return at;
        }
        return null;
    }

    @Override
    public List<AttributeTypeImpl> getAttributeTypes() {
        return this.attributeTypes;
    }

    @Override
    public MatchingRuleImpl getMatchingRule(String id) {
        for (MatchingRuleImpl mr : this.matchingRules) {
            String[] aliases = mr.getNamesRef();
            if (aliases != null) {
                for (String alias : aliases) {
                    if (!alias.equalsIgnoreCase(id)) continue;
                    return mr;
                }
            }
            if (!mr.getOid().equalsIgnoreCase(id)) continue;
            return mr;
        }
        return null;
    }

    @Override
    public List<MatchingRuleImpl> getMatchingRules() {
        return this.matchingRules;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    @Override
    public ObjectClassImpl getObjectClass(String id) {
        for (ObjectClassImpl oc : this.objectClasses) {
            String[] aliases = oc.getNamesRef();
            if (aliases != null) {
                for (String alias : aliases) {
                    if (!alias.equalsIgnoreCase(id)) continue;
                    return oc;
                }
            }
            if (!oc.getOid().equalsIgnoreCase(id)) continue;
            return oc;
        }
        return null;
    }

    @Override
    public List<ObjectClassImpl> getObjectClasses() {
        return this.objectClasses;
    }

    @Override
    public SyntaxImpl getSyntax(String id) {
        for (SyntaxImpl syntax : this.syntaxes) {
            String[] aliases = syntax.getNamesRef();
            if (aliases != null) {
                for (String alias : aliases) {
                    if (!alias.equalsIgnoreCase(id)) continue;
                    return syntax;
                }
            }
            if (!syntax.getOid().equalsIgnoreCase(id)) continue;
            return syntax;
        }
        return null;
    }

    @Override
    public List<SyntaxImpl> getSyntaxes() {
        return this.syntaxes;
    }

    @Override
    public boolean removeAttributeType(AttributeTypeImpl at) {
        return this.attributeTypes.remove((Object)at);
    }

    @Override
    public boolean removeMatchingRule(MatchingRuleImpl mr) {
        return this.matchingRules.remove((Object)mr);
    }

    @Override
    public boolean removeObjectClass(ObjectClassImpl oc) {
        return this.objectClasses.remove((Object)oc);
    }

    @Override
    public boolean removeSyntax(SyntaxImpl syntax) {
        return this.syntaxes.remove((Object)syntax);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setProject(Project project) {
        this.project = project;
    }

    public String toString() {
        return this.getName();
    }
}

