/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.directory.shared.ldap.schema.SchemaObject;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandler;
import org.apache.directory.studio.schemaeditor.model.AttributeTypeImpl;
import org.apache.directory.studio.schemaeditor.model.MatchingRuleImpl;
import org.apache.directory.studio.schemaeditor.model.Messages;
import org.apache.directory.studio.schemaeditor.model.ObjectClassImpl;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.model.SyntaxImpl;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependenciesComputer {
    private List<Schema> schemasList;
    private List<Schema> dependencyOrderedSchemasList;
    private SchemaHandler schemaHandler;
    private MultiMap schemasDependencies;
    private MultiMap attributeTypesDependencies;
    private MultiMap objectClassesDependencies;

    public DependenciesComputer(List<Schema> schemas) throws DependencyComputerException {
        this.schemasList = schemas;
        this.schemaHandler = new SchemaHandler();
        this.schemasDependencies = new MultiValueMap();
        this.attributeTypesDependencies = new MultiValueMap();
        this.objectClassesDependencies = new MultiValueMap();
        if (schemas != null) {
            for (Schema schema : this.schemasList) {
                this.schemaHandler.addSchema(schema);
            }
            for (Schema schema : this.schemasList) {
                List<ObjectClassImpl> objectClasses;
                List<AttributeTypeImpl> attributeTypes = schema.getAttributeTypes();
                if (attributeTypes != null) {
                    for (AttributeTypeImpl attributeType : attributeTypes) {
                        this.computeDependencies(schema, attributeType);
                    }
                }
                if ((objectClasses = schema.getObjectClasses()) == null) continue;
                for (ObjectClassImpl objectClass : objectClasses) {
                    this.computeDependencies(schema, objectClass);
                }
            }
            this.orderSchemasBasedOnDependencies();
        }
    }

    private void computeDependencies(Schema schema, AttributeTypeImpl attributeType) throws DependencyComputerException {
        String substringName;
        String orderingName;
        String equalityName;
        String syntaxOID;
        String superior = attributeType.getSuperiorName();
        if (superior != null) {
            AttributeTypeImpl superiorAT = this.schemaHandler.getAttributeType(superior);
            if (superiorAT == null) {
                throw new DependencyComputerException(NLS.bind((String)Messages.getString("DependenciesComputer.SuperiorAttribute"), (Object[])new String[]{superior}));
            }
            this.attributeTypesDependencies.put((Object)attributeType, (Object)superiorAT);
            this.computeSchemaDependency(schema, (SchemaObject)superiorAT);
        }
        if ((syntaxOID = attributeType.getSyntaxOid()) != null) {
            SyntaxImpl syntax = this.schemaHandler.getSyntax(syntaxOID);
            if (syntax == null) {
                throw new DependencyComputerException(NLS.bind((String)Messages.getString("DependenciesComputer.SyntaxOID"), (Object[])new String[]{syntaxOID}));
            }
            this.attributeTypesDependencies.put((Object)attributeType, (Object)syntax);
            this.computeSchemaDependency(schema, (SchemaObject)syntax);
        }
        if ((equalityName = attributeType.getEqualityName()) != null) {
            MatchingRuleImpl equalityMatchingRule = this.schemaHandler.getMatchingRule(equalityName);
            if (equalityMatchingRule == null) {
                throw new DependencyComputerException(NLS.bind((String)Messages.getString("DependenciesComputer.Equality"), (Object[])new String[]{equalityName}));
            }
            this.attributeTypesDependencies.put((Object)attributeType, (Object)equalityMatchingRule);
            this.computeSchemaDependency(schema, (SchemaObject)equalityMatchingRule);
        }
        if ((orderingName = attributeType.getEqualityName()) != null) {
            MatchingRuleImpl orderingMatchingRule = this.schemaHandler.getMatchingRule(orderingName);
            if (orderingMatchingRule == null) {
                throw new DependencyComputerException(NLS.bind((String)Messages.getString("DependenciesComputer.Ordering"), (Object[])new String[]{orderingName}));
            }
            this.attributeTypesDependencies.put((Object)attributeType, (Object)orderingMatchingRule);
            this.computeSchemaDependency(schema, (SchemaObject)orderingMatchingRule);
        }
        if ((substringName = attributeType.getEqualityName()) != null) {
            MatchingRuleImpl substringMatchingRule = this.schemaHandler.getMatchingRule(substringName);
            if (substringMatchingRule == null) {
                throw new DependencyComputerException(NLS.bind((String)Messages.getString("DependenciesComputer.Substring"), (Object[])new String[]{substringName}));
            }
            this.attributeTypesDependencies.put((Object)attributeType, (Object)substringMatchingRule);
            this.computeSchemaDependency(schema, (SchemaObject)substringMatchingRule);
        }
    }

    private void computeDependencies(Schema schema, ObjectClassImpl objectClass) throws DependencyComputerException {
        String[] mandatoryAttributeTypes;
        String[] optionalAttributeTypes;
        String[] superClassesNames = objectClass.getSuperClassesNames();
        if (superClassesNames != null) {
            for (String superClassName : superClassesNames) {
                ObjectClassImpl superObjectClass = this.schemaHandler.getObjectClass(superClassName);
                if (superObjectClass == null) {
                    throw new DependencyComputerException(NLS.bind((String)Messages.getString("DependenciesComputer.SuperiorObject"), (Object[])new String[]{superClassName}));
                }
                this.objectClassesDependencies.put((Object)objectClass, (Object)superObjectClass);
                this.computeSchemaDependency(schema, (SchemaObject)superObjectClass);
            }
        }
        if ((optionalAttributeTypes = objectClass.getMayNamesList()) != null) {
            for (String optionalAttributeTypeName : optionalAttributeTypes) {
                AttributeTypeImpl optionalAttributeType = this.schemaHandler.getAttributeType(optionalAttributeTypeName);
                if (optionalAttributeType == null) {
                    throw new DependencyComputerException(NLS.bind((String)Messages.getString("DependenciesComputer.Optional"), (Object[])new Object[]{optionalAttributeType}));
                }
                this.objectClassesDependencies.put((Object)objectClass, (Object)optionalAttributeType);
                this.computeSchemaDependency(schema, (SchemaObject)optionalAttributeType);
            }
        }
        if ((mandatoryAttributeTypes = objectClass.getMustNamesList()) != null) {
            for (String mandatoryAttributeTypeName : mandatoryAttributeTypes) {
                AttributeTypeImpl mandatoryAttributeType = this.schemaHandler.getAttributeType(mandatoryAttributeTypeName);
                if (mandatoryAttributeType == null) {
                    throw new DependencyComputerException(NLS.bind((String)Messages.getString("DependenciesComputer.Mandatory"), (Object[])new String[]{mandatoryAttributeTypeName}));
                }
                this.objectClassesDependencies.put((Object)objectClass, (Object)mandatoryAttributeType);
                this.computeSchemaDependency(schema, (SchemaObject)mandatoryAttributeType);
            }
        }
    }

    private void computeSchemaDependency(Schema schema, SchemaObject object) throws DependencyComputerException {
        String schemaName = object.getSchema();
        if (!schemaName.equalsIgnoreCase(schema.getName())) {
            Schema schemaFromSuperiorAT = this.schemaHandler.getSchema(schemaName);
            if (schemaFromSuperiorAT == null) {
                throw new DependencyComputerException(NLS.bind((String)Messages.getString("DependenciesComputer.Schema"), (Object[])new String[]{schemaName}));
            }
            this.schemasDependencies.put((Object)schema, (Object)schemaFromSuperiorAT);
        }
    }

    private void orderSchemasBasedOnDependencies() {
        this.dependencyOrderedSchemasList = new ArrayList<Schema>();
        int counter = 0;
        block0: while (this.dependencyOrderedSchemasList.size() != this.schemasList.size()) {
            Schema schema = this.schemasList.get(counter);
            if (!this.dependencyOrderedSchemasList.contains(schema)) {
                List<Schema> dependencies = this.getDependencies(schema);
                if (dependencies == null) {
                    this.dependencyOrderedSchemasList.add(schema);
                } else {
                    for (Schema dependency : dependencies) {
                        if (this.dependencyOrderedSchemasList.contains(dependency)) continue;
                        ++counter;
                        counter %= this.schemasList.size();
                        continue block0;
                    }
                    this.dependencyOrderedSchemasList.add(schema);
                }
            }
            ++counter;
            counter %= this.schemasList.size();
        }
    }

    public List<Schema> getDependencies(Schema schema) {
        List dependencies = (List)this.schemasDependencies.get((Object)schema);
        HashSet set = new HashSet();
        if (dependencies != null) {
            set.addAll(dependencies);
        }
        return Arrays.asList(set.toArray(new Schema[0]));
    }

    public List<Schema> getDependencyOrderedSchemasList() {
        return this.dependencyOrderedSchemasList;
    }

    public MultiMap getSchemasDependencies() {
        return this.schemasDependencies;
    }

    public MultiMap getAttributeTypesDependencies() {
        return this.attributeTypesDependencies;
    }

    public MultiMap getObjectClassesDependencies() {
        return this.objectClassesDependencies;
    }

    public class DependencyComputerException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public DependencyComputerException(String message) {
            super(message);
        }
    }
}

