/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.controller.actions;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.directory.shared.ldap.schema.MutableSchemaObject;
import org.apache.directory.shared.ldap.schema.SchemaObject;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.PluginConstants;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandler;
import org.apache.directory.studio.schemaeditor.controller.actions.Messages;
import org.apache.directory.studio.schemaeditor.model.AttributeTypeImpl;
import org.apache.directory.studio.schemaeditor.model.ObjectClassImpl;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.view.wrappers.AttributeTypeWrapper;
import org.apache.directory.studio.schemaeditor.view.wrappers.ObjectClassWrapper;
import org.apache.directory.studio.schemaeditor.view.wrappers.SchemaWrapper;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class DeleteSchemaElementAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private TreeViewer viewer;

    public DeleteSchemaElementAction(TreeViewer viewer) {
        super(Messages.getString("DeleteSchemaElementAction.DeleteAction"));
        this.setToolTipText(Messages.getString("DeleteSchemaElementAction.DeleteToolTip"));
        this.setId(PluginConstants.CMD_DELETE_SCHEMA_ELEMENT);
        this.setActionDefinitionId(PluginConstants.CMD_DELETE_SCHEMA_ELEMENT);
        this.setImageDescriptor(Activator.getDefault().getImageDescriptor("resources/icons/delete.gif"));
        this.setEnabled(true);
        this.viewer = viewer;
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                if (selection.size() > 0) {
                    boolean enabled = false;
                    for (Object selectedItem : selection) {
                        if (selectedItem instanceof SchemaWrapper) {
                            enabled = true;
                            continue;
                        }
                        if (selectedItem instanceof AttributeTypeWrapper) {
                            enabled = true;
                            continue;
                        }
                        if (!(selectedItem instanceof ObjectClassWrapper)) continue;
                        enabled = true;
                    }
                    DeleteSchemaElementAction.this.setEnabled(enabled);
                } else {
                    DeleteSchemaElementAction.this.setEnabled(false);
                }
            }
        });
    }

    public void run() {
        StructuredSelection selection = (StructuredSelection)this.viewer.getSelection();
        if (!selection.isEmpty()) {
            MessageBox messageBox = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 196);
            int count = selection.size();
            if (count == 1) {
                Object firstElement = selection.getFirstElement();
                if (firstElement instanceof AttributeTypeWrapper) {
                    messageBox.setMessage(Messages.getString("DeleteSchemaElementAction.SureToDeleteAttributeType"));
                } else if (firstElement instanceof ObjectClassWrapper) {
                    messageBox.setMessage(Messages.getString("DeleteSchemaElementAction.SureToDeleteObjectClass"));
                } else if (firstElement instanceof SchemaWrapper) {
                    messageBox.setMessage(Messages.getString("DeleteSchemaElementAction.SureToDeleteSchema"));
                } else {
                    messageBox.setMessage(Messages.getString("DeleteSchemaElementAction.SureToDeleteItem"));
                }
            } else {
                messageBox.setMessage(NLS.bind((String)Messages.getString("DeleteSchemaElementAction.SureToDeleteItems"), (Object[])new Object[]{count}));
            }
            if (messageBox.open() == 64) {
                HashMap<String, Schema> schemasMap = new HashMap<String, Schema>();
                ArrayList<MutableSchemaObject> schemaObjectsList = new ArrayList<MutableSchemaObject>();
                for (Object selectedItem : selection) {
                    if (selectedItem instanceof SchemaWrapper) {
                        Schema schema = ((SchemaWrapper)selectedItem).getSchema();
                        schemasMap.put(schema.getName().toLowerCase(), schema);
                        continue;
                    }
                    if (selectedItem instanceof AttributeTypeWrapper) {
                        AttributeTypeImpl attributeTypeImpl = ((AttributeTypeWrapper)selectedItem).getAttributeType();
                        schemaObjectsList.add(attributeTypeImpl);
                        continue;
                    }
                    if (!(selectedItem instanceof ObjectClassWrapper)) continue;
                    ObjectClassImpl objectClassImpl = ((ObjectClassWrapper)selectedItem).getObjectClass();
                    schemaObjectsList.add(objectClassImpl);
                }
                SchemaHandler schemaHandler = Activator.getDefault().getSchemaHandler();
                for (SchemaObject schemaObject : schemaObjectsList) {
                    if (schemasMap.containsKey(schemaObject.getSchema().toLowerCase())) continue;
                    if (schemaObject instanceof AttributeTypeImpl) {
                        schemaHandler.removeAttributeType((AttributeTypeImpl)schemaObject);
                        continue;
                    }
                    if (!(schemaObject instanceof ObjectClassImpl)) continue;
                    schemaHandler.removeObjectClass((ObjectClassImpl)schemaObject);
                }
                for (Schema schema : schemasMap.values()) {
                    schemaHandler.removeSchema(schema);
                }
            }
        }
    }

    public void run(IAction action) {
        this.run();
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

