/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.controller.actions;

import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.PluginConstants;
import org.apache.directory.studio.schemaeditor.controller.ProjectsHandler;
import org.apache.directory.studio.schemaeditor.controller.actions.Messages;
import org.apache.directory.studio.schemaeditor.model.Project;
import org.apache.directory.studio.schemaeditor.view.wrappers.ProjectWrapper;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class DeleteProjectAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private TableViewer viewer;

    public DeleteProjectAction(TableViewer viewer) {
        super(Messages.getString("DeleteProjectAction.DeleteProjectAction"));
        this.setToolTipText(Messages.getString("DeleteProjectAction.DeleteProjectToolTip"));
        this.setId(PluginConstants.CMD_DELETE_PROJECT);
        this.setActionDefinitionId(PluginConstants.CMD_DELETE_PROJECT);
        this.setImageDescriptor(Activator.getDefault().getImageDescriptor("resources/icons/delete.gif"));
        this.setEnabled(false);
        this.viewer = viewer;
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                if (selection.size() == 1) {
                    DeleteProjectAction.this.setText(Messages.getString("DeleteProjectAction.DeleteProjectAction"));
                    DeleteProjectAction.this.setEnabled(true);
                } else if (selection.size() > 1) {
                    DeleteProjectAction.this.setText(Messages.getString("DeleteProjectAction.DeleteProjectsAction"));
                    DeleteProjectAction.this.setEnabled(true);
                } else {
                    DeleteProjectAction.this.setText(Messages.getString("DeleteProjectAction.DeleteProjectAction"));
                    DeleteProjectAction.this.setEnabled(false);
                }
            }
        });
    }

    public void run() {
        ProjectsHandler projectsHandler = Activator.getDefault().getProjectsHandler();
        StructuredSelection selection = (StructuredSelection)this.viewer.getSelection();
        if (!selection.isEmpty()) {
            MessageBox messageBox = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 196);
            int count = selection.size();
            if (count == 1) {
                ProjectWrapper wrapper = (ProjectWrapper)selection.getFirstElement();
                messageBox.setMessage(NLS.bind((String)Messages.getString("DeleteProjectAction.SureToDeleteProject"), (Object[])new String[]{wrapper.getProject().getName()}));
            } else {
                messageBox.setMessage(NLS.bind((String)Messages.getString("DeleteProjectAction.SureToDeleteProjects"), (Object[])new Object[]{count}));
            }
            if (messageBox.open() == 64) {
                for (ProjectWrapper wrapper : selection) {
                    Project project = wrapper.getProject();
                    if (project.getState() == Project.ProjectState.OPEN) {
                        projectsHandler.closeProject(project);
                    }
                    projectsHandler.removeProject(project);
                }
            }
        }
    }

    public void run(IAction action) {
        this.run();
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

