/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.controller.actions;

import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.controller.ProjectsHandler;
import org.apache.directory.studio.schemaeditor.controller.ProjectsHandlerAdapter;
import org.apache.directory.studio.schemaeditor.controller.actions.Messages;
import org.apache.directory.studio.schemaeditor.model.Project;
import org.apache.directory.studio.schemaeditor.view.wrappers.ProjectWrapper;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class CloseProjectAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private TableViewer viewer;
    private ProjectsHandler projectsHandler;

    public CloseProjectAction(TableViewer viewer) {
        super(Messages.getString("CloseProjectAction.CloseProjectAction"));
        this.setToolTipText(Messages.getString("CloseProjectAction.CloseProjectToolTip"));
        this.setEnabled(false);
        this.viewer = viewer;
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CloseProjectAction.this.enableDisable();
            }
        });
        this.projectsHandler = Activator.getDefault().getProjectsHandler();
        this.projectsHandler.addListener(new ProjectsHandlerAdapter(){

            public void openProjectChanged(Project oldProject, Project newProject) {
                CloseProjectAction.this.enableDisable();
            }
        });
    }

    private void enableDisable() {
        StructuredSelection selection = (StructuredSelection)this.viewer.getSelection();
        if (!selection.isEmpty() && selection.size() == 1) {
            this.setEnabled(((ProjectWrapper)selection.getFirstElement()).getProject().getState().equals((Object)Project.ProjectState.OPEN));
        } else {
            this.setEnabled(false);
        }
    }

    public void run() {
        StructuredSelection selection = (StructuredSelection)this.viewer.getSelection();
        if (!selection.isEmpty() && selection.size() == 1) {
            this.projectsHandler.closeProject(((ProjectWrapper)selection.getFirstElement()).getProject());
        }
    }

    public void run(IAction action) {
        this.run();
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

