/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.controller;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.PluginConstants;
import org.apache.directory.studio.schemaeditor.PluginUtils;
import org.apache.directory.studio.schemaeditor.controller.Messages;
import org.apache.directory.studio.schemaeditor.controller.ProjectsHandlerAdapter;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandler;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandlerAdapter;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandlerListener;
import org.apache.directory.studio.schemaeditor.controller.actions.CollapseAllAction;
import org.apache.directory.studio.schemaeditor.controller.actions.DeleteSchemaElementAction;
import org.apache.directory.studio.schemaeditor.controller.actions.ExportSchemasAsOpenLdapAction;
import org.apache.directory.studio.schemaeditor.controller.actions.ExportSchemasAsXmlAction;
import org.apache.directory.studio.schemaeditor.controller.actions.ExportSchemasForADSAction;
import org.apache.directory.studio.schemaeditor.controller.actions.ImportCoreSchemasAction;
import org.apache.directory.studio.schemaeditor.controller.actions.ImportSchemasFromOpenLdapAction;
import org.apache.directory.studio.schemaeditor.controller.actions.ImportSchemasFromXmlAction;
import org.apache.directory.studio.schemaeditor.controller.actions.LinkWithEditorSchemaViewAction;
import org.apache.directory.studio.schemaeditor.controller.actions.MergeSchemasAction;
import org.apache.directory.studio.schemaeditor.controller.actions.NewAttributeTypeAction;
import org.apache.directory.studio.schemaeditor.controller.actions.NewObjectClassAction;
import org.apache.directory.studio.schemaeditor.controller.actions.NewSchemaAction;
import org.apache.directory.studio.schemaeditor.controller.actions.OpenElementAction;
import org.apache.directory.studio.schemaeditor.controller.actions.OpenSchemaViewPreferenceAction;
import org.apache.directory.studio.schemaeditor.controller.actions.OpenSchemaViewSortingDialogAction;
import org.apache.directory.studio.schemaeditor.controller.actions.OpenTypeHierarchyAction;
import org.apache.directory.studio.schemaeditor.controller.actions.SwitchSchemaPresentationToFlatAction;
import org.apache.directory.studio.schemaeditor.controller.actions.SwitchSchemaPresentationToHierarchicalAction;
import org.apache.directory.studio.schemaeditor.model.AttributeTypeImpl;
import org.apache.directory.studio.schemaeditor.model.ObjectClassImpl;
import org.apache.directory.studio.schemaeditor.model.Project;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.view.ViewUtils;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.AttributeTypeEditor;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.AttributeTypeEditorInput;
import org.apache.directory.studio.schemaeditor.view.editors.objectclass.ObjectClassEditor;
import org.apache.directory.studio.schemaeditor.view.editors.objectclass.ObjectClassEditorInput;
import org.apache.directory.studio.schemaeditor.view.views.SchemaView;
import org.apache.directory.studio.schemaeditor.view.views.SchemaViewContentProvider;
import org.apache.directory.studio.schemaeditor.view.wrappers.AttributeTypeWrapper;
import org.apache.directory.studio.schemaeditor.view.wrappers.Folder;
import org.apache.directory.studio.schemaeditor.view.wrappers.ObjectClassWrapper;
import org.apache.directory.studio.schemaeditor.view.wrappers.SchemaWrapper;
import org.apache.directory.studio.schemaeditor.view.wrappers.TreeNode;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;

public class SchemaViewController {
    private SchemaView view;
    private TreeViewer viewer;
    private List<String> authorizedPrefs;
    private MenuManager contextMenu;
    private SchemaHandlerListener schemaHandlerListener = new SchemaHandlerAdapter(){

        public void attributeTypeAdded(AttributeTypeImpl at) {
            SchemaViewContentProvider contentProvider = (SchemaViewContentProvider)SchemaViewController.this.viewer.getContentProvider();
            contentProvider.attributeTypeAdded(at);
            SchemaViewController.this.view.refresh();
            TreeNode wrapper = contentProvider.getWrapper((Object)at);
            if (wrapper != null) {
                SchemaViewController.this.viewer.setSelection((ISelection)new StructuredSelection((Object)wrapper));
            }
        }

        public void attributeTypeModified(AttributeTypeImpl at) {
            ((SchemaViewContentProvider)SchemaViewController.this.viewer.getContentProvider()).attributeTypeModified(at);
            SchemaViewController.this.view.refresh();
        }

        public void attributeTypeRemoved(AttributeTypeImpl at) {
            ((SchemaViewContentProvider)SchemaViewController.this.viewer.getContentProvider()).attributeTypeRemoved(at);
            SchemaViewController.this.view.refresh();
        }

        public void objectClassAdded(ObjectClassImpl oc) {
            SchemaViewContentProvider contentProvider = (SchemaViewContentProvider)SchemaViewController.this.viewer.getContentProvider();
            contentProvider.objectClassAdded(oc);
            SchemaViewController.this.view.refresh();
            TreeNode wrapper = contentProvider.getWrapper((Object)oc);
            if (wrapper != null) {
                SchemaViewController.this.viewer.setSelection((ISelection)new StructuredSelection((Object)wrapper));
            }
        }

        public void objectClassModified(ObjectClassImpl oc) {
            ((SchemaViewContentProvider)SchemaViewController.this.viewer.getContentProvider()).objectClassModified(oc);
            SchemaViewController.this.view.refresh();
        }

        public void objectClassRemoved(ObjectClassImpl oc) {
            ((SchemaViewContentProvider)SchemaViewController.this.viewer.getContentProvider()).objectClassRemoved(oc);
            SchemaViewController.this.view.refresh();
        }

        public void schemaAdded(Schema schema) {
            SchemaViewContentProvider contentProvider = (SchemaViewContentProvider)SchemaViewController.this.viewer.getContentProvider();
            contentProvider.schemaAdded(schema);
            final TreeNode wrapper = contentProvider.getWrapper(schema);
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    SchemaViewController.this.view.refresh();
                    if (wrapper != null) {
                        SchemaViewController.this.viewer.setSelection((ISelection)new StructuredSelection((Object)wrapper));
                    }
                }
            });
        }

        public void schemaRemoved(Schema schema) {
            ((SchemaViewContentProvider)SchemaViewController.this.viewer.getContentProvider()).schemaRemoved(schema);
            SchemaViewController.this.view.refresh();
        }
    };
    private IContextActivation contextActivation;
    private NewSchemaAction newSchema;
    private NewAttributeTypeAction newAttributeType;
    private NewObjectClassAction newObjectClass;
    private OpenElementAction openElement;
    private OpenTypeHierarchyAction openTypeHierarchy;
    private DeleteSchemaElementAction deleteSchemaElement;
    private ImportCoreSchemasAction importCoreSchemas;
    private ImportSchemasFromOpenLdapAction importSchemasFromOpenLdap;
    private ImportSchemasFromXmlAction importSchemasFromXml;
    private ExportSchemasAsOpenLdapAction exportSchemasAsOpenLdap;
    private ExportSchemasAsXmlAction exportSchemasAsXml;
    private ExportSchemasForADSAction exportSchemasForADS;
    private CollapseAllAction collapseAll;
    private OpenSchemaViewSortingDialogAction openSchemaViewSortingDialog;
    private SwitchSchemaPresentationToFlatAction switchSchemaPresentationToFlat;
    private SwitchSchemaPresentationToHierarchicalAction switchSchemaPresentationToHierarchical;
    private OpenSchemaViewPreferenceAction openSchemaViewPreference;
    private LinkWithEditorSchemaViewAction linkWithEditor;
    private MergeSchemasAction mergeSchema;

    public SchemaViewController(SchemaView view) {
        this.view = view;
        this.viewer = view.getViewer();
        this.initActions();
        this.initToolbar();
        this.initMenu();
        this.initContextMenu();
        this.initProjectsHandlerListener();
        this.initDoubleClickListener();
        this.initAuthorizedPrefs();
        this.initPreferencesListener();
        this.initState();
        this.initPartListener();
    }

    private void initActions() {
        this.newSchema = new NewSchemaAction();
        this.newAttributeType = new NewAttributeTypeAction(this.viewer);
        this.newObjectClass = new NewObjectClassAction(this.viewer);
        this.openElement = new OpenElementAction(this.viewer);
        this.openTypeHierarchy = new OpenTypeHierarchyAction(this.viewer);
        this.deleteSchemaElement = new DeleteSchemaElementAction(this.viewer);
        this.importCoreSchemas = new ImportCoreSchemasAction();
        this.importSchemasFromOpenLdap = new ImportSchemasFromOpenLdapAction();
        this.importSchemasFromXml = new ImportSchemasFromXmlAction();
        this.exportSchemasAsOpenLdap = new ExportSchemasAsOpenLdapAction(this.viewer);
        this.exportSchemasAsXml = new ExportSchemasAsXmlAction(this.viewer);
        this.exportSchemasForADS = new ExportSchemasForADSAction(this.viewer);
        this.collapseAll = new CollapseAllAction(this.viewer);
        this.openSchemaViewSortingDialog = new OpenSchemaViewSortingDialogAction();
        this.switchSchemaPresentationToFlat = new SwitchSchemaPresentationToFlatAction();
        this.switchSchemaPresentationToHierarchical = new SwitchSchemaPresentationToHierarchicalAction();
        this.openSchemaViewPreference = new OpenSchemaViewPreferenceAction();
        this.linkWithEditor = new LinkWithEditorSchemaViewAction(this.view);
        this.mergeSchema = new MergeSchemasAction();
    }

    private void initToolbar() {
        IToolBarManager toolbar = this.view.getViewSite().getActionBars().getToolBarManager();
        toolbar.add((IAction)this.newSchema);
        toolbar.add((IAction)this.newAttributeType);
        toolbar.add((IAction)this.newObjectClass);
        toolbar.add((IContributionItem)new Separator());
        toolbar.add((IAction)this.collapseAll);
        toolbar.add((IAction)this.linkWithEditor);
    }

    private void initMenu() {
        IMenuManager menu = this.view.getViewSite().getActionBars().getMenuManager();
        menu.add((IAction)this.openSchemaViewSortingDialog);
        menu.add((IContributionItem)new Separator());
        MenuManager schemaPresentationMenu = new MenuManager(Messages.getString("SchemaViewController.SchemaPresentationAction"));
        schemaPresentationMenu.add((IAction)this.switchSchemaPresentationToFlat);
        schemaPresentationMenu.add((IAction)this.switchSchemaPresentationToHierarchical);
        menu.add((IContributionItem)schemaPresentationMenu);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.linkWithEditor);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.openSchemaViewPreference);
    }

    private void initContextMenu() {
        this.contextMenu = new MenuManager("");
        this.contextMenu.setRemoveAllWhenShown(true);
        this.contextMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                MenuManager newManager = new MenuManager(Messages.getString("SchemaViewController.NewAction"));
                MenuManager importManager = new MenuManager(Messages.getString("SchemaViewController.ImportAction"));
                MenuManager exportManager = new MenuManager(Messages.getString("SchemaViewController.ExportAction"));
                manager.add((IContributionItem)newManager);
                newManager.add((IAction)SchemaViewController.this.newSchema);
                newManager.add((IAction)SchemaViewController.this.newAttributeType);
                newManager.add((IAction)SchemaViewController.this.newObjectClass);
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)SchemaViewController.this.openElement);
                manager.add((IAction)SchemaViewController.this.openTypeHierarchy);
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)SchemaViewController.this.deleteSchemaElement);
                manager.add((IContributionItem)new Separator());
                manager.add((IContributionItem)importManager);
                importManager.add((IAction)SchemaViewController.this.importCoreSchemas);
                importManager.add((IContributionItem)new Separator());
                importManager.add((IAction)SchemaViewController.this.importSchemasFromOpenLdap);
                importManager.add((IAction)SchemaViewController.this.importSchemasFromXml);
                importManager.add((IContributionItem)new Separator());
                importManager.add((IAction)SchemaViewController.this.mergeSchema);
                manager.add((IContributionItem)exportManager);
                exportManager.add((IAction)SchemaViewController.this.exportSchemasAsOpenLdap);
                exportManager.add((IAction)SchemaViewController.this.exportSchemasAsXml);
                exportManager.add((IContributionItem)new Separator());
                exportManager.add((IAction)SchemaViewController.this.exportSchemasForADS);
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        this.viewer.getControl().setMenu(this.contextMenu.createContextMenu(this.viewer.getControl()));
        this.view.getSite().registerContextMenu(this.contextMenu, (ISelectionProvider)this.viewer);
    }

    private void initProjectsHandlerListener() {
        Activator.getDefault().getProjectsHandler().addListener(new ProjectsHandlerAdapter(){

            public void openProjectChanged(Project oldProject, Project newProject) {
                if (oldProject != null) {
                    SchemaViewController.this.removeSchemaHandlerListener(oldProject);
                }
                if (newProject != null) {
                    SchemaViewController.this.viewer.getTree().setEnabled(true);
                    SchemaViewController.this.newSchema.setEnabled(true);
                    SchemaViewController.this.newAttributeType.setEnabled(true);
                    SchemaViewController.this.newObjectClass.setEnabled(true);
                    SchemaViewController.this.collapseAll.setEnabled(true);
                    SchemaViewController.this.linkWithEditor.setEnabled(true);
                    SchemaViewController.this.openSchemaViewSortingDialog.setEnabled(true);
                    SchemaViewController.this.switchSchemaPresentationToFlat.setEnabled(true);
                    SchemaViewController.this.switchSchemaPresentationToHierarchical.setEnabled(true);
                    SchemaViewController.this.openSchemaViewPreference.setEnabled(true);
                    SchemaViewController.this.addSchemaHandlerListener(newProject);
                    SchemaViewController.this.view.reloadViewer();
                } else {
                    SchemaViewController.this.viewer.setInput(null);
                    SchemaViewController.this.viewer.getTree().setEnabled(false);
                    SchemaViewController.this.newSchema.setEnabled(false);
                    SchemaViewController.this.newAttributeType.setEnabled(false);
                    SchemaViewController.this.newObjectClass.setEnabled(false);
                    SchemaViewController.this.collapseAll.setEnabled(false);
                    SchemaViewController.this.linkWithEditor.setEnabled(false);
                    SchemaViewController.this.openSchemaViewSortingDialog.setEnabled(false);
                    SchemaViewController.this.switchSchemaPresentationToFlat.setEnabled(false);
                    SchemaViewController.this.switchSchemaPresentationToHierarchical.setEnabled(false);
                    SchemaViewController.this.openSchemaViewPreference.setEnabled(false);
                }
            }
        });
    }

    private void addSchemaHandlerListener(Project project) {
        SchemaHandler schemaHandler = project.getSchemaHandler();
        if (schemaHandler != null) {
            schemaHandler.addListener(this.schemaHandlerListener);
        }
    }

    private void removeSchemaHandlerListener(Project project) {
        SchemaHandler schemaHandler = project.getSchemaHandler();
        if (schemaHandler != null) {
            schemaHandler.removeListener(this.schemaHandlerListener);
        }
    }

    private void initDoubleClickListener() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                TreeViewer viewer = SchemaViewController.this.view.getViewer();
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                Object objectSelection = selection.getFirstElement();
                Object input = null;
                String editorId = null;
                if (objectSelection instanceof AttributeTypeWrapper) {
                    input = new AttributeTypeEditorInput(((AttributeTypeWrapper)objectSelection).getAttributeType());
                    editorId = AttributeTypeEditor.ID;
                } else if (objectSelection instanceof ObjectClassWrapper) {
                    input = new ObjectClassEditorInput(((ObjectClassWrapper)objectSelection).getObjectClass());
                    editorId = ObjectClassEditor.ID;
                } else if (objectSelection instanceof Folder || objectSelection instanceof SchemaWrapper) {
                    viewer.setExpandedState(objectSelection, !viewer.getExpandedState(objectSelection));
                }
                if (input != null) {
                    try {
                        page.openEditor((IEditorInput)input, editorId);
                    }
                    catch (PartInitException e) {
                        PluginUtils.logError(Messages.getString("SchemaViewController.ErrorOpeningEditor"), e);
                        ViewUtils.displayErrorMessageBox(Messages.getString("SchemaViewController.error"), Messages.getString("SchemaViewController.ErrorOpeningEditor"));
                    }
                }
            }
        });
    }

    private void initAuthorizedPrefs() {
        this.authorizedPrefs = new ArrayList<String>();
        this.authorizedPrefs.add(PluginConstants.PREFS_SCHEMA_VIEW_LABEL);
        this.authorizedPrefs.add(PluginConstants.PREFS_SCHEMA_VIEW_ABBREVIATE);
        this.authorizedPrefs.add(PluginConstants.PREFS_SCHEMA_VIEW_ABBREVIATE_MAX_LENGTH);
        this.authorizedPrefs.add(PluginConstants.PREFS_SCHEMA_VIEW_SECONDARY_LABEL_DISPLAY);
        this.authorizedPrefs.add(PluginConstants.PREFS_SCHEMA_VIEW_SECONDARY_LABEL);
        this.authorizedPrefs.add(PluginConstants.PREFS_SCHEMA_VIEW_SECONDARY_LABEL_ABBREVIATE);
        this.authorizedPrefs.add(PluginConstants.PREFS_SCHEMA_VIEW_SECONDARY_LABEL_ABBREVIATE_MAX_LENGTH);
        this.authorizedPrefs.add(PluginConstants.PREFS_SCHEMA_VIEW_GROUPING);
        this.authorizedPrefs.add(PluginConstants.PREFS_SCHEMA_VIEW_SORTING_BY);
        this.authorizedPrefs.add(PluginConstants.PREFS_SCHEMA_VIEW_SORTING_ORDER);
        this.authorizedPrefs.add(PluginConstants.PREFS_SCHEMA_VIEW_SCHEMA_PRESENTATION);
        this.authorizedPrefs.add(PluginConstants.PREFS_SCHEMA_VIEW_SCHEMA_LABEL_DISPLAY);
    }

    private void initPreferencesListener() {
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (SchemaViewController.this.authorizedPrefs.contains(event.getProperty())) {
                    if (PluginConstants.PREFS_SCHEMA_VIEW_GROUPING.equals(event.getProperty()) || PluginConstants.PREFS_SCHEMA_VIEW_SCHEMA_PRESENTATION.equals(event.getProperty())) {
                        SchemaViewController.this.view.reloadViewer();
                    } else {
                        SchemaViewController.this.view.refresh();
                    }
                }
            }
        });
    }

    private void initState() {
        Project project = Activator.getDefault().getProjectsHandler().getOpenProject();
        if (project != null) {
            this.viewer.getTree().setEnabled(true);
            this.newSchema.setEnabled(true);
            this.newAttributeType.setEnabled(true);
            this.newObjectClass.setEnabled(true);
            this.collapseAll.setEnabled(true);
            this.linkWithEditor.setEnabled(true);
            this.openSchemaViewSortingDialog.setEnabled(true);
            this.switchSchemaPresentationToFlat.setEnabled(true);
            this.switchSchemaPresentationToHierarchical.setEnabled(true);
            this.openSchemaViewPreference.setEnabled(true);
            this.addSchemaHandlerListener(project);
            this.view.reloadViewer();
        } else {
            this.viewer.getTree().setEnabled(false);
            this.newSchema.setEnabled(false);
            this.newAttributeType.setEnabled(false);
            this.newObjectClass.setEnabled(false);
            this.collapseAll.setEnabled(false);
            this.linkWithEditor.setEnabled(false);
            this.openSchemaViewSortingDialog.setEnabled(false);
            this.switchSchemaPresentationToFlat.setEnabled(false);
            this.switchSchemaPresentationToHierarchical.setEnabled(false);
            this.openSchemaViewPreference.setEnabled(false);
        }
    }

    private void initPartListener() {
        this.view.getSite().getPage().addPartListener(new IPartListener2(){

            public void partDeactivated(IWorkbenchPartReference partRef) {
                if (partRef.getPart(false) == SchemaViewController.this.view && SchemaViewController.this.contextActivation != null) {
                    ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getAdapter(ICommandService.class);
                    if (commandService != null) {
                        commandService.getCommand(SchemaViewController.this.newSchema.getActionDefinitionId()).setHandler(null);
                        commandService.getCommand(SchemaViewController.this.newAttributeType.getActionDefinitionId()).setHandler(null);
                        commandService.getCommand(SchemaViewController.this.newObjectClass.getActionDefinitionId()).setHandler(null);
                        commandService.getCommand(SchemaViewController.this.openElement.getActionDefinitionId()).setHandler(null);
                        commandService.getCommand(SchemaViewController.this.openTypeHierarchy.getActionDefinitionId()).setHandler(null);
                        commandService.getCommand(SchemaViewController.this.deleteSchemaElement.getActionDefinitionId()).setHandler(null);
                    }
                    IContextService contextService = (IContextService)PlatformUI.getWorkbench().getAdapter(IContextService.class);
                    contextService.deactivateContext(SchemaViewController.this.contextActivation);
                    SchemaViewController.this.contextActivation = null;
                }
            }

            public void partActivated(IWorkbenchPartReference partRef) {
                if (partRef.getPart(false) == SchemaViewController.this.view) {
                    IContextService contextService = (IContextService)PlatformUI.getWorkbench().getAdapter(IContextService.class);
                    SchemaViewController.this.contextActivation = contextService.activateContext(PluginConstants.CONTEXT_SCHEMA_VIEW);
                    ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getAdapter(ICommandService.class);
                    if (commandService != null) {
                        commandService.getCommand(SchemaViewController.this.newSchema.getActionDefinitionId()).setHandler((IHandler)new ActionHandler((IAction)SchemaViewController.this.newSchema));
                        commandService.getCommand(SchemaViewController.this.newAttributeType.getActionDefinitionId()).setHandler((IHandler)new ActionHandler((IAction)SchemaViewController.this.newAttributeType));
                        commandService.getCommand(SchemaViewController.this.newObjectClass.getActionDefinitionId()).setHandler((IHandler)new ActionHandler((IAction)SchemaViewController.this.newObjectClass));
                        commandService.getCommand(SchemaViewController.this.openElement.getActionDefinitionId()).setHandler((IHandler)new ActionHandler((IAction)SchemaViewController.this.openElement));
                        commandService.getCommand(SchemaViewController.this.openTypeHierarchy.getActionDefinitionId()).setHandler((IHandler)new ActionHandler((IAction)SchemaViewController.this.openTypeHierarchy));
                        commandService.getCommand(SchemaViewController.this.deleteSchemaElement.getActionDefinitionId()).setHandler((IHandler)new ActionHandler((IAction)SchemaViewController.this.deleteSchemaElement));
                    }
                }
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
            }

            public void partClosed(IWorkbenchPartReference partRef) {
            }

            public void partHidden(IWorkbenchPartReference partRef) {
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }

            public void partOpened(IWorkbenchPartReference partRef) {
            }

            public void partVisible(IWorkbenchPartReference partRef) {
            }
        });
    }
}

