/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.controller;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.directory.shared.ldap.schema.SchemaObject;
import org.apache.directory.studio.schemaeditor.controller.AttributeTypeListener;
import org.apache.directory.studio.schemaeditor.controller.ObjectClassListener;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandlerListener;
import org.apache.directory.studio.schemaeditor.controller.SchemaListener;
import org.apache.directory.studio.schemaeditor.model.AttributeTypeImpl;
import org.apache.directory.studio.schemaeditor.model.MatchingRuleImpl;
import org.apache.directory.studio.schemaeditor.model.ObjectClassImpl;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.model.SyntaxImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaHandler {
    private List<Schema> schemasList = new ArrayList<Schema>();
    private List<AttributeTypeImpl> attributeTypesList = new ArrayList<AttributeTypeImpl>();
    private List<MatchingRuleImpl> matchingRulesList = new ArrayList<MatchingRuleImpl>();
    private List<ObjectClassImpl> objectClassesList = new ArrayList<ObjectClassImpl>();
    private List<SyntaxImpl> syntaxesList = new ArrayList<SyntaxImpl>();
    private MultiMap schemasMap = new MultiValueMap();
    private MultiMap attributeTypesMap = new MultiValueMap();
    private MultiMap matchingRulesMap = new MultiValueMap();
    private MultiMap objectClassesMap = new MultiValueMap();
    private MultiMap syntaxesMap = new MultiValueMap();
    private List<SchemaHandlerListener> schemaHandlerListeners = new ArrayList<SchemaHandlerListener>();
    private MultiValueMap schemaListeners = new MultiValueMap();
    private MultiValueMap attributeTypeListeners = new MultiValueMap();
    private MultiValueMap objectClassListeners = new MultiValueMap();

    public List<AttributeTypeImpl> getAttributeTypes() {
        return this.attributeTypesList;
    }

    public List<MatchingRuleImpl> getMatchingRules() {
        return this.matchingRulesList;
    }

    public List<ObjectClassImpl> getObjectClasses() {
        return this.objectClassesList;
    }

    public List<Schema> getSchemas() {
        return this.schemasList;
    }

    public List<SyntaxImpl> getSyntaxes() {
        return this.syntaxesList;
    }

    public AttributeTypeImpl getAttributeType(String id) {
        List<?> list = this.getAttributeTypeList(id.toLowerCase());
        if (list != null && list.size() >= 1) {
            return (AttributeTypeImpl)((Object)list.get(0));
        }
        return null;
    }

    public List<?> getAttributeTypeList(String id) {
        return (List)this.attributeTypesMap.get((Object)id.toLowerCase());
    }

    public MatchingRuleImpl getMatchingRule(String id) {
        List<?> list = this.getMatchingRuleList(id.toLowerCase());
        if (list != null && list.size() >= 1) {
            return (MatchingRuleImpl)((Object)list.get(0));
        }
        return null;
    }

    public List<?> getMatchingRuleList(String id) {
        return (List)this.matchingRulesMap.get((Object)id.toLowerCase());
    }

    public ObjectClassImpl getObjectClass(String id) {
        List<?> list = this.getObjectClassList(id.toLowerCase());
        if (list != null && list.size() >= 1) {
            return (ObjectClassImpl)((Object)list.get(0));
        }
        return null;
    }

    public List<?> getObjectClassList(String id) {
        return (List)this.objectClassesMap.get((Object)id.toLowerCase());
    }

    public Schema getSchema(String name) {
        List<?> list = this.getSchemaList(name.toLowerCase());
        if (list != null && list.size() >= 1) {
            return (Schema)list.get(0);
        }
        return null;
    }

    public List<?> getSchemaList(String name) {
        return (List)this.schemasMap.get((Object)name.toLowerCase());
    }

    public SyntaxImpl getSyntax(String id) {
        List<?> list = this.getSyntaxList(id.toLowerCase());
        if (list != null && list.size() >= 1) {
            return (SyntaxImpl)((Object)list.get(0));
        }
        return null;
    }

    public List<?> getSyntaxList(String id) {
        return (List)this.syntaxesMap.get((Object)id.toLowerCase());
    }

    public void addListener(SchemaHandlerListener listener) {
        if (!this.schemaHandlerListeners.contains(listener)) {
            this.schemaHandlerListeners.add(listener);
        }
    }

    public void removeListener(SchemaHandlerListener listener) {
        this.schemaHandlerListeners.remove(listener);
    }

    public void addListener(Schema schema, SchemaListener listener) {
        if (!this.schemaListeners.containsValue((Object)schema, (Object)listener)) {
            this.schemaListeners.put((Object)schema, (Object)listener);
        }
    }

    public void removeListener(Schema schema, SchemaListener listener) {
        this.schemaListeners.remove((Object)schema, (Object)listener);
    }

    public void addListener(AttributeTypeImpl at, AttributeTypeListener listener) {
        if (!this.attributeTypeListeners.containsValue((Object)at, (Object)listener)) {
            this.attributeTypeListeners.put((Object)at, (Object)listener);
        }
    }

    public void removeListener(AttributeTypeImpl at, AttributeTypeListener listener) {
        this.attributeTypeListeners.remove((Object)at, (Object)listener);
    }

    public void addListener(ObjectClassImpl oc, ObjectClassListener listener) {
        if (!this.objectClassListeners.containsValue((Object)oc, (Object)listener)) {
            this.objectClassListeners.put((Object)oc, (Object)listener);
        }
    }

    public void removeListener(ObjectClassImpl oc, ObjectClassListener listener) {
        this.objectClassListeners.remove((Object)oc, (Object)listener);
    }

    public void addSchema(Schema schema) {
        this.schemasList.add(schema);
        this.schemasMap.put((Object)schema.getName().toLowerCase(), (Object)schema);
        for (AttributeTypeImpl at : schema.getAttributeTypes()) {
            this.addSchemaObject((SchemaObject)at);
        }
        for (MatchingRuleImpl mr : schema.getMatchingRules()) {
            this.addSchemaObject((SchemaObject)mr);
        }
        for (ObjectClassImpl oc : schema.getObjectClasses()) {
            this.addSchemaObject((SchemaObject)oc);
        }
        for (SyntaxImpl syntax : schema.getSyntaxes()) {
            this.addSchemaObject((SchemaObject)syntax);
        }
        this.notifySchemaAdded(schema);
    }

    private void addSchemaObject(SchemaObject object) {
        if (object instanceof AttributeTypeImpl) {
            AttributeTypeImpl at = (AttributeTypeImpl)object;
            this.attributeTypesList.add(at);
            String[] names = at.getNamesRef();
            if (names != null) {
                for (String name : names) {
                    this.attributeTypesMap.put((Object)name.toLowerCase(), (Object)at);
                }
            }
            this.attributeTypesMap.put((Object)at.getOid(), (Object)at);
        } else if (object instanceof MatchingRuleImpl) {
            MatchingRuleImpl mr = (MatchingRuleImpl)object;
            this.matchingRulesList.add(mr);
            String[] names = mr.getNamesRef();
            if (names != null) {
                for (String name : names) {
                    this.matchingRulesMap.put((Object)name.toLowerCase(), (Object)mr);
                }
            }
            this.matchingRulesMap.put((Object)mr.getOid(), (Object)mr);
        } else if (object instanceof ObjectClassImpl) {
            ObjectClassImpl oc = (ObjectClassImpl)object;
            this.objectClassesList.add(oc);
            String[] names = oc.getNamesRef();
            if (names != null) {
                for (String name : names) {
                    this.objectClassesMap.put((Object)name.toLowerCase(), (Object)oc);
                }
            }
            this.objectClassesMap.put((Object)oc.getOid(), (Object)oc);
        } else if (object instanceof SyntaxImpl) {
            SyntaxImpl syntax = (SyntaxImpl)object;
            this.syntaxesList.add(syntax);
            String[] names = syntax.getNamesRef();
            if (names != null) {
                for (String name : names) {
                    this.syntaxesMap.put((Object)name.toLowerCase(), (Object)syntax);
                }
            }
            this.syntaxesMap.put((Object)syntax.getOid(), (Object)syntax);
        }
    }

    public void removeSchema(Schema schema) {
        this.schemasList.remove(schema);
        this.schemasMap.remove((Object)schema.getName().toLowerCase());
        for (AttributeTypeImpl at : schema.getAttributeTypes()) {
            this.removeSchemaObject((SchemaObject)at);
        }
        for (MatchingRuleImpl mr : schema.getMatchingRules()) {
            this.removeSchemaObject((SchemaObject)mr);
        }
        for (ObjectClassImpl oc : schema.getObjectClasses()) {
            this.removeSchemaObject((SchemaObject)oc);
        }
        for (SyntaxImpl syntax : schema.getSyntaxes()) {
            this.removeSchemaObject((SchemaObject)syntax);
        }
        this.notifySchemaRemoved(schema);
    }

    private void removeSchemaObject(SchemaObject object) {
        if (object instanceof AttributeTypeImpl) {
            AttributeTypeImpl at = (AttributeTypeImpl)object;
            this.attributeTypesList.remove((Object)at);
            String[] names = at.getNamesRef();
            if (names != null) {
                for (String name : names) {
                    this.attributeTypesMap.remove((Object)name.toLowerCase());
                }
            }
            this.attributeTypesMap.remove((Object)at.getOid());
        } else if (object instanceof MatchingRuleImpl) {
            MatchingRuleImpl mr = (MatchingRuleImpl)object;
            this.matchingRulesList.remove((Object)mr);
            String[] names = mr.getNamesRef();
            if (names != null) {
                for (String name : names) {
                    this.matchingRulesMap.remove((Object)name.toLowerCase());
                }
            }
            this.matchingRulesMap.remove((Object)mr.getOid());
        } else if (object instanceof ObjectClassImpl) {
            ObjectClassImpl oc = (ObjectClassImpl)object;
            this.objectClassesList.remove((Object)oc);
            String[] names = oc.getNamesRef();
            if (names != null) {
                for (String name : names) {
                    this.objectClassesMap.remove((Object)name.toLowerCase());
                }
            }
            this.objectClassesMap.remove((Object)oc.getOid());
        } else if (object instanceof SyntaxImpl) {
            SyntaxImpl syntax = (SyntaxImpl)object;
            this.syntaxesList.remove((Object)syntax);
            String[] names = syntax.getNamesRef();
            if (names != null) {
                for (String name : names) {
                    this.syntaxesMap.remove((Object)name.toLowerCase());
                }
            }
            this.syntaxesMap.remove((Object)syntax.getOid());
        }
    }

    public void addAttributeType(AttributeTypeImpl at) {
        Schema schema = this.getSchema(at.getSchema());
        if (schema == null) {
            // empty if block
        }
        schema.addAttributeType(at);
        this.addSchemaObject((SchemaObject)at);
        this.notifyAttributeTypeAdded(at);
    }

    public void modifyAttributeType(AttributeTypeImpl at1, AttributeTypeImpl at2) {
        this.removeSchemaObject((SchemaObject)at1);
        at1.setNames(at2.getNamesRef());
        at1.setOid(at2.getOid());
        at1.setDescription(at2.getDescription());
        at1.setSuperiorName(at2.getSuperiorName());
        at1.setUsage(at2.getUsage());
        at1.setSyntaxOid(at2.getSyntaxOid());
        at1.setLength(at2.getLength());
        at1.setObsolete(at2.isObsolete());
        at1.setSingleValue(at2.isSingleValue());
        at1.setCollective(at2.isCollective());
        at1.setCanUserModify(at2.isCanUserModify());
        at1.setEqualityName(at2.getEqualityName());
        at1.setOrderingName(at2.getOrderingName());
        at1.setSubstrName(at2.getSubstrName());
        this.addSchemaObject((SchemaObject)at1);
        this.notifyAttributeTypeModified(at1);
    }

    public void removeAttributeType(AttributeTypeImpl at) {
        Schema schema = this.getSchema(at.getSchema());
        if (schema == null) {
            // empty if block
        }
        schema.removeAttributeType(at);
        this.removeSchemaObject((SchemaObject)at);
        this.notifyAttributeTypeRemoved(at);
    }

    public void addObjectClass(ObjectClassImpl oc) {
        Schema schema = this.getSchema(oc.getSchema());
        if (schema == null) {
            // empty if block
        }
        schema.addObjectClass(oc);
        this.addSchemaObject((SchemaObject)oc);
        this.notifyObjectClassAdded(oc);
    }

    public void modifyObjectClass(ObjectClassImpl oc1, ObjectClassImpl oc2) {
        this.removeSchemaObject((SchemaObject)oc1);
        oc1.setNames(oc2.getNamesRef());
        oc1.setOid(oc2.getOid());
        oc1.setDescription(oc2.getDescription());
        oc1.setSuperClassesNames(oc2.getSuperClassesNames());
        oc1.setType(oc2.getType());
        oc1.setObsolete(oc2.isObsolete());
        oc1.setMustNamesList(oc2.getMustNamesList());
        oc1.setMayNamesList(oc2.getMayNamesList());
        this.addSchemaObject((SchemaObject)oc1);
        this.notifyObjectClassModified(oc1);
    }

    public void removeObjectClass(ObjectClassImpl oc) {
        Schema schema = this.getSchema(oc.getSchema());
        if (schema == null) {
            // empty if block
        }
        schema.removeObjectClass(oc);
        this.removeSchemaObject((SchemaObject)oc);
        this.notifyObjectClassRemoved(oc);
    }

    private void notifySchemaAdded(Schema schema) {
        for (SchemaHandlerListener listener : this.schemaHandlerListeners.toArray(new SchemaHandlerListener[0])) {
            listener.schemaAdded(schema);
        }
    }

    private void notifySchemaRemoved(Schema schema) {
        for (SchemaHandlerListener listener : this.schemaHandlerListeners.toArray(new SchemaHandlerListener[0])) {
            listener.schemaRemoved(schema);
        }
    }

    private void notifyAttributeTypeAdded(AttributeTypeImpl at) {
        for (SchemaHandlerListener listener : this.schemaHandlerListeners.toArray(new SchemaHandlerListener[0])) {
            listener.attributeTypeAdded(at);
        }
        List listeners = (List)this.schemaListeners.get((Object)this.getSchema(at.getSchema()));
        if (listeners != null) {
            for (Object object : listeners.toArray()) {
                ((SchemaListener)object).attributeTypeAdded(at);
            }
        }
    }

    private void notifyAttributeTypeModified(AttributeTypeImpl at) {
        for (SchemaHandlerListener listener : this.schemaHandlerListeners.toArray(new SchemaHandlerListener[0])) {
            listener.attributeTypeModified(at);
        }
        List listeners = (List)this.schemaListeners.get((Object)this.getSchema(at.getSchema()));
        if (listeners != null) {
            for (Object object : listeners.toArray()) {
                ((SchemaListener)object).attributeTypeModified(at);
            }
        }
    }

    private void notifyAttributeTypeRemoved(AttributeTypeImpl at) {
        List atListeners;
        for (SchemaHandlerListener listener : this.schemaHandlerListeners.toArray(new SchemaHandlerListener[0])) {
            listener.attributeTypeRemoved(at);
        }
        List listeners = (List)this.schemaListeners.get((Object)this.getSchema(at.getSchema()));
        if (listeners != null) {
            for (Object object : listeners.toArray()) {
                ((SchemaListener)object).attributeTypeRemoved(at);
            }
        }
        if ((atListeners = (List)this.attributeTypeListeners.get((Object)at)) != null) {
            for (Object object : atListeners.toArray()) {
                ((AttributeTypeListener)object).attributeTypeRemoved();
            }
        }
    }

    private void notifyObjectClassAdded(ObjectClassImpl oc) {
        for (SchemaHandlerListener listener : this.schemaHandlerListeners.toArray(new SchemaHandlerListener[0])) {
            listener.objectClassAdded(oc);
        }
        List listeners = (List)this.schemaListeners.get((Object)this.getSchema(oc.getSchema()));
        if (listeners != null) {
            for (Object object : listeners.toArray()) {
                ((SchemaListener)object).objectClassAdded(oc);
            }
        }
    }

    private void notifyObjectClassModified(ObjectClassImpl oc) {
        for (SchemaHandlerListener listener : this.schemaHandlerListeners.toArray(new SchemaHandlerListener[0])) {
            listener.objectClassModified(oc);
        }
        List listeners = (List)this.schemaListeners.get((Object)this.getSchema(oc.getSchema()));
        if (listeners != null) {
            for (Object object : listeners.toArray()) {
                ((SchemaListener)object).objectClassModified(oc);
            }
        }
    }

    private void notifyObjectClassRemoved(ObjectClassImpl oc) {
        List ocListeners;
        for (SchemaHandlerListener listener : this.schemaHandlerListeners.toArray(new SchemaHandlerListener[0])) {
            listener.objectClassRemoved(oc);
        }
        List listeners = (List)this.schemaListeners.get((Object)this.getSchema(oc.getSchema()));
        if (listeners != null) {
            for (Object object : listeners.toArray()) {
                ((SchemaListener)object).objectClassModified(oc);
            }
        }
        if ((ocListeners = (List)this.objectClassListeners.get((Object)oc)) != null) {
            for (Object object : ocListeners.toArray()) {
                ((ObjectClassListener)object).objectClassRemoved();
            }
        }
    }

    private void notifyMatchingRuleAdded(MatchingRuleImpl mr) {
        for (SchemaHandlerListener listener : this.schemaHandlerListeners.toArray(new SchemaHandlerListener[0])) {
            listener.matchingRuleAdded(mr);
        }
        List listeners = (List)this.schemaListeners.get((Object)this.getSchema(mr.getSchema()));
        if (listeners != null) {
            for (Object object : listeners.toArray()) {
                ((SchemaListener)object).matchingRuleAdded(mr);
            }
        }
    }

    private void notifyMatchingRuleModified(MatchingRuleImpl mr) {
        for (SchemaHandlerListener listener : this.schemaHandlerListeners.toArray(new SchemaHandlerListener[0])) {
            listener.matchingRuleModified(mr);
        }
        List listeners = (List)this.schemaListeners.get((Object)this.getSchema(mr.getSchema()));
        if (listeners != null) {
            for (Object object : listeners.toArray()) {
                ((SchemaListener)object).matchingRuleModified(mr);
            }
        }
    }

    private void notifyMatchingRuleRemoved(MatchingRuleImpl mr) {
        for (SchemaHandlerListener listener : this.schemaHandlerListeners.toArray(new SchemaHandlerListener[0])) {
            listener.matchingRuleRemoved(mr);
        }
        List listeners = (List)this.schemaListeners.get((Object)this.getSchema(mr.getSchema()));
        if (listeners != null) {
            for (Object object : listeners.toArray()) {
                ((SchemaListener)object).matchingRuleRemoved(mr);
            }
        }
    }

    private void notifySyntaxRuleAdded(SyntaxImpl syntax) {
        for (SchemaHandlerListener listener : this.schemaHandlerListeners.toArray(new SchemaHandlerListener[0])) {
            listener.syntaxAdded(syntax);
        }
        List listeners = (List)this.schemaListeners.get((Object)this.getSchema(syntax.getSchema()));
        if (listeners != null) {
            for (Object object : listeners.toArray()) {
                ((SchemaListener)object).syntaxAdded(syntax);
            }
        }
    }

    private void notifySyntaxRuleModified(SyntaxImpl syntax) {
        for (SchemaHandlerListener listener : this.schemaHandlerListeners.toArray(new SchemaHandlerListener[0])) {
            listener.syntaxModified(syntax);
        }
        List listeners = (List)this.schemaListeners.get((Object)this.getSchema(syntax.getSchema()));
        if (listeners != null) {
            for (Object object : listeners.toArray()) {
                ((SchemaListener)object).syntaxModified(syntax);
            }
        }
    }

    private void notifySyntaxRemoved(SyntaxImpl syntax) {
        for (SchemaHandlerListener listener : this.schemaHandlerListeners.toArray(new SchemaHandlerListener[0])) {
            listener.syntaxRemoved(syntax);
        }
        List listeners = (List)this.schemaListeners.get((Object)this.getSchema(syntax.getSchema()));
        if (listeners != null) {
            for (Object object : listeners.toArray()) {
                ((SchemaListener)object).syntaxRemoved(syntax);
            }
        }
    }

    public boolean isAliasOrOidAlreadyTaken(String id) {
        String lowerCasedId = id.toLowerCase();
        if (this.attributeTypesMap.containsKey((Object)lowerCasedId)) {
            return true;
        }
        if (this.objectClassesMap.containsKey((Object)lowerCasedId)) {
            return true;
        }
        if (this.matchingRulesMap.containsKey((Object)lowerCasedId)) {
            return true;
        }
        return this.syntaxesMap.containsKey((Object)lowerCasedId);
    }

    public boolean isSchemaNameAlreadyTaken(String name) {
        return this.schemasMap.containsKey((Object)name.toLowerCase());
    }
}

