/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.controller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.directory.studio.schemaeditor.controller.ProjectListener;
import org.apache.directory.studio.schemaeditor.controller.ProjectsHandlerListener;
import org.apache.directory.studio.schemaeditor.model.Project;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectsHandler {
    private static ProjectsHandler instance;
    private List<Project> projectsList = new ArrayList<Project>();
    private Map<String, Project> projectsMap = new HashMap<String, Project>();
    private List<ProjectsHandlerListener> projectsHandlerListeners = new ArrayList<ProjectsHandlerListener>();
    private MultiValueMap projectsListeners = new MultiValueMap();
    private Project openProject;

    public static ProjectsHandler getInstance() {
        if (instance == null) {
            instance = new ProjectsHandler();
        }
        return instance;
    }

    private ProjectsHandler() {
    }

    public void addProject(Project project) {
        this.projectsList.add(project);
        this.projectsMap.put(project.getName().toLowerCase(), project);
        this.notifyProjectAdded(project);
    }

    public void removeProject(Project project) {
        this.projectsList.remove(project);
        this.projectsMap.remove(project.getName().toLowerCase());
        this.notifyProjectRemoved(project);
    }

    public Project getProject(String name) {
        return this.projectsMap.get(name.toLowerCase());
    }

    public List<Project> getProjects() {
        return this.projectsList;
    }

    public void renameProject(Project project, String name) {
        this.projectsMap.remove(project.getName().toLowerCase());
        project.setName(name);
        this.projectsMap.put(name.toLowerCase(), project);
        this.notifyProjectRenamed(project);
    }

    public boolean isProjectNameAlreadyTaken(String name) {
        return this.projectsMap.containsKey(name.toLowerCase());
    }

    public void openProject(Project project) {
        Project oldOpenProject = this.openProject;
        if (oldOpenProject != null) {
            oldOpenProject.setState(Project.ProjectState.CLOSED);
        }
        this.openProject = project;
        this.openProject.setState(Project.ProjectState.OPEN);
        this.notifyOpenProjectChanged(oldOpenProject, this.openProject);
    }

    public void closeProject(Project project) {
        Project oldOpenProject = this.openProject;
        if (oldOpenProject.equals(project)) {
            oldOpenProject.setState(Project.ProjectState.CLOSED);
            this.openProject = null;
        }
        this.notifyOpenProjectChanged(oldOpenProject, this.openProject);
    }

    public Project getOpenProject() {
        return this.openProject;
    }

    public void setOpenProject(Project project) {
        this.openProject = project;
    }

    public void addListener(ProjectsHandlerListener listener) {
        this.projectsHandlerListeners.add(listener);
    }

    public void removeListener(ProjectsHandlerListener listener) {
        this.projectsHandlerListeners.remove(listener);
    }

    public void addListener(Project project, ProjectListener listener) {
        if (!this.projectsListeners.containsValue((Object)project, (Object)listener)) {
            this.projectsListeners.put((Object)project, (Object)listener);
        }
    }

    public void removeListener(Project project, ProjectListener listener) {
        this.projectsListeners.remove((Object)project, (Object)listener);
    }

    private void notifyProjectAdded(Project project) {
        for (ProjectsHandlerListener listener : this.projectsHandlerListeners) {
            listener.projectAdded(project);
        }
    }

    private void notifyProjectRemoved(Project project) {
        for (ProjectsHandlerListener listener : this.projectsHandlerListeners) {
            listener.projectRemoved(project);
        }
    }

    private void notifyProjectRenamed(Project project) {
        List listeners = (List)this.projectsListeners.get((Object)project);
        for (ProjectListener listener : listeners) {
            listener.projectRenamed();
        }
    }

    private void notifyOpenProjectChanged(Project oldProject, Project newProject) {
        for (ProjectsHandlerListener listener : this.projectsHandlerListeners) {
            listener.openProjectChanged(oldProject, newProject);
        }
    }
}

