/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.controller;

import org.apache.directory.shared.ldap.schema.SchemaObject;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.PluginUtils;
import org.apache.directory.studio.schemaeditor.controller.Messages;
import org.apache.directory.studio.schemaeditor.model.AttributeTypeImpl;
import org.apache.directory.studio.schemaeditor.model.ObjectClassImpl;
import org.apache.directory.studio.schemaeditor.model.schemachecker.SchemaCheckerListener;
import org.apache.directory.studio.schemaeditor.view.ViewUtils;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.AttributeTypeEditor;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.AttributeTypeEditorInput;
import org.apache.directory.studio.schemaeditor.view.editors.objectclass.ObjectClassEditor;
import org.apache.directory.studio.schemaeditor.view.editors.objectclass.ObjectClassEditorInput;
import org.apache.directory.studio.schemaeditor.view.views.ProblemsView;
import org.apache.directory.studio.schemaeditor.view.widget.Folder;
import org.apache.directory.studio.schemaeditor.view.wrappers.SchemaErrorWrapper;
import org.apache.directory.studio.schemaeditor.view.wrappers.SchemaWarningWrapper;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ProblemsViewController {
    private ProblemsView view;
    private SchemaCheckerListener schemaCheckerListener = new SchemaCheckerListener(){

        public void schemaCheckerUpdated() {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    ProblemsViewController.this.view.reloadViewer();
                }
            });
        }
    };

    public ProblemsViewController(ProblemsView view) {
        this.view = view;
        Activator.getDefault().getSchemaChecker().addListener(this.schemaCheckerListener);
        this.initDoubleClickListener();
    }

    private void initDoubleClickListener() {
        this.view.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SchemaObject object;
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                TreeViewer viewer = ProblemsViewController.this.view.getViewer();
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                Object objectSelection = selection.getFirstElement();
                Object input = null;
                String editorId = null;
                if (objectSelection instanceof SchemaErrorWrapper) {
                    object = ((SchemaErrorWrapper)objectSelection).getSchemaError().getSource();
                    if (object instanceof AttributeTypeImpl) {
                        input = new AttributeTypeEditorInput((AttributeTypeImpl)object);
                        editorId = AttributeTypeEditor.ID;
                    } else if (object instanceof ObjectClassImpl) {
                        input = new ObjectClassEditorInput((ObjectClassImpl)object);
                        editorId = ObjectClassEditor.ID;
                    }
                } else if (objectSelection instanceof SchemaWarningWrapper) {
                    object = ((SchemaWarningWrapper)objectSelection).getSchemaWarning().getSource();
                    if (object instanceof AttributeTypeImpl) {
                        input = new AttributeTypeEditorInput((AttributeTypeImpl)object);
                        editorId = AttributeTypeEditor.ID;
                    } else if (object instanceof ObjectClassImpl) {
                        input = new ObjectClassEditorInput((ObjectClassImpl)object);
                        editorId = ObjectClassEditor.ID;
                    }
                } else if (objectSelection instanceof Folder) {
                    viewer.setExpandedState(objectSelection, !viewer.getExpandedState(objectSelection));
                }
                if (input != null) {
                    try {
                        page.openEditor(input, editorId);
                    }
                    catch (PartInitException e) {
                        PluginUtils.logError(Messages.getString("ProblemsViewController.ErrorOpeningEditor"), e);
                        ViewUtils.displayErrorMessageBox(Messages.getString("ProblemsViewController.Error"), Messages.getString("ProblemsViewController.ErrorOpeningEditor"));
                    }
                }
            }
        });
    }

    public void dispose() {
        Activator.getDefault().getSchemaChecker().removeListener(this.schemaCheckerListener);
    }
}

