/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.controller;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.PluginConstants;
import org.apache.directory.studio.schemaeditor.PluginUtils;
import org.apache.directory.studio.schemaeditor.controller.Messages;
import org.apache.directory.studio.schemaeditor.controller.ProjectsHandlerAdapter;
import org.apache.directory.studio.schemaeditor.controller.ProjectsHandlerListener;
import org.apache.directory.studio.schemaeditor.controller.actions.LinkWithEditorHierarchyViewAction;
import org.apache.directory.studio.schemaeditor.controller.actions.OpenHierarchyViewPreferencesAction;
import org.apache.directory.studio.schemaeditor.controller.actions.ShowSubtypeHierarchyAction;
import org.apache.directory.studio.schemaeditor.controller.actions.ShowSupertypeHierarchyAction;
import org.apache.directory.studio.schemaeditor.controller.actions.ShowTypeHierarchyAction;
import org.apache.directory.studio.schemaeditor.model.Project;
import org.apache.directory.studio.schemaeditor.view.ViewUtils;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.AttributeTypeEditor;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.AttributeTypeEditorInput;
import org.apache.directory.studio.schemaeditor.view.editors.objectclass.ObjectClassEditor;
import org.apache.directory.studio.schemaeditor.view.editors.objectclass.ObjectClassEditorInput;
import org.apache.directory.studio.schemaeditor.view.views.HierarchyView;
import org.apache.directory.studio.schemaeditor.view.wrappers.AttributeTypeWrapper;
import org.apache.directory.studio.schemaeditor.view.wrappers.ObjectClassWrapper;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class HierarchyViewController {
    private HierarchyView view;
    List<String> authorizedPrefs;
    private ProjectsHandlerListener projectsHandlerListener = new ProjectsHandlerAdapter(){

        public void openProjectChanged(Project oldProject, Project newProject) {
            HierarchyViewController.this.view.setInput(null);
            if (newProject != null) {
                HierarchyViewController.this.view.getViewer().getTree().setEnabled(true);
                HierarchyViewController.this.showTypeHierarchy.setEnabled(true);
                HierarchyViewController.this.showSupertypeHierarchy.setEnabled(true);
                HierarchyViewController.this.showSubtypeHierarchy.setEnabled(true);
                HierarchyViewController.this.linkWithEditor.setEnabled(true);
                HierarchyViewController.this.openPreferencePage.setEnabled(true);
            } else {
                HierarchyViewController.this.view.getViewer().getTree().setEnabled(false);
                HierarchyViewController.this.showTypeHierarchy.setEnabled(false);
                HierarchyViewController.this.showSupertypeHierarchy.setEnabled(false);
                HierarchyViewController.this.showSubtypeHierarchy.setEnabled(false);
                HierarchyViewController.this.linkWithEditor.setEnabled(false);
                HierarchyViewController.this.openPreferencePage.setEnabled(false);
            }
        }
    };
    private IDoubleClickListener doubleClickListener = new IDoubleClickListener(){

        public void doubleClick(DoubleClickEvent event) {
            StructuredSelection selection = (StructuredSelection)event.getSelection();
            Object objectSelection = selection.getFirstElement();
            Object input = null;
            String editorId = null;
            if (objectSelection instanceof AttributeTypeWrapper) {
                input = new AttributeTypeEditorInput(((AttributeTypeWrapper)objectSelection).getAttributeType());
                editorId = AttributeTypeEditor.ID;
            } else if (objectSelection instanceof ObjectClassWrapper) {
                input = new ObjectClassEditorInput(((ObjectClassWrapper)objectSelection).getObjectClass());
                editorId = ObjectClassEditor.ID;
            }
            if (input != null) {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    page.openEditor((IEditorInput)input, editorId);
                }
                catch (PartInitException e) {
                    PluginUtils.logError(Messages.getString("HierarchyViewController.ErrorOpeningEditor"), e);
                    ViewUtils.displayErrorMessageBox(Messages.getString("HierarchyViewController.Error"), Messages.getString("HierarchyViewController.ErrorOpeningEditor"));
                }
            }
        }
    };
    private IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (HierarchyViewController.this.authorizedPrefs.contains(event.getProperty())) {
                HierarchyViewController.this.view.refresh();
            }
        }
    };
    private Action showTypeHierarchy;
    private Action showSupertypeHierarchy;
    private Action showSubtypeHierarchy;
    private Action linkWithEditor;
    private Action openPreferencePage;

    public HierarchyViewController(HierarchyView view) {
        this.view = view;
        this.initAuthorizedPrefs();
        this.initActions();
        this.initToolbar();
        this.initMenu();
        this.initProjectsHandlerListener();
        this.initDoubleClickListener();
        this.initPreferencesListener();
        this.initState();
    }

    private void initAuthorizedPrefs() {
        this.authorizedPrefs = new ArrayList<String>();
        this.authorizedPrefs.add(PluginConstants.PREFS_HIERARCHY_VIEW_LABEL);
        this.authorizedPrefs.add(PluginConstants.PREFS_HIERARCHY_VIEW_ABBREVIATE);
        this.authorizedPrefs.add(PluginConstants.PREFS_HIERARCHY_VIEW_ABBREVIATE_MAX_LENGTH);
        this.authorizedPrefs.add(PluginConstants.PREFS_HIERARCHY_VIEW_SECONDARY_LABEL_DISPLAY);
        this.authorizedPrefs.add(PluginConstants.PREFS_HIERARCHY_VIEW_SECONDARY_LABEL);
        this.authorizedPrefs.add(PluginConstants.PREFS_HIERARCHY_VIEW_SECONDARY_LABEL_ABBREVIATE);
        this.authorizedPrefs.add(PluginConstants.PREFS_HIERARCHY_VIEW_SECONDARY_LABEL_ABBREVIATE_MAX_LENGTH);
    }

    private void initActions() {
        if (Activator.getDefault().getDialogSettings().get(PluginConstants.PREFS_HIERARCHY_VIEW_MODE) == null) {
            Activator.getDefault().getDialogSettings().put(PluginConstants.PREFS_HIERARCHY_VIEW_MODE, 2);
        }
        this.showTypeHierarchy = new ShowTypeHierarchyAction(this.view);
        this.showSupertypeHierarchy = new ShowSupertypeHierarchyAction(this.view);
        this.showSubtypeHierarchy = new ShowSubtypeHierarchyAction(this.view);
        this.linkWithEditor = new LinkWithEditorHierarchyViewAction(this.view);
        this.openPreferencePage = new OpenHierarchyViewPreferencesAction();
    }

    private void initToolbar() {
        IToolBarManager toolbar = this.view.getViewSite().getActionBars().getToolBarManager();
        toolbar.add((IAction)this.showTypeHierarchy);
        toolbar.add((IAction)this.showSupertypeHierarchy);
        toolbar.add((IAction)this.showSubtypeHierarchy);
        toolbar.add((IContributionItem)new Separator());
        toolbar.add((IAction)this.linkWithEditor);
    }

    private void initMenu() {
        IMenuManager menu = this.view.getViewSite().getActionBars().getMenuManager();
        menu.add((IAction)this.showTypeHierarchy);
        menu.add((IAction)this.showSupertypeHierarchy);
        menu.add((IAction)this.showSubtypeHierarchy);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.linkWithEditor);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.openPreferencePage);
    }

    private void initProjectsHandlerListener() {
        Activator.getDefault().getProjectsHandler().addListener(this.projectsHandlerListener);
    }

    private void initDoubleClickListener() {
        this.view.getViewer().addDoubleClickListener(this.doubleClickListener);
    }

    private void initPreferencesListener() {
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.propertyChangeListener);
    }

    private void initState() {
        if (Activator.getDefault().getProjectsHandler().getOpenProject() != null) {
            this.view.getViewer().getTree().setEnabled(true);
            this.showTypeHierarchy.setEnabled(true);
            this.showSupertypeHierarchy.setEnabled(true);
            this.showSubtypeHierarchy.setEnabled(true);
            this.linkWithEditor.setEnabled(true);
            this.openPreferencePage.setEnabled(true);
        } else {
            this.view.getViewer().getTree().setEnabled(false);
            this.showTypeHierarchy.setEnabled(false);
            this.showSupertypeHierarchy.setEnabled(false);
            this.showSubtypeHierarchy.setEnabled(false);
            this.linkWithEditor.setEnabled(false);
            this.openPreferencePage.setEnabled(false);
        }
    }

    public void dispose() {
        Activator.getDefault().getProjectsHandler().removeListener(this.projectsHandlerListener);
        this.view.getViewer().removeDoubleClickListener(this.doubleClickListener);
        Activator.getDefault().getPreferenceStore().removePropertyChangeListener(this.propertyChangeListener);
    }
}

