/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.PropertyResourceBundle;
import org.apache.directory.studio.schemaeditor.Messages;
import org.apache.directory.studio.schemaeditor.PluginUtils;
import org.apache.directory.studio.schemaeditor.controller.ProjectsHandler;
import org.apache.directory.studio.schemaeditor.controller.ProjectsHandlerListener;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandler;
import org.apache.directory.studio.schemaeditor.model.Project;
import org.apache.directory.studio.schemaeditor.model.schemachecker.SchemaChecker;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.AttributeTypeEditor;
import org.apache.directory.studio.schemaeditor.view.editors.objectclass.ObjectClassEditor;
import org.apache.directory.studio.schemaeditor.view.editors.schema.SchemaEditor;
import org.apache.directory.studio.schemaeditor.view.widget.SchemaCodeScanner;
import org.apache.directory.studio.schemaeditor.view.widget.SchemaTextAttributeProvider;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    private static Activator plugin;
    private ITokenScanner schemaCodeScanner;
    private SchemaTextAttributeProvider schemaTextAttributeProvider;
    private SchemaHandler schemaHandler;
    private SchemaChecker schemaChecker;
    private ProjectsHandler projectsHandler;
    private PropertyResourceBundle properties;

    public Activator() {
        plugin = this;
        this.projectsHandler = ProjectsHandler.getInstance();
        this.schemaChecker = SchemaChecker.getInstance();
    }

    private void closeProjectEditors() {
        ArrayList<IEditorReference> editors = new ArrayList<IEditorReference>();
        for (IEditorReference editorReference : this.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences()) {
            if (!editorReference.getId().equals(AttributeTypeEditor.ID) && !editorReference.getId().equals(ObjectClassEditor.ID) && !editorReference.getId().equals(SchemaEditor.ID)) continue;
            editors.add(editorReference);
        }
        if (!this.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditors(editors.toArray(new IEditorReference[0]), true)) {
            this.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditors(editors.toArray(new IEditorReference[0]), false);
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        PluginUtils.loadProjects();
        this.projectsHandler.addListener(new ProjectsHandlerListener(){

            public void openProjectChanged(Project oldProject, Project newProject) {
                Activator.this.closeProjectEditors();
                if (newProject == null) {
                    Activator.this.schemaHandler = null;
                } else {
                    Activator.this.schemaHandler = newProject.getSchemaHandler();
                }
                Activator.this.schemaChecker.reload();
                PluginUtils.saveProjects();
            }

            public void projectAdded(Project project) {
                PluginUtils.saveProjects();
            }

            public void projectRemoved(Project project) {
                PluginUtils.saveProjects();
            }
        });
    }

    public void stop(BundleContext context) throws Exception {
        PluginUtils.saveProjects();
        super.stop(context);
        plugin = null;
    }

    public static Activator getDefault() {
        return plugin;
    }

    public SchemaHandler getSchemaHandler() {
        return this.schemaHandler;
    }

    public SchemaChecker getSchemaChecker() {
        return this.schemaChecker;
    }

    public ProjectsHandler getProjectsHandler() {
        return this.projectsHandler;
    }

    public ITokenScanner getSchemaCodeScanner() {
        if (this.schemaCodeScanner == null) {
            this.schemaCodeScanner = new SchemaCodeScanner(this.getSchemaTextAttributeProvider());
        }
        return this.schemaCodeScanner;
    }

    private SchemaTextAttributeProvider getSchemaTextAttributeProvider() {
        if (this.schemaTextAttributeProvider == null) {
            this.schemaTextAttributeProvider = new SchemaTextAttributeProvider();
        }
        return this.schemaTextAttributeProvider;
    }

    public ImageDescriptor getImageDescriptor(String key) {
        if (key != null) {
            URL url = FileLocator.find((Bundle)this.getBundle(), (IPath)new Path(key), null);
            if (url != null) {
                return ImageDescriptor.createFromURL((URL)url);
            }
            return null;
        }
        return null;
    }

    public Image getImage(String key) {
        ImageDescriptor id;
        Image image = this.getImageRegistry().get(key);
        if (image == null && (id = this.getImageDescriptor(key)) != null) {
            image = id.createImage();
            this.getImageRegistry().put(key, image);
        }
        return image;
    }

    public PropertyResourceBundle getPluginProperties() {
        if (this.properties == null) {
            try {
                this.properties = new PropertyResourceBundle(FileLocator.openStream((Bundle)this.getBundle(), (IPath)new Path("plugin.properties"), (boolean)false));
            }
            catch (IOException e) {
                this.getLog().log((IStatus)new Status(4, "org.apache.directory.studio.schemaeditor", 0, Messages.getString("Activator.UnablePluginProperties"), (Throwable)e));
            }
        }
        return this.properties;
    }
}

