/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldifparser.parser;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.directory.studio.ldifparser.model.LdifEOFPart;
import org.apache.directory.studio.ldifparser.model.LdifEnumeration;
import org.apache.directory.studio.ldifparser.model.LdifFile;
import org.apache.directory.studio.ldifparser.model.LdifInvalidPart;
import org.apache.directory.studio.ldifparser.model.LdifPart;
import org.apache.directory.studio.ldifparser.model.container.LdifChangeAddRecord;
import org.apache.directory.studio.ldifparser.model.container.LdifChangeDeleteRecord;
import org.apache.directory.studio.ldifparser.model.container.LdifChangeModDnRecord;
import org.apache.directory.studio.ldifparser.model.container.LdifChangeModifyRecord;
import org.apache.directory.studio.ldifparser.model.container.LdifChangeRecord;
import org.apache.directory.studio.ldifparser.model.container.LdifCommentContainer;
import org.apache.directory.studio.ldifparser.model.container.LdifContainer;
import org.apache.directory.studio.ldifparser.model.container.LdifContentRecord;
import org.apache.directory.studio.ldifparser.model.container.LdifEOFContainer;
import org.apache.directory.studio.ldifparser.model.container.LdifInvalidContainer;
import org.apache.directory.studio.ldifparser.model.container.LdifModSpec;
import org.apache.directory.studio.ldifparser.model.container.LdifRecord;
import org.apache.directory.studio.ldifparser.model.container.LdifSepContainer;
import org.apache.directory.studio.ldifparser.model.container.LdifVersionContainer;
import org.apache.directory.studio.ldifparser.model.lines.LdifAttrValLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifChangeTypeLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifCommentLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifControlLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifDeloldrdnLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifDnLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifModSpecSepLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifModSpecTypeLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifNewrdnLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifNewsuperiorLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifSepLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifVersionLine;
import org.apache.directory.studio.ldifparser.parser.LdifScanner;
import org.apache.directory.studio.ldifparser.parser.LdifToken;

public class LdifParser {
    private LdifScanner scanner = new LdifScanner();

    public LdifFile parse(String ldif) {
        LdifFile model = new LdifFile();
        if (ldif != null) {
            LdifEnumeration enumeration = this.parse(new StringReader(ldif));
            try {
                while (enumeration.hasNext()) {
                    LdifContainer container = enumeration.next();
                    model.addContainer(container);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return model;
    }

    public LdifEnumeration parse(Reader ldifReader) {
        this.scanner.setLdif(ldifReader);
        LdifEnumeration enumeration = new LdifEnumeration(){
            private List containerList = new ArrayList();
            private boolean headerParsed = false;
            private boolean bodyParsed = false;
            private boolean footerParsed = false;

            public boolean hasNext() {
                if (this.containerList.isEmpty()) {
                    LdifFile model = new LdifFile();
                    if (!this.headerParsed) {
                        LdifParser.this.checkAndParseComment(model);
                        LdifParser.this.checkAndParseVersion(model);
                        LdifParser.this.checkAndParseComment(model);
                        this.headerParsed = true;
                    }
                    if (!(!this.headerParsed || this.bodyParsed || LdifParser.this.checkAndParseComment(model) || LdifParser.this.checkAndParseRecord(model) || LdifParser.this.checkAndParseOther(model))) {
                        this.bodyParsed = true;
                    }
                    if (this.headerParsed && this.bodyParsed && !this.footerParsed) {
                        LdifParser.this.checkAndParseComment(model);
                        this.footerParsed = true;
                    }
                    LdifContainer[] containers = model.getContainers();
                    this.containerList.addAll(Arrays.asList(containers));
                    return !this.containerList.isEmpty() && !(containers[0] instanceof LdifEOFContainer);
                }
                return true;
            }

            public LdifContainer next() {
                if (this.hasNext()) {
                    return (LdifContainer)this.containerList.remove(0);
                }
                return null;
            }
        };
        return enumeration;
    }

    private boolean checkAndParseRecord(LdifFile model) {
        LdifToken dnSpecToken = this.scanner.matchDnSpec();
        if (dnSpecToken == null) {
            return false;
        }
        LdifToken dnValueTypeToken = null;
        LdifToken dnToken = null;
        LdifToken dnSepToken = null;
        dnValueTypeToken = this.scanner.matchValueType();
        if (dnValueTypeToken != null && (dnToken = this.scanner.matchValue()) != null) {
            dnSepToken = this.scanner.matchSep();
        }
        LdifDnLine dnLine = new LdifDnLine(dnSpecToken.getOffset(), LdifParser.getValueOrNull(dnSpecToken), LdifParser.getValueOrNull(dnValueTypeToken), LdifParser.getValueOrNull(dnToken), LdifParser.getValueOrNull(dnSepToken));
        LdifToken dnErrorToken = null;
        if (dnSepToken == null) {
            dnErrorToken = this.scanner.matchCleanupLine();
        }
        LdifCommentLine[] commentLines = this.getCommentLines();
        LdifControlLine controlLine = this.getControlLine();
        LdifChangeTypeLine changeTypeLine = this.getChangeTypeLine();
        if (controlLine != null || changeTypeLine != null) {
            int i;
            LdifChangeRecord record = null;
            ArrayList<LdifPart> partList = new ArrayList<LdifPart>();
            if (dnErrorToken != null) {
                partList.add(new LdifInvalidPart(dnErrorToken.getOffset(), dnErrorToken.getValue()));
            }
            for (i = 0; i < commentLines.length; ++i) {
                partList.add(commentLines[i]);
            }
            if (controlLine != null) {
                LdifToken errorToken;
                partList.add(controlLine);
                if (!controlLine.isValid() && (errorToken = this.cleanupLine()) != null) {
                    partList.add(new LdifInvalidPart(errorToken.getOffset(), errorToken.getValue()));
                }
            }
            while (changeTypeLine == null && (commentLines.length > 0 || controlLine != null)) {
                commentLines = this.getCommentLines();
                for (i = 0; i < commentLines.length; ++i) {
                    partList.add(commentLines[i]);
                }
                controlLine = this.getControlLine();
                if (controlLine != null) {
                    LdifToken errorToken;
                    partList.add(controlLine);
                    if (!controlLine.isValid() && (errorToken = this.cleanupLine()) != null) {
                        partList.add(new LdifInvalidPart(errorToken.getOffset(), errorToken.getValue()));
                    }
                }
                changeTypeLine = this.getChangeTypeLine();
            }
            if (changeTypeLine != null) {
                if (changeTypeLine.isAdd()) {
                    record = new LdifChangeAddRecord(dnLine);
                    this.append(record, partList);
                    record.setChangeType(changeTypeLine);
                    if (!changeTypeLine.isValid()) {
                        this.cleanupLine(record);
                    }
                    this.parseAttrValRecord(record);
                } else if (changeTypeLine.isDelete()) {
                    record = new LdifChangeDeleteRecord(dnLine);
                    this.append(record, partList);
                    record.setChangeType(changeTypeLine);
                    if (!changeTypeLine.isValid()) {
                        this.cleanupLine(record);
                    }
                    this.parseChangeDeleteRecord(record);
                } else if (changeTypeLine.isModify()) {
                    record = new LdifChangeModifyRecord(dnLine);
                    this.append(record, partList);
                    record.setChangeType(changeTypeLine);
                    if (!changeTypeLine.isValid()) {
                        this.cleanupLine(record);
                    }
                    this.parseChangeModifyRecord((LdifChangeModifyRecord)record);
                } else if (changeTypeLine.isModDn()) {
                    record = new LdifChangeModDnRecord(dnLine);
                    this.append(record, partList);
                    record.setChangeType(changeTypeLine);
                    if (!changeTypeLine.isValid()) {
                        this.cleanupLine(record);
                    }
                    this.parseChangeModDnRecord((LdifChangeModDnRecord)record);
                } else {
                    record = new LdifChangeRecord(dnLine);
                    this.append(record, partList);
                    record.setChangeType(changeTypeLine);
                    if (!changeTypeLine.isValid()) {
                        this.cleanupLine(record);
                    }
                }
            } else {
                record = new LdifChangeRecord(dnLine);
                this.append(record, partList);
            }
            model.addContainer(record);
        } else {
            LdifContentRecord record = new LdifContentRecord(dnLine);
            if (dnErrorToken != null) {
                record.addInvalid(new LdifInvalidPart(dnErrorToken.getOffset(), dnErrorToken.getValue()));
            }
            for (int i = 0; i < commentLines.length; ++i) {
                record.addComment(commentLines[i]);
            }
            this.parseAttrValRecord(record);
            model.addContainer(record);
        }
        return true;
    }

    private void append(LdifChangeRecord record, List partList) {
        for (Object o : partList) {
            if (o instanceof LdifCommentLine) {
                record.addComment((LdifCommentLine)o);
            }
            if (o instanceof LdifControlLine) {
                record.addControl((LdifControlLine)o);
            }
            if (!(o instanceof LdifInvalidPart)) continue;
            record.addInvalid((LdifInvalidPart)o);
        }
    }

    private void parseChangeDeleteRecord(LdifRecord record) {
        do {
            if (!this.checkAndParseEndOfRecord(record)) continue;
            return;
        } while (this.checkAndParseComment(record) || this.checkAndParseOther(record));
    }

    private void parseChangeModDnRecord(LdifChangeModDnRecord record) {
        boolean newrdnRead = false;
        boolean deleteoldrdnRead = false;
        boolean newsuperiorRead = false;
        while (!this.checkAndParseEndOfRecord(record)) {
            this.checkAndParseComment(record);
            LdifToken newrdnSpecToken = null;
            LdifToken deleteoldrdnSpecToken = null;
            LdifToken newsuperiorSpecToken = null;
            if (!newrdnRead) {
                newrdnSpecToken = this.scanner.matchNewrdnSpec();
            }
            if (!deleteoldrdnRead && newrdnSpecToken == null) {
                deleteoldrdnSpecToken = this.scanner.matchDeleteoldrdnSpec();
            }
            if (!newsuperiorRead && newrdnSpecToken == null && newsuperiorSpecToken == null) {
                newsuperiorSpecToken = this.scanner.matchNewsuperiorSpec();
            }
            if (newrdnSpecToken != null) {
                newrdnRead = true;
                LdifToken newrdnValueTypeToken = this.scanner.matchValueType();
                LdifToken newrdnValueToken = this.scanner.matchValue();
                LdifToken newrdnSepToken = null;
                if (newrdnValueTypeToken != null || newrdnValueToken != null) {
                    newrdnSepToken = this.scanner.matchSep();
                }
                LdifNewrdnLine newrdnLine = new LdifNewrdnLine(newrdnSpecToken.getOffset(), LdifParser.getValueOrNull(newrdnSpecToken), LdifParser.getValueOrNull(newrdnValueTypeToken), LdifParser.getValueOrNull(newrdnValueToken), LdifParser.getValueOrNull(newrdnSepToken));
                record.setNewrdn(newrdnLine);
                if (newrdnSepToken == null) {
                    this.cleanupLine(record);
                }
            } else if (deleteoldrdnSpecToken != null) {
                deleteoldrdnRead = true;
                LdifToken deleteoldrdnValueTypeToken = this.scanner.matchValueType();
                LdifToken deleteoldrdnValueToken = this.scanner.matchValue();
                LdifToken deleteoldrdnSepToken = null;
                if (deleteoldrdnValueTypeToken != null || deleteoldrdnValueToken != null) {
                    deleteoldrdnSepToken = this.scanner.matchSep();
                }
                LdifDeloldrdnLine deloldrdnLine = new LdifDeloldrdnLine(deleteoldrdnSpecToken.getOffset(), LdifParser.getValueOrNull(deleteoldrdnSpecToken), LdifParser.getValueOrNull(deleteoldrdnValueTypeToken), LdifParser.getValueOrNull(deleteoldrdnValueToken), LdifParser.getValueOrNull(deleteoldrdnSepToken));
                record.setDeloldrdn(deloldrdnLine);
                if (deleteoldrdnSepToken == null) {
                    this.cleanupLine(record);
                }
            } else if (newsuperiorSpecToken != null) {
                newsuperiorRead = true;
                LdifToken newsuperiorValueTypeToken = this.scanner.matchValueType();
                LdifToken newsuperiorValueToken = this.scanner.matchValue();
                LdifToken newsuperiorSepToken = null;
                if (newsuperiorValueTypeToken != null || newsuperiorValueToken != null) {
                    newsuperiorSepToken = this.scanner.matchSep();
                }
                LdifNewsuperiorLine newsuperiorLine = new LdifNewsuperiorLine(newsuperiorSpecToken.getOffset(), LdifParser.getValueOrNull(newsuperiorSpecToken), LdifParser.getValueOrNull(newsuperiorValueTypeToken), LdifParser.getValueOrNull(newsuperiorValueToken), LdifParser.getValueOrNull(newsuperiorSepToken));
                record.setNewsuperior(newsuperiorLine);
                if (newsuperiorSepToken == null) {
                    this.cleanupLine(record);
                }
            } else if (!this.checkAndParseComment(record) && !this.checkAndParseOther(record)) {
                return;
            }
            this.checkAndParseComment(record);
        }
        return;
    }

    private void parseChangeModifyRecord(LdifChangeModifyRecord record) {
        LdifToken modSpecTypeSpecToken;
        do {
            if (this.checkAndParseEndOfRecord(record)) {
                return;
            }
            modSpecTypeSpecToken = this.scanner.matchModTypeSpec();
            if (modSpecTypeSpecToken == null) continue;
            LdifToken modSpecTypeValueTypeToken = null;
            LdifToken modSpecTypeAttributeDescriptionToken = null;
            LdifToken sepToken = null;
            modSpecTypeValueTypeToken = this.scanner.matchValueType();
            if (modSpecTypeValueTypeToken != null && (modSpecTypeAttributeDescriptionToken = this.scanner.matchAttributeDescription()) != null) {
                sepToken = this.scanner.matchSep();
            }
            LdifModSpecTypeLine modSpecTypeLine = new LdifModSpecTypeLine(modSpecTypeSpecToken.getOffset(), LdifParser.getValueOrNull(modSpecTypeSpecToken), LdifParser.getValueOrNull(modSpecTypeValueTypeToken), LdifParser.getValueOrNull(modSpecTypeAttributeDescriptionToken), LdifParser.getValueOrNull(sepToken));
            LdifModSpec modSpec = new LdifModSpec(modSpecTypeLine);
            record.addModSpec(modSpec);
            if (sepToken == null) {
                this.cleanupLine(modSpec);
            }
            this.checkAndParseComment(record);
            while (true) {
                LdifAttrValLine line;
                if ((line = this.getAttrValLine()) != null) {
                    modSpec.addAttrVal(line);
                    if (!"".equals(line.getRawNewLine())) continue;
                    this.cleanupLine(record);
                    continue;
                }
                if (!this.checkAndParseComment(record)) break;
            }
            this.checkAndParseComment(record);
            LdifToken modSpecSepToken = this.scanner.matchModSep();
            if (modSpecSepToken == null) continue;
            LdifToken modSpecSepSepToken = this.scanner.matchSep();
            LdifModSpecSepLine modSpecSepLine = new LdifModSpecSepLine(modSpecSepToken.getOffset(), LdifParser.getValueOrNull(modSpecSepToken), LdifParser.getValueOrNull(modSpecSepSepToken));
            modSpec.finish(modSpecSepLine);
        } while (modSpecTypeSpecToken != null || this.checkAndParseComment(record) || this.checkAndParseOther(record));
    }

    private void parseAttrValRecord(LdifRecord record) {
        while (true) {
            if (this.checkAndParseEndOfRecord(record)) {
                return;
            }
            LdifAttrValLine line = this.getAttrValLine();
            if (line != null) {
                if (record instanceof LdifContentRecord) {
                    ((LdifContentRecord)record).addAttrVal(line);
                } else if (record instanceof LdifChangeAddRecord) {
                    ((LdifChangeAddRecord)record).addAttrVal(line);
                }
                if (!"".equals(line.getRawNewLine())) continue;
                this.cleanupLine(record);
                continue;
            }
            if (!this.checkAndParseComment(record) && !this.checkAndParseOther(record)) break;
        }
    }

    private boolean checkAndParseEndOfRecord(LdifRecord record) {
        LdifToken eorSepToken = this.scanner.matchSep();
        if (eorSepToken != null) {
            record.finish(new LdifSepLine(eorSepToken.getOffset(), LdifParser.getValueOrNull(eorSepToken)));
            return true;
        }
        LdifToken eofToken = this.scanner.matchEOF();
        if (eofToken != null) {
            record.finish(new LdifEOFPart(eofToken.getOffset()));
            return true;
        }
        return false;
    }

    private boolean checkAndParseComment(LdifRecord record) {
        LdifToken commentToken = this.scanner.matchComment();
        if (commentToken != null) {
            while (commentToken != null) {
                LdifToken sepToken = this.scanner.matchSep();
                record.addComment(new LdifCommentLine(commentToken.getOffset(), LdifParser.getValueOrNull(commentToken), LdifParser.getValueOrNull(sepToken)));
                commentToken = this.scanner.matchComment();
            }
            return true;
        }
        return false;
    }

    private boolean checkAndParseOther(LdifRecord record) {
        LdifToken otherToken = this.scanner.matchOther();
        if (otherToken != null) {
            record.addInvalid(new LdifInvalidPart(otherToken.getOffset(), otherToken.getValue()));
            return true;
        }
        return false;
    }

    private boolean checkAndParseVersion(LdifFile model) {
        LdifToken versionSpecToken = this.scanner.matchVersionSpec();
        if (versionSpecToken != null) {
            LdifToken versionTypeToken = null;
            LdifToken versionToken = null;
            LdifToken sepToken = null;
            versionTypeToken = this.scanner.matchValueType();
            if (versionTypeToken != null && (versionToken = this.scanner.matchNumber()) != null) {
                sepToken = this.scanner.matchSep();
            }
            LdifVersionContainer container = new LdifVersionContainer(new LdifVersionLine(versionSpecToken.getOffset(), LdifParser.getValueOrNull(versionSpecToken), LdifParser.getValueOrNull(versionTypeToken), LdifParser.getValueOrNull(versionToken), LdifParser.getValueOrNull(sepToken)));
            model.addContainer(container);
            if (sepToken == null) {
                this.cleanupLine(container);
            }
            return true;
        }
        return false;
    }

    private boolean checkAndParseComment(LdifFile model) {
        LdifToken sepToken = this.scanner.matchSep();
        LdifToken commentToken = this.scanner.matchComment();
        if (sepToken != null || commentToken != null) {
            while (sepToken != null || commentToken != null) {
                if (sepToken != null) {
                    LdifSepLine sepLine = new LdifSepLine(sepToken.getOffset(), LdifParser.getValueOrNull(sepToken));
                    LdifSepContainer sepContainer = new LdifSepContainer(sepLine);
                    model.addContainer(sepContainer);
                }
                if (commentToken != null) {
                    LdifCommentContainer commentContainer = null;
                    while (commentToken != null) {
                        LdifToken commentSepToken = this.scanner.matchSep();
                        LdifCommentLine commentLine = new LdifCommentLine(commentToken.getOffset(), LdifParser.getValueOrNull(commentToken), LdifParser.getValueOrNull(commentSepToken));
                        if (commentContainer == null) {
                            commentContainer = new LdifCommentContainer(commentLine);
                        } else {
                            commentContainer.addComment(commentLine);
                        }
                        commentToken = this.scanner.matchComment();
                    }
                    model.addContainer(commentContainer);
                }
                sepToken = this.scanner.matchSep();
                commentToken = this.scanner.matchComment();
            }
            return true;
        }
        return false;
    }

    private boolean checkAndParseOther(LdifFile model) {
        LdifToken token = this.scanner.matchOther();
        if (token != null) {
            LdifInvalidPart unknownLine = new LdifInvalidPart(token.getOffset(), LdifParser.getValueOrNull(token));
            LdifInvalidContainer otherContainer = new LdifInvalidContainer(unknownLine);
            model.addContainer(otherContainer);
            return true;
        }
        return false;
    }

    private LdifControlLine getControlLine() {
        LdifToken controlSpecToken = this.scanner.matchControlSpec();
        if (controlSpecToken != null) {
            LdifToken controlTypeToken = null;
            LdifToken oidToken = null;
            LdifToken criticalityToken = null;
            LdifToken valueTypeToken = null;
            LdifToken valueToken = null;
            LdifToken sepToken = null;
            controlTypeToken = this.scanner.matchValueType();
            if (controlTypeToken != null && (oidToken = this.scanner.matchOid()) != null) {
                criticalityToken = this.scanner.matchCriticality();
                valueTypeToken = this.scanner.matchValueType();
                if (valueTypeToken != null) {
                    valueToken = this.scanner.matchValue();
                }
                sepToken = this.scanner.matchSep();
            }
            LdifControlLine controlLine = new LdifControlLine(controlSpecToken.getOffset(), LdifParser.getValueOrNull(controlSpecToken), LdifParser.getValueOrNull(controlTypeToken), LdifParser.getValueOrNull(oidToken), LdifParser.getValueOrNull(criticalityToken), LdifParser.getValueOrNull(valueTypeToken), LdifParser.getValueOrNull(valueToken), LdifParser.getValueOrNull(sepToken));
            return controlLine;
        }
        return null;
    }

    private LdifChangeTypeLine getChangeTypeLine() {
        LdifToken changeTypeSpecToken = this.scanner.matchChangeTypeSpec();
        if (changeTypeSpecToken != null) {
            LdifToken changeTypeTypeToken = null;
            LdifToken changeTypeToken = null;
            LdifToken sepToken = null;
            changeTypeTypeToken = this.scanner.matchValueType();
            if (changeTypeTypeToken != null && (changeTypeToken = this.scanner.matchChangeType()) != null) {
                sepToken = this.scanner.matchSep();
            }
            LdifChangeTypeLine ctLine = new LdifChangeTypeLine(changeTypeSpecToken.getOffset(), LdifParser.getValueOrNull(changeTypeSpecToken), LdifParser.getValueOrNull(changeTypeTypeToken), LdifParser.getValueOrNull(changeTypeToken), LdifParser.getValueOrNull(sepToken));
            return ctLine;
        }
        return null;
    }

    private LdifAttrValLine getAttrValLine() {
        LdifToken attrToken = this.scanner.matchAttributeDescription();
        if (attrToken != null) {
            LdifToken valueTypeToken = null;
            LdifToken valueToken = null;
            LdifToken sepToken = null;
            valueTypeToken = this.scanner.matchValueType();
            if (valueTypeToken != null && (valueToken = this.scanner.matchValue()) != null) {
                sepToken = this.scanner.matchSep();
            }
            LdifAttrValLine line = new LdifAttrValLine(attrToken.getOffset(), LdifParser.getValueOrNull(attrToken), LdifParser.getValueOrNull(valueTypeToken), LdifParser.getValueOrNull(valueToken), LdifParser.getValueOrNull(sepToken));
            return line;
        }
        return null;
    }

    private LdifCommentLine[] getCommentLines() {
        ArrayList<LdifCommentLine> list = new ArrayList<LdifCommentLine>(1);
        LdifToken commentToken = this.scanner.matchComment();
        while (commentToken != null) {
            LdifToken sepToken = this.scanner.matchSep();
            list.add(new LdifCommentLine(commentToken.getOffset(), commentToken.getValue(), LdifParser.getValueOrNull(sepToken)));
            commentToken = this.scanner.matchComment();
        }
        return list.toArray(new LdifCommentLine[list.size()]);
    }

    private void cleanupLine(LdifContainer container) {
        LdifToken errorToken = this.scanner.matchCleanupLine();
        if (errorToken != null) {
            container.addInvalid(new LdifInvalidPart(errorToken.getOffset(), errorToken.getValue()));
        }
    }

    private LdifToken cleanupLine() {
        LdifToken errorToken = this.scanner.matchCleanupLine();
        return errorToken;
    }

    private static String getValueOrNull(LdifToken token) {
        return token == null ? null : token.getValue();
    }
}

