/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldifparser.model.lines;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.directory.studio.ldifparser.LdifFormatParameters;
import org.apache.directory.studio.ldifparser.LdifUtils;
import org.apache.directory.studio.ldifparser.model.lines.LdifNonEmptyLineBase;

public class LdifValueLineBase
extends LdifNonEmptyLineBase {
    private static final long serialVersionUID = -7030930374861554147L;
    private String rawValueType;
    private String rawValue;

    protected LdifValueLineBase() {
    }

    public LdifValueLineBase(int offset, String rawLineStart, String rawValueType, String rawValue, String rawNewLine) {
        super(offset, rawLineStart, rawNewLine);
        this.rawValueType = rawValueType;
        this.rawValue = rawValue;
    }

    public String getRawValueType() {
        return LdifValueLineBase.getNonNull(this.rawValueType);
    }

    public String getUnfoldedValueType() {
        return LdifValueLineBase.unfold(this.getRawValueType());
    }

    public String getRawValue() {
        return LdifValueLineBase.getNonNull(this.rawValue);
    }

    public String getUnfoldedValue() {
        return LdifValueLineBase.unfold(this.getRawValue());
    }

    public String toRawString() {
        return this.getRawLineStart() + this.getRawValueType() + this.getRawValue() + this.getRawNewLine();
    }

    public String toFormattedString(LdifFormatParameters formatParameters) {
        int index;
        String raw = this.toRawString();
        String unfolded = LdifValueLineBase.unfold(raw);
        int firstColonIndex = unfolded.indexOf(":");
        int firstDoubleColonIndex = unfolded.indexOf("::");
        int firstColonLessIndex = unfolded.indexOf(":<");
        if (firstDoubleColonIndex > -1 && firstDoubleColonIndex == firstColonIndex) {
            unfolded = unfolded.replaceFirst("::[ ]*", formatParameters.isSpaceAfterColon() ? ":: " : "::");
        } else if (firstColonLessIndex > -1 && firstColonLessIndex == firstColonIndex) {
            unfolded = unfolded.replaceFirst(":<[ ]*", formatParameters.isSpaceAfterColon() ? ":< " : ":<");
        } else if (firstColonIndex > -1) {
            unfolded = unfolded.replaceFirst(":[ ]*", formatParameters.isSpaceAfterColon() ? ": " : ":");
        }
        if (this.rawNewLine != null && (index = unfolded.lastIndexOf(this.rawNewLine)) > -1) {
            unfolded = unfolded.substring(0, unfolded.length() - this.rawNewLine.length());
            unfolded = unfolded + formatParameters.getLineSeparator();
        }
        return LdifValueLineBase.fold(unfolded, 0, formatParameters);
    }

    public boolean isValid() {
        return super.isValid() && this.rawValueType != null && this.rawValue != null;
    }

    public String getInvalidString() {
        if (this.rawValueType == null) {
            return "Missing value type ':', '::' or ':<'";
        }
        if (this.rawValue == null) {
            return "Missing value";
        }
        return super.getInvalidString();
    }

    public final String getValueAsString() {
        Object o = this.getValueAsObject();
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof byte[]) {
            return LdifUtils.utf8decode((byte[])o);
        }
        return "";
    }

    public final byte[] getValueAsBinary() {
        Object o = this.getValueAsObject();
        if (o instanceof String) {
            return LdifUtils.utf8encode((String)o);
        }
        if (o instanceof byte[]) {
            return (byte[])o;
        }
        return new byte[0];
    }

    public final Object getValueAsObject() {
        if (this.isValueTypeSafe()) {
            return this.getUnfoldedValue();
        }
        if (this.isValueTypeBase64()) {
            return LdifUtils.base64decodeToByteArray(this.getUnfoldedValue());
        }
        if (this.isValueTypeURL()) {
            try {
                File file = new File(this.getUnfoldedValue());
                byte[] data = new byte[(int)file.length()];
                FileInputStream fis = new FileInputStream(file);
                fis.read(data);
                return data;
            }
            catch (IOException ioe) {
                return null;
            }
        }
        return null;
    }

    public boolean isValueTypeURL() {
        return this.getUnfoldedValueType().startsWith(":<");
    }

    public boolean isValueTypeBase64() {
        return this.getUnfoldedValueType().startsWith("::");
    }

    public boolean isValueTypeSafe() {
        return this.getUnfoldedValueType().startsWith(":") && !this.isValueTypeBase64() && !this.isValueTypeURL();
    }
}

