/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldifparser.model.lines;

import org.apache.directory.studio.ldifparser.LdifFormatParameters;
import org.apache.directory.studio.ldifparser.model.LdifPart;

public abstract class LdifLineBase
implements LdifPart {
    protected String rawNewLine;
    protected int offset;

    protected LdifLineBase() {
    }

    protected LdifLineBase(int offset, String rawNewLine) {
        this.rawNewLine = rawNewLine;
        this.offset = offset;
    }

    public final String getRawNewLine() {
        return LdifLineBase.getNonNull(this.rawNewLine);
    }

    public String getUnfoldedNewLine() {
        return LdifLineBase.unfold(this.getRawNewLine());
    }

    public final void adjustOffset(int adjust) {
        this.offset += adjust;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final int getLength() {
        return this.toRawString().length();
    }

    public boolean isValid() {
        return this.rawNewLine != null;
    }

    public String getInvalidString() {
        if (this.rawNewLine == null) {
            return "Missing new line";
        }
        return null;
    }

    public String toRawString() {
        return this.getRawNewLine();
    }

    public String toFormattedString(LdifFormatParameters formatParameters) {
        int index;
        String raw = this.toRawString();
        String unfolded = LdifLineBase.unfold(raw);
        if (this.rawNewLine != null && (index = unfolded.lastIndexOf(this.rawNewLine)) > -1) {
            unfolded = unfolded.substring(0, unfolded.length() - this.rawNewLine.length());
            unfolded = unfolded + formatParameters.getLineSeparator();
        }
        return unfolded;
    }

    public final String toString() {
        String text = this.toRawString();
        text = text.replaceAll("\n", "\\\\n");
        text = text.replaceAll("\r", "\\\\r");
        return this.getClass().getName() + " (" + this.getOffset() + "," + this.getLength() + "): '" + text + "'";
    }

    protected static String getNonNull(String s) {
        return s != null ? s : "";
    }

    protected static String unfold(String s) {
        s = s.replaceAll("\n\r ", "");
        s = s.replaceAll("\r\n ", "");
        s = s.replaceAll("\n ", "");
        s = s.replaceAll("\r ", "");
        return s;
    }

    protected static String fold(String value, int indent, LdifFormatParameters formatParameters) {
        StringBuffer formattedLdif = new StringBuffer();
        int offset = formatParameters.getLineWidth() - indent;
        int endIndex = 0 + offset;
        while (endIndex + formatParameters.getLineSeparator().length() < value.length()) {
            formattedLdif.append(value.substring(endIndex - offset, endIndex));
            formattedLdif.append(formatParameters.getLineSeparator());
            formattedLdif.append(' ');
            offset = formatParameters.getLineWidth() - 1;
            endIndex += offset;
        }
        String rest = value.substring(endIndex - offset, value.length());
        formattedLdif.append(rest);
        return formattedLdif.toString();
    }
}

