/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldifparser.model.lines;

import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.studio.ldifparser.LdifParserConstants;
import org.apache.directory.studio.ldifparser.LdifUtils;
import org.apache.directory.studio.ldifparser.model.lines.LdifValueLineBase;

public class LdifDnLine
extends LdifValueLineBase {
    private static final long serialVersionUID = 6180172049870560007L;

    protected LdifDnLine() {
    }

    public LdifDnLine(int offset, String rawDnSpec, String rawValueType, String rawDn, String rawNewLine) {
        super(offset, rawDnSpec, rawValueType, rawDn, rawNewLine);
    }

    public String getRawDnSpec() {
        return super.getRawLineStart();
    }

    public String getUnfoldedDnSpec() {
        return super.getUnfoldedLineStart();
    }

    public String getRawDn() {
        return super.getRawValue();
    }

    public String getUnfoldedDn() {
        return super.getUnfoldedValue();
    }

    public String toRawString() {
        return super.toRawString();
    }

    public boolean isValid() {
        return super.isValid() && LdapDN.isValid((String)this.getValueAsString());
    }

    public String getInvalidString() {
        if (this.getUnfoldedDnSpec().length() == 0) {
            return "Missing DN spec 'dn'";
        }
        if (this.getUnfoldedDn().length() == 0) {
            return "Missing DN";
        }
        if (!LdapDN.isValid((String)this.getValueAsString())) {
            return "Invalid DN";
        }
        return super.getInvalidString();
    }

    public static LdifDnLine create(String dn) {
        if (LdifUtils.mustEncode(dn)) {
            return new LdifDnLine(0, "dn", "::", LdifUtils.base64encode(LdifUtils.utf8encode(dn)), LdifParserConstants.LINE_SEPARATOR);
        }
        return new LdifDnLine(0, "dn", ":", dn, LdifParserConstants.LINE_SEPARATOR);
    }
}

