/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldifparser.model.lines;

import java.io.Serializable;
import org.apache.directory.studio.ldifparser.LdifParserConstants;
import org.apache.directory.studio.ldifparser.LdifUtils;
import org.apache.directory.studio.ldifparser.model.lines.LdifValueLineBase;

public class LdifAttrValLine
extends LdifValueLineBase
implements Serializable {
    private static final long serialVersionUID = 2818131653565822685L;

    protected LdifAttrValLine() {
    }

    public LdifAttrValLine(int offset, String attributeDescripton, String valueType, String value, String newLine) {
        super(offset, attributeDescripton, valueType, value, newLine);
    }

    public String getRawAttributeDescription() {
        return super.getRawLineStart();
    }

    public String getUnfoldedAttributeDescription() {
        return super.getUnfoldedLineStart();
    }

    public boolean isValid() {
        return super.isValid();
    }

    public String getInvalidString() {
        if (this.getUnfoldedAttributeDescription().length() == 0) {
            return "Missing attribute name";
        }
        return super.getInvalidString();
    }

    public static LdifAttrValLine create(String name, String value) {
        if (LdifUtils.mustEncode(value)) {
            return LdifAttrValLine.create(name, LdifUtils.utf8encode(value));
        }
        return new LdifAttrValLine(0, name, ":", value, LdifParserConstants.LINE_SEPARATOR);
    }

    public static LdifAttrValLine create(String name, byte[] value) {
        return new LdifAttrValLine(0, name, "::", LdifUtils.base64encode(value), LdifParserConstants.LINE_SEPARATOR);
    }
}

