/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldifparser.model.container;

import java.util.ArrayList;
import org.apache.directory.studio.ldifparser.model.container.LdifRecord;
import org.apache.directory.studio.ldifparser.model.lines.LdifAttrValLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifDnLine;

public class LdifContentRecord
extends LdifRecord {
    private static final long serialVersionUID = -1410857864284794069L;

    protected LdifContentRecord() {
    }

    public LdifContentRecord(LdifDnLine dn) {
        super(dn);
    }

    public void addAttrVal(LdifAttrValLine attrVal) {
        if (attrVal == null) {
            throw new IllegalArgumentException("null argument");
        }
        this.parts.add(attrVal);
    }

    public LdifAttrValLine[] getAttrVals() {
        ArrayList l = new ArrayList();
        for (Object o : this.parts) {
            if (!(o instanceof LdifAttrValLine)) continue;
            l.add(o);
        }
        return l.toArray(new LdifAttrValLine[l.size()]);
    }

    public static LdifContentRecord create(String dn) {
        return new LdifContentRecord(LdifDnLine.create(dn));
    }

    public boolean isValid() {
        if (!super.isAbstractValid()) {
            return false;
        }
        return this.getAttrVals().length > 0;
    }

    public String getInvalidString() {
        if (this.getAttrVals().length <= 0) {
            return "Record must contain attribute value lines";
        }
        return super.getInvalidString();
    }
}

