/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldifparser.model.container;

import java.util.ArrayList;
import org.apache.directory.studio.ldifparser.model.container.LdifRecord;
import org.apache.directory.studio.ldifparser.model.lines.LdifChangeTypeLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifControlLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifDnLine;

public class LdifChangeRecord
extends LdifRecord {
    private static final long serialVersionUID = 2995003778589275697L;

    protected LdifChangeRecord() {
    }

    public LdifChangeRecord(LdifDnLine dn) {
        super(dn);
    }

    public void addControl(LdifControlLine controlLine) {
        if (controlLine == null) {
            throw new IllegalArgumentException("null argument");
        }
        this.parts.add(controlLine);
    }

    public void setChangeType(LdifChangeTypeLine changeTypeLine) {
        if (changeTypeLine == null) {
            throw new IllegalArgumentException("null argument");
        }
        if (this.getChangeTypeLine() != null) {
            throw new IllegalArgumentException("changetype is already set");
        }
        this.parts.add(changeTypeLine);
    }

    public LdifControlLine[] getControls() {
        ArrayList l = new ArrayList();
        for (Object o : this.parts) {
            if (!(o instanceof LdifControlLine)) continue;
            l.add(o);
        }
        return l.toArray(new LdifControlLine[l.size()]);
    }

    public LdifChangeTypeLine getChangeTypeLine() {
        for (Object o : this.parts) {
            if (!(o instanceof LdifChangeTypeLine)) continue;
            return (LdifChangeTypeLine)o;
        }
        return null;
    }

    protected boolean isAbstractValid() {
        if (!super.isAbstractValid()) {
            return false;
        }
        return this.getChangeTypeLine() != null;
    }

    public boolean isValid() {
        return this.isAbstractValid();
    }

    public String getInvalidString() {
        if (this.getChangeTypeLine() == null) {
            return "Missing changetype line";
        }
        return super.getInvalidString();
    }
}

