/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldifparser.model.container;

import org.apache.directory.studio.ldifparser.model.container.LdifChangeRecord;
import org.apache.directory.studio.ldifparser.model.lines.LdifChangeTypeLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifDeloldrdnLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifDnLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifNewrdnLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifNewsuperiorLine;

public class LdifChangeModDnRecord
extends LdifChangeRecord {
    private static final long serialVersionUID = 4439094400671169207L;

    protected LdifChangeModDnRecord() {
    }

    public LdifChangeModDnRecord(LdifDnLine dn) {
        super(dn);
    }

    public void setNewrdn(LdifNewrdnLine newrdn) {
        if (newrdn == null) {
            throw new IllegalArgumentException("null argument");
        }
        this.parts.add(newrdn);
    }

    public void setDeloldrdn(LdifDeloldrdnLine deloldrdn) {
        if (deloldrdn == null) {
            throw new IllegalArgumentException("null argument");
        }
        this.parts.add(deloldrdn);
    }

    public void setNewsuperior(LdifNewsuperiorLine newsuperior) {
        if (newsuperior == null) {
            throw new IllegalArgumentException("null argument");
        }
        this.parts.add(newsuperior);
    }

    public LdifNewrdnLine getNewrdnLine() {
        for (Object o : this.parts) {
            if (!(o instanceof LdifNewrdnLine)) continue;
            return (LdifNewrdnLine)o;
        }
        return null;
    }

    public LdifDeloldrdnLine getDeloldrdnLine() {
        for (Object o : this.parts) {
            if (!(o instanceof LdifDeloldrdnLine)) continue;
            return (LdifDeloldrdnLine)o;
        }
        return null;
    }

    public LdifNewsuperiorLine getNewsuperiorLine() {
        for (Object o : this.parts) {
            if (!(o instanceof LdifNewsuperiorLine)) continue;
            return (LdifNewsuperiorLine)o;
        }
        return null;
    }

    public static LdifChangeModDnRecord create(String dn) {
        LdifChangeModDnRecord record = new LdifChangeModDnRecord(LdifDnLine.create(dn));
        record.setChangeType(LdifChangeTypeLine.createModDn());
        return record;
    }

    public boolean isValid() {
        if (!super.isAbstractValid()) {
            return false;
        }
        return this.getNewrdnLine() != null && this.getDeloldrdnLine() != null;
    }

    public String getInvalidString() {
        if (this.getNewrdnLine() == null) {
            return "Missing new RDN";
        }
        if (this.getDeloldrdnLine() == null) {
            return "Missing delete old RDN";
        }
        return super.getInvalidString();
    }
}

